/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.block.BlockBase;
import teamroots.embers.block.IDial;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageTEUpdateRequest;
import teamroots.embers.power.EmberCapabilityProvider;
import teamroots.embers.power.IEmberCapability;
import teamroots.embers.util.Misc;

public class BlockEmberGauge
extends BlockBase
implements IDial {
    public static final PropertyDirection facing = PropertyDirection.func_177714_a((String)"facing");

    public BlockEmberGauge(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{facing});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)facing)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)facing, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)facing, (Comparable)face);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.func_175623_d(pos.func_177967_a((EnumFacing)state.func_177229_b((IProperty)facing), -1))) {
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, state, 0);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)facing)) {
            case UP: {
                return new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.125, 0.6875);
            }
            case DOWN: {
                return new AxisAlignedBB(0.3125, 0.875, 0.3125, 0.6875, 1.0, 0.6875);
            }
            case NORTH: {
                return new AxisAlignedBB(0.3125, 0.3125, 0.875, 0.6875, 0.6875, 1.0);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 0.125);
            }
            case WEST: {
                return new AxisAlignedBB(0.875, 0.3125, 0.3125, 1.0, 0.6875, 0.6875);
            }
            case EAST: {
                return new AxisAlignedBB(0.0, 0.3125, 0.3125, 0.125, 0.6875, 0.6875);
            }
        }
        return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.125, 0.75);
    }

    @Override
    public List<String> getDisplayInfo(World world, BlockPos pos, IBlockState state) {
        IEmberCapability handler;
        ArrayList<String> text = new ArrayList<String>();
        if (world.func_175625_s(pos.func_177972_a(Misc.getOppositeFace((EnumFacing)state.func_177229_b((IProperty)facing)))) != null && world.func_175625_s(pos.func_177972_a(Misc.getOppositeFace((EnumFacing)state.func_177229_b((IProperty)facing)))).hasCapability(EmberCapabilityProvider.emberCapability, (EnumFacing)state.func_177229_b((IProperty)facing)) && (handler = (IEmberCapability)world.func_175625_s(pos.func_177972_a(Misc.getOppositeFace((EnumFacing)state.func_177229_b((IProperty)facing)))).getCapability(EmberCapabilityProvider.emberCapability, (EnumFacing)state.func_177229_b((IProperty)facing))) != null) {
            text.add(I18n.func_135052_a((String)"embers.tooltip.emberdial.ember", (Object[])new Object[0]) + handler.getEmber() + "/" + handler.getEmberCapacity());
        }
        return text;
    }

    @Override
    public void updateTEData(World world, IBlockState state, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos.func_177972_a(Misc.getOppositeFace((EnumFacing)state.func_177229_b((IProperty)facing))));
        if (tile != null) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageTEUpdateRequest(Minecraft.func_71410_x().field_71439_g.func_110124_au(), pos));
        }
    }
}

