/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import teamroots.embers.EventManager;
import teamroots.embers.RegistryManager;
import teamroots.embers.item.ItemTinkerHammer;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityFluidPipe;
import teamroots.embers.util.Misc;

public class TileEntityFluidExtractor
extends TileFluidHandler
implements ITileEntityBase,
ITickable {
    Random random = new Random();
    List<EnumFacing> from = new ArrayList<EnumFacing>();
    public TileEntityFluidPipe.EnumPipeConnection up = TileEntityFluidPipe.EnumPipeConnection.NONE;
    public TileEntityFluidPipe.EnumPipeConnection down = TileEntityFluidPipe.EnumPipeConnection.NONE;
    public TileEntityFluidPipe.EnumPipeConnection north = TileEntityFluidPipe.EnumPipeConnection.NONE;
    public TileEntityFluidPipe.EnumPipeConnection south = TileEntityFluidPipe.EnumPipeConnection.NONE;
    public TileEntityFluidPipe.EnumPipeConnection east = TileEntityFluidPipe.EnumPipeConnection.NONE;
    public TileEntityFluidPipe.EnumPipeConnection west = TileEntityFluidPipe.EnumPipeConnection.NONE;
    public boolean dirty = false;

    public static TileEntityFluidPipe.EnumPipeConnection connectionFromInt(int value) {
        switch (value) {
            case 0: {
                return TileEntityFluidPipe.EnumPipeConnection.NONE;
            }
            case 1: {
                return TileEntityFluidPipe.EnumPipeConnection.PIPE;
            }
            case 2: {
                return TileEntityFluidPipe.EnumPipeConnection.BLOCK;
            }
            case 3: {
                return TileEntityFluidPipe.EnumPipeConnection.LEVER;
            }
            case 4: {
                return TileEntityFluidPipe.EnumPipeConnection.FORCENONE;
            }
        }
        return TileEntityFluidPipe.EnumPipeConnection.NONE;
    }

    public TileEntityFluidExtractor() {
        this.tank.setCapacity(1000);
    }

    public void updateNeighbors(IBlockAccess world) {
        this.up = this.getConnection(world, this.func_174877_v().func_177984_a(), EnumFacing.UP);
        this.down = this.getConnection(world, this.func_174877_v().func_177977_b(), EnumFacing.DOWN);
        this.north = this.getConnection(world, this.func_174877_v().func_177978_c(), EnumFacing.NORTH);
        this.south = this.getConnection(world, this.func_174877_v().func_177968_d(), EnumFacing.SOUTH);
        this.west = this.getConnection(world, this.func_174877_v().func_177976_e(), EnumFacing.WEST);
        this.east = this.getConnection(world, this.func_174877_v().func_177974_f(), EnumFacing.EAST);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("up", this.up.ordinal());
        tag.func_74768_a("down", this.down.ordinal());
        tag.func_74768_a("north", this.north.ordinal());
        tag.func_74768_a("south", this.south.ordinal());
        tag.func_74768_a("west", this.west.ordinal());
        tag.func_74768_a("east", this.east.ordinal());
        NBTTagList l = new NBTTagList();
        for (EnumFacing f : this.from) {
            l.func_74742_a((NBTBase)new NBTTagInt(f.func_176745_a()));
        }
        tag.func_74782_a("from", (NBTBase)l);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.up = TileEntityFluidExtractor.connectionFromInt(tag.func_74762_e("up"));
        this.down = TileEntityFluidExtractor.connectionFromInt(tag.func_74762_e("down"));
        this.north = TileEntityFluidExtractor.connectionFromInt(tag.func_74762_e("north"));
        this.south = TileEntityFluidExtractor.connectionFromInt(tag.func_74762_e("south"));
        this.west = TileEntityFluidExtractor.connectionFromInt(tag.func_74762_e("west"));
        this.east = TileEntityFluidExtractor.connectionFromInt(tag.func_74762_e("east"));
        NBTTagList l = tag.func_150295_c("from", 3);
        for (int i = 0; i < l.func_74745_c(); ++i) {
            this.from.add(EnumFacing.func_82600_a((int)l.func_186858_c(i)));
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem != ItemStack.field_190927_a && heldItem != ItemStack.field_190927_a && heldItem.func_77973_b() instanceof ItemTinkerHammer) {
            if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.west = TileEntityFluidExtractor.reverseForce(this.west);
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.east = TileEntityFluidExtractor.reverseForce(this.east);
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.north = TileEntityFluidExtractor.reverseForce(this.north);
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.south = TileEntityFluidExtractor.reverseForce(this.south);
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                if (Math.abs((double)hitY - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitY < 0.5) {
                        this.down = TileEntityFluidExtractor.reverseForce(this.down);
                        this.reverseConnection(EnumFacing.DOWN);
                    } else {
                        this.up = TileEntityFluidExtractor.reverseForce(this.up);
                        this.reverseConnection(EnumFacing.UP);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.north = TileEntityFluidExtractor.reverseForce(this.north);
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.south = TileEntityFluidExtractor.reverseForce(this.south);
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitY - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.west = TileEntityFluidExtractor.reverseForce(this.west);
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.east = TileEntityFluidExtractor.reverseForce(this.east);
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitY < 0.5) {
                    this.down = TileEntityFluidExtractor.reverseForce(this.down);
                    this.reverseConnection(EnumFacing.DOWN);
                } else {
                    this.up = TileEntityFluidExtractor.reverseForce(this.up);
                    this.reverseConnection(EnumFacing.UP);
                }
            }
            this.updateNeighbors((IBlockAccess)world);
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public TileEntityFluidPipe.EnumPipeConnection getConnection(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return this.up;
        }
        if (side == EnumFacing.DOWN) {
            return this.down;
        }
        if (side == EnumFacing.EAST) {
            return this.east;
        }
        if (side == EnumFacing.WEST) {
            return this.west;
        }
        if (side == EnumFacing.NORTH) {
            return this.north;
        }
        if (side == EnumFacing.SOUTH) {
            return this.south;
        }
        return TileEntityFluidPipe.EnumPipeConnection.NONE;
    }

    public void setConnection(EnumFacing side, TileEntityFluidPipe.EnumPipeConnection connect) {
        if (side == EnumFacing.UP) {
            this.up = connect;
        } else if (side == EnumFacing.DOWN) {
            this.down = connect;
        } else if (side == EnumFacing.EAST) {
            this.east = connect;
        } else if (side == EnumFacing.WEST) {
            this.west = connect;
        } else if (side == EnumFacing.NORTH) {
            this.north = connect;
        } else if (side == EnumFacing.SOUTH) {
            this.south = connect;
        }
    }

    public void reverseConnection(EnumFacing face) {
    }

    public static TileEntityFluidPipe.EnumPipeConnection reverseForce(TileEntityFluidPipe.EnumPipeConnection connect) {
        if (connect == TileEntityFluidPipe.EnumPipeConnection.FORCENONE) {
            return TileEntityFluidPipe.EnumPipeConnection.NONE;
        }
        if (connect != TileEntityFluidPipe.EnumPipeConnection.NONE && connect != TileEntityFluidPipe.EnumPipeConnection.LEVER) {
            return TileEntityFluidPipe.EnumPipeConnection.FORCENONE;
        }
        return TileEntityFluidPipe.EnumPipeConnection.NONE;
    }

    public TileEntityFluidPipe.EnumPipeConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing face;
        if (this.getConnection(side) == TileEntityFluidPipe.EnumPipeConnection.FORCENONE) {
            return TileEntityFluidPipe.EnumPipeConnection.FORCENONE;
        }
        if (world.func_175625_s(pos) instanceof TileEntityFluidPipe) {
            return TileEntityFluidPipe.EnumPipeConnection.PIPE;
        }
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) && !(world.func_175625_s(pos) instanceof TileEntityFluidExtractor)) {
            return TileEntityFluidPipe.EnumPipeConnection.BLOCK;
        }
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150442_at ? (face = ((BlockLever.EnumOrientation)world.func_180495_p(pos).func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c()) == side || face == EnumFacing.DOWN && side == EnumFacing.UP || face == EnumFacing.UP && side == EnumFacing.DOWN : (world.func_180495_p(pos).func_177230_c() == Blocks.field_150430_aB ? (face = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockButton.field_176387_N)) == side : (world.func_180495_p(pos).func_177230_c() == Blocks.field_150429_aA ? (face = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockRedstoneTorch.field_176596_a)) == side : world.func_180495_p(pos).func_177230_c() == RegistryManager.caminite_lever && ((face = ((BlockLever.EnumOrientation)world.func_180495_p(pos).func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c()) == side || face == EnumFacing.DOWN && side == EnumFacing.UP || face == EnumFacing.UP && side == EnumFacing.DOWN)))) {
            return TileEntityFluidPipe.EnumPipeConnection.LEVER;
        }
        return TileEntityFluidPipe.EnumPipeConnection.NONE;
    }

    public boolean isConnected(EnumFacing face) {
        TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(face));
        if (tile instanceof TileEntityFluidPipe && ((TileEntityFluidPipe)tile).getConnection(Misc.getOppositeFace(face)) != TileEntityFluidPipe.EnumPipeConnection.FORCENONE && ((TileEntityFluidPipe)tile).getConnection(Misc.getOppositeFace(face)) != TileEntityFluidPipe.EnumPipeConnection.NONE) {
            return true;
        }
        if (tile instanceof TileEntityFluidExtractor && ((TileEntityFluidExtractor)tile).getConnection(Misc.getOppositeFace(face)) != TileEntityFluidPipe.EnumPipeConnection.FORCENONE && ((TileEntityFluidExtractor)tile).getConnection(Misc.getOppositeFace(face)) != TileEntityFluidPipe.EnumPipeConnection.NONE) {
            return true;
        }
        return this.getConnection(face) == TileEntityFluidPipe.EnumPipeConnection.BLOCK;
    }

    public void func_73660_a() {
        this.from.clear();
        boolean on = this.func_145831_w().func_175687_A(this.func_174877_v()) != 0;
        ArrayList<BlockPos> toUpdate = new ArrayList<BlockPos>();
        if (this.tank.getFluidAmount() < this.tank.getCapacity() && on) {
            ArrayList<EnumFacing> connectedFaces = new ArrayList<EnumFacing>();
            if (this.up == TileEntityFluidPipe.EnumPipeConnection.BLOCK && this.isConnected(EnumFacing.UP)) {
                connectedFaces.add(EnumFacing.UP);
            }
            if (this.down == TileEntityFluidPipe.EnumPipeConnection.BLOCK && this.isConnected(EnumFacing.DOWN)) {
                connectedFaces.add(EnumFacing.DOWN);
            }
            if (this.north == TileEntityFluidPipe.EnumPipeConnection.BLOCK && this.isConnected(EnumFacing.NORTH)) {
                connectedFaces.add(EnumFacing.NORTH);
            }
            if (this.south == TileEntityFluidPipe.EnumPipeConnection.BLOCK && this.isConnected(EnumFacing.SOUTH)) {
                connectedFaces.add(EnumFacing.SOUTH);
            }
            if (this.west == TileEntityFluidPipe.EnumPipeConnection.BLOCK && this.isConnected(EnumFacing.WEST)) {
                connectedFaces.add(EnumFacing.WEST);
            }
            if (this.east == TileEntityFluidPipe.EnumPipeConnection.BLOCK && this.isConnected(EnumFacing.EAST)) {
                connectedFaces.add(EnumFacing.EAST);
            }
            for (int i = 0; i < connectedFaces.size(); ++i) {
                IFluidHandler handler;
                TileEntity t = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)));
                if (t == null || t instanceof TileEntityFluidPipe || !t.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) || (handler = (IFluidHandler)this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i))).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, ((EnumFacing)connectedFaces.get(i)).func_176734_d())) == null) continue;
                this.from.add((EnumFacing)connectedFaces.get(i));
                IFluidTankProperties[] properties = handler.getTankProperties();
                for (int j = 0; j < properties.length && this.tank.getFluidAmount() < this.tank.getCapacity(); ++j) {
                    FluidStack stack = properties[j].getContents();
                    if (stack == null) continue;
                    if (t.getClass() == TileEntityFluidPipe.class) {
                        ((TileEntityFluidPipe)t).from.add(Misc.getOppositeFace((EnumFacing)connectedFaces.get(i)));
                    }
                    int toFill = this.tank.fill(stack, false);
                    FluidStack taken = handler.drain(new FluidStack(stack.getFluid(), toFill), true);
                    this.tank.fill(taken, true);
                    IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                    if (!toUpdate.contains(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)))) {
                        toUpdate.add(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)));
                    }
                    if (toUpdate.contains(this.func_174877_v())) continue;
                    toUpdate.add(this.func_174877_v());
                }
            }
        }
        if (this.tank.getFluid() != null) {
            int distAmount = Math.min(this.tank.getFluidAmount(), 120);
            ArrayList<EnumFacing> connectedFaces = new ArrayList<EnumFacing>();
            if ((this.up == TileEntityFluidPipe.EnumPipeConnection.PIPE || !on && this.up == TileEntityFluidPipe.EnumPipeConnection.BLOCK) && !this.from.contains(EnumFacing.UP)) {
                connectedFaces.add(EnumFacing.UP);
            }
            if ((this.down == TileEntityFluidPipe.EnumPipeConnection.PIPE || !on && this.down == TileEntityFluidPipe.EnumPipeConnection.BLOCK) && !this.from.contains(EnumFacing.DOWN)) {
                connectedFaces.add(EnumFacing.DOWN);
            }
            if ((this.north == TileEntityFluidPipe.EnumPipeConnection.PIPE || !on && this.north == TileEntityFluidPipe.EnumPipeConnection.BLOCK) && !this.from.contains(EnumFacing.NORTH)) {
                connectedFaces.add(EnumFacing.NORTH);
            }
            if ((this.south == TileEntityFluidPipe.EnumPipeConnection.PIPE || !on && this.south == TileEntityFluidPipe.EnumPipeConnection.BLOCK) && !this.from.contains(EnumFacing.SOUTH)) {
                connectedFaces.add(EnumFacing.SOUTH);
            }
            if ((this.west == TileEntityFluidPipe.EnumPipeConnection.PIPE || !on && this.west == TileEntityFluidPipe.EnumPipeConnection.BLOCK) && !this.from.contains(EnumFacing.WEST)) {
                connectedFaces.add(EnumFacing.WEST);
            }
            if ((this.east == TileEntityFluidPipe.EnumPipeConnection.PIPE || !on && this.east == TileEntityFluidPipe.EnumPipeConnection.BLOCK) && !this.from.contains(EnumFacing.EAST)) {
                connectedFaces.add(EnumFacing.EAST);
            }
            int count = 0;
            if (connectedFaces.size() >= 1) {
                for (int i = 0; i < connectedFaces.size(); ++i) {
                    IFluidHandler handler;
                    TileEntity t = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)));
                    if (t == null || this.tank.getFluid() == null || !t.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Misc.getOppositeFace((EnumFacing)connectedFaces.get(i))) || (handler = (IFluidHandler)t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, ((EnumFacing)connectedFaces.get(i)).func_176734_d())) == null) continue;
                    int capacity = 0;
                    int amount = 0;
                    for (IFluidTankProperties p : handler.getTankProperties()) {
                        capacity += p.getCapacity();
                        if (p.getContents() == null) continue;
                        amount += p.getContents().amount;
                    }
                    if (amount >= capacity) continue;
                    ++count;
                }
            }
            if (count >= 1) {
                int toEach = Math.max(1, distAmount / count);
                for (int i = 0; i < connectedFaces.size(); ++i) {
                    IFluidHandler handler;
                    TileEntity t = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)));
                    if (t == null || toEach <= 0 || this.tank.getFluid() == null || !t.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, ((EnumFacing)connectedFaces.get(i)).func_176734_d()) || (handler = (IFluidHandler)t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, ((EnumFacing)connectedFaces.get(i)).func_176734_d())) == null || this.tank.getFluid() == null || this.tank.getFluid().getFluid() == null) continue;
                    if (t instanceof TileEntityFluidPipe) {
                        ((TileEntityFluidPipe)t).from.add(((EnumFacing)connectedFaces.get(i)).func_176734_d());
                    }
                    FluidStack toAdd = new FluidStack(this.tank.getFluid().getFluid(), toEach);
                    int filled = handler.fill(toAdd, true);
                    this.tank.drainInternal(new FluidStack(this.tank.getFluid().getFluid(), filled), true);
                    if (!toUpdate.contains(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)))) {
                        toUpdate.add(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)));
                    }
                    if (toUpdate.contains(this.func_174877_v())) continue;
                    toUpdate.add(this.func_174877_v());
                }
            }
        }
        for (int i = 0; i < toUpdate.size(); ++i) {
            TileEntity tile = this.func_145831_w().func_175625_s((BlockPos)toUpdate.get(i));
            tile.func_70296_d();
            if (this.func_145831_w().field_72995_K || tile instanceof ITileEntityBase) continue;
            tile.func_70296_d();
            EventManager.markTEForUpdate((BlockPos)toUpdate.get(i), tile);
        }
        this.func_70296_d();
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), (TileEntity)this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }
}

