/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.EventManager;
import teamroots.embers.RegistryManager;
import teamroots.embers.block.BlockInfernoForge;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberActivationFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.power.EmberCapabilityProvider;
import teamroots.embers.power.IEmberCapability;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityInfernoForgeOpening;
import teamroots.embers.util.EmberGenUtil;
import teamroots.embers.util.ItemModUtil;
import teamroots.embers.util.Misc;

public class TileEntityInfernoForge
extends TileEntity
implements ITileEntityBase,
ITickable,
IMultiblockMachine {
    public IEmberCapability capability = new DefaultEmberCapability();
    Random random = new Random();
    int progress = 0;
    int heat = 0;
    int ticksExisted = 0;
    public boolean dirty = false;

    public TileEntityInfernoForge() {
        this.capability.setEmberCapacity(32000.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        tag.func_74768_a("progress", this.progress);
        tag.func_74768_a("heat", this.heat);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
        if (tag.func_74764_b("heat")) {
            this.heat = tag.func_74762_e("heat");
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        ((BlockInfernoForge)state.func_177230_c()).cleanEdges(world, pos);
        world.func_175690_a(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (this.progress > 0) {
            if (this.capability.getEmber() >= 16.0) {
                this.capability.removeAmount(16.0, true);
                --this.progress;
                if (this.func_145831_w().field_72995_K) {
                    if (this.random.nextInt(10) == 0) {
                        if (this.random.nextInt(3) == 0) {
                            ParticleUtil.spawnParticleSpark(this.field_145850_b, (float)this.func_174877_v().func_177958_n() - 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 1.75f, (float)this.func_174877_v().func_177952_p() - 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, this.random.nextFloat() * 0.75f + 0.45f, 80);
                        }
                        if (this.random.nextInt(3) == 0) {
                            ParticleUtil.spawnParticleSpark(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 1.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 1.75f, (float)this.func_174877_v().func_177952_p() - 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, this.random.nextFloat() * 0.75f + 0.45f, 80);
                        }
                        if (this.random.nextInt(3) == 0) {
                            ParticleUtil.spawnParticleSpark(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 1.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 1.75f, (float)this.func_174877_v().func_177952_p() + 1.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, this.random.nextFloat() * 0.75f + 0.45f, 80);
                        }
                        if (this.random.nextInt(3) == 0) {
                            ParticleUtil.spawnParticleSpark(this.field_145850_b, (float)this.func_174877_v().func_177958_n() - 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 1.75f, (float)this.func_174877_v().func_177952_p() + 1.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, this.random.nextFloat() * 0.75f + 0.45f, 80);
                        }
                    }
                    ParticleUtil.spawnParticleSmoke(this.func_145831_w(), (float)this.func_174877_v().func_177958_n() - 0.3f, (float)this.func_174877_v().func_177956_o() + 1.85f, (float)this.func_174877_v().func_177952_p() - 0.3f, 0.025f * (this.random.nextFloat() - 0.5f), 0.05f * (this.random.nextFloat() + 1.0f), 0.025f * (this.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 1.0f, 3.0f + 3.0f * this.random.nextFloat(), 48);
                    ParticleUtil.spawnParticleSmoke(this.func_145831_w(), (float)this.func_174877_v().func_177958_n() + 1.3f, (float)this.func_174877_v().func_177956_o() + 1.85f, (float)this.func_174877_v().func_177952_p() - 0.3f, 0.025f * (this.random.nextFloat() - 0.5f), 0.05f * (this.random.nextFloat() + 1.0f), 0.025f * (this.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 1.0f, 3.0f + 3.0f * this.random.nextFloat(), 48);
                    ParticleUtil.spawnParticleSmoke(this.func_145831_w(), (float)this.func_174877_v().func_177958_n() + 1.3f, (float)this.func_174877_v().func_177956_o() + 1.85f, (float)this.func_174877_v().func_177952_p() + 1.3f, 0.025f * (this.random.nextFloat() - 0.5f), 0.05f * (this.random.nextFloat() + 1.0f), 0.025f * (this.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 1.0f, 3.0f + 3.0f * this.random.nextFloat(), 48);
                    ParticleUtil.spawnParticleSmoke(this.func_145831_w(), (float)this.func_174877_v().func_177958_n() - 0.3f, (float)this.func_174877_v().func_177956_o() + 1.85f, (float)this.func_174877_v().func_177952_p() + 1.3f, 0.025f * (this.random.nextFloat() - 0.5f), 0.05f * (this.random.nextFloat() + 1.0f), 0.025f * (this.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 1.0f, 3.0f + 3.0f * this.random.nextFloat(), 48);
                }
                List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o() + 0.25, (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)));
                for (EntityItem e : items) {
                    e.func_174867_a(20);
                }
                if (this.progress == 0 && !this.field_145850_b.field_72995_K) {
                    ItemStack item = ItemStack.field_190927_a;
                    double emberValue = 0.0;
                    for (int i = 0; i < items.size(); ++i) {
                        if (ItemModUtil.hasHeat(((EntityItem)items.get(i)).func_92059_d())) {
                            if (item.func_190926_b() && ItemModUtil.getLevel(((EntityItem)items.get(i)).func_92059_d()) <= 5 && ItemModUtil.getHeat(((EntityItem)items.get(i)).func_92059_d()) >= ItemModUtil.getMaxHeat(((EntityItem)items.get(i)).func_92059_d())) {
                                item = ((EntityItem)items.get(i)).func_92059_d();
                                continue;
                            }
                            this.progress = 0;
                            this.func_70296_d();
                            return;
                        }
                        if (EmberGenUtil.getEmberForItem(((EntityItem)items.get(i)).func_92059_d().func_77973_b()) > 0.0) {
                            emberValue += EmberGenUtil.getEmberForItem(((EntityItem)items.get(i)).func_92059_d().func_77973_b());
                            continue;
                        }
                        this.progress = 0;
                        this.func_70296_d();
                        return;
                    }
                    if (!item.func_190926_b() && emberValue > 0.0 && emberValue <= EmberGenUtil.getEmberForItem(RegistryManager.ember_cluster) * 3.0) {
                        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
                        if (tile instanceof TileEntityInfernoForgeOpening) {
                            ((TileEntityInfernoForgeOpening)tile).isOpen = true;
                            ((TileEntityInfernoForgeOpening)tile).prevState = false;
                            ((TileEntityInfernoForgeOpening)tile).func_70296_d();
                        }
                        if (!this.field_145850_b.field_72995_K) {
                            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberActivationFX((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.5, (double)this.func_174877_v().func_177952_p() + 0.5));
                        }
                        for (int i = 0; i < items.size(); ++i) {
                            if (!ItemModUtil.hasHeat(((EntityItem)items.get(i)).func_92059_d())) {
                                this.field_145850_b.func_72900_e((Entity)items.get(i));
                                ((EntityItem)items.get(i)).func_70106_y();
                                continue;
                            }
                            if (!(Math.atan(emberValue / 1200.0) > (double)Misc.random.nextFloat())) continue;
                            ItemStack stack = ((EntityItem)items.get(i)).func_92059_d();
                            ItemModUtil.setHeat(stack, 0.0f);
                            ItemModUtil.setLevel(stack, ItemModUtil.getLevel(stack) + 1);
                            ((EntityItem)items.get(i)).func_92058_a(stack);
                            this.progress = 0;
                        }
                    }
                }
            } else {
                this.progress = 0;
            }
            this.func_70296_d();
        }
    }

    public void updateProgress() {
        if (this.progress == 0) {
            List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o() + 0.25, (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)));
            ItemStack item = ItemStack.field_190927_a;
            double emberValue = 0.0;
            for (int i = 0; i < items.size(); ++i) {
                if (ItemModUtil.hasHeat(((EntityItem)items.get(i)).func_92059_d())) {
                    if (item.func_190926_b() && ItemModUtil.getLevel(((EntityItem)items.get(i)).func_92059_d()) < 5 && ItemModUtil.getHeat(((EntityItem)items.get(i)).func_92059_d()) >= ItemModUtil.getMaxHeat(((EntityItem)items.get(i)).func_92059_d())) {
                        item = ((EntityItem)items.get(i)).func_92059_d();
                        continue;
                    }
                    return;
                }
                if (EmberGenUtil.getEmberForItem(((EntityItem)items.get(i)).func_92059_d().func_77973_b()) > 0.0) {
                    emberValue += EmberGenUtil.getEmberForItem(((EntityItem)items.get(i)).func_92059_d().func_77973_b());
                    continue;
                }
                return;
            }
            if (!item.func_190926_b() && emberValue > 0.0 && emberValue < EmberGenUtil.getEmberForItem(RegistryManager.ember_cluster) * 3.0) {
                this.progress = 200;
                this.func_70296_d();
            }
        }
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }
}

