/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import teamroots.embers.EventManager;
import teamroots.embers.RegistryManager;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;

public class TileEntityLargeTank
extends TileFluidHandler
implements ITileEntityBase,
ITickable,
IMultiblockMachine {
    int ticksExisted = 0;
    public boolean dirty = false;

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(4.0, 256.0, 4.0);
    }

    public TileEntityLargeTank() {
        this.tank = new FluidTank(Integer.MAX_VALUE){

            public void onContentsChanged() {
                TileEntityLargeTank.this.func_70296_d();
            }
        };
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(true);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem != ItemStack.field_190927_a && (heldItem.func_77973_b() instanceof ItemBucket || heldItem.func_77973_b() instanceof UniversalBucket)) {
            boolean didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)));
            this.func_70296_d();
            return didFill;
        }
        return false;
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public int getAmount() {
        return this.tank.getFluidAmount();
    }

    public Fluid getFluid() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175698_g(pos.func_177982_a(1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, -1));
        world.func_175698_g(pos.func_177982_a(1, 0, -1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 1));
        world.func_175698_g(pos.func_177982_a(1, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, -1));
        world.func_175690_a(pos, null);
    }

    public void updateCapacity() {
        int capacity = 0;
        int i = 1;
        while (this.func_145831_w().func_180495_p(this.func_174877_v().func_177982_a(0, i, 0)) == RegistryManager.stone_edge.func_176203_a(8)) {
            capacity += 40000;
            ++i;
        }
        this.tank.setCapacity(capacity);
        if (this.tank.getFluid() != null) {
            this.tank.setFluid(new FluidStack(this.tank.getFluid().getFluid(), Math.min(this.tank.getFluidAmount(), this.tank.getCapacity())));
        }
        this.func_70296_d();
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (this.ticksExisted % 20 == 0) {
            this.updateCapacity();
        }
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), (TileEntity)this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }
}

