/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import teamroots.embers.EventManager;
import teamroots.embers.recipe.FluidMixingRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityMixerTop;

public class TileEntityMixerBottom
extends TileEntity
implements ITileEntityBase,
ITickable {
    public FluidTank north = new FluidTank(8000);
    public FluidTank south = new FluidTank(8000);
    public FluidTank east = new FluidTank(8000);
    public FluidTank west = new FluidTank(8000);
    Random random = new Random();
    int progress = -1;
    public boolean dirty = false;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound northTank = new NBTTagCompound();
        this.north.writeToNBT(tag);
        tag.func_74782_a("northTank", (NBTBase)northTank);
        NBTTagCompound southTank = new NBTTagCompound();
        this.south.writeToNBT(tag);
        tag.func_74782_a("southTank", (NBTBase)southTank);
        NBTTagCompound eastTank = new NBTTagCompound();
        this.east.writeToNBT(tag);
        tag.func_74782_a("eastTank", (NBTBase)eastTank);
        NBTTagCompound westTank = new NBTTagCompound();
        this.west.writeToNBT(tag);
        tag.func_74782_a("westTank", (NBTBase)westTank);
        tag.func_74768_a("progress", this.progress);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.north.readFromNBT(tag.func_74775_l("northTank"));
        this.south.readFromNBT(tag.func_74775_l("southTank"));
        this.east.readFromNBT(tag.func_74775_l("eastTank"));
        this.west.readFromNBT(tag.func_74775_l("westTank"));
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null) {
            switch (facing) {
                case DOWN: 
                case EAST: {
                    return (T)this.east;
                }
                case NORTH: {
                    return (T)this.north;
                }
                case SOUTH: {
                    return (T)this.south;
                }
                case UP: 
                case WEST: {
                    return (T)this.west;
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        TileEntityMixerTop top = (TileEntityMixerTop)this.func_145831_w().func_175625_s(this.func_174877_v().func_177984_a());
        if (top != null && top.capability.getEmber() >= 2.0) {
            IFluidHandler tank;
            int amount;
            FluidMixingRecipe recipe;
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            if (this.north.getFluid() != null) {
                fluids.add(this.north.getFluid());
            }
            if (this.south.getFluid() != null) {
                fluids.add(this.south.getFluid());
            }
            if (this.east.getFluid() != null) {
                fluids.add(this.east.getFluid());
            }
            if (this.west.getFluid() != null) {
                fluids.add(this.west.getFluid());
            }
            if ((recipe = RecipeRegistry.getMixingRecipe(fluids)) != null && (amount = (tank = (IFluidHandler)top.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fill(recipe.output, false)) != 0) {
                tank.fill(recipe.output, true);
                for (int i = 0; i < fluids.size(); ++i) {
                    boolean doContinue = true;
                    for (int j = 0; j < recipe.inputs.size() && doContinue; ++j) {
                        if (recipe.inputs.get(j) == null || fluids.get(i) == null || recipe.inputs.get(j).getFluid() != fluids.get(i).getFluid()) continue;
                        doContinue = false;
                        fluids.get((int)i).amount -= recipe.inputs.get((int)j).amount;
                    }
                }
                top.capability.removeAmount(2.0, true);
                this.func_70296_d();
                IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                top.func_70296_d();
                IBlockState iBlockState = this.func_145831_w().func_180495_p(this.func_174877_v().func_177984_a());
            }
        }
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }
}

