/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.EventManager;
import teamroots.embers.RegistryManager;
import teamroots.embers.block.BlockStamper;
import teamroots.embers.item.EnumStampType;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageStamperFX;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.power.EmberCapabilityProvider;
import teamroots.embers.power.IEmberCapability;
import teamroots.embers.recipe.ItemStampingOreRecipe;
import teamroots.embers.recipe.ItemStampingRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityBin;
import teamroots.embers.tileentity.TileEntityStampBase;
import teamroots.embers.util.Misc;

public class TileEntityStamper
extends TileEntity
implements ITileEntityBase,
ITickable {
    public IEmberCapability capability = new DefaultEmberCapability();
    public boolean prevPowered = false;
    public boolean powered = false;
    public long ticksExisted = 0L;
    Random random = new Random();
    public ItemStackHandler stamp = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityStamper.this.func_70296_d();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    public boolean dirty = false;

    public TileEntityStamper() {
        this.capability.setEmberCapacity(8000.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("powered", this.powered);
        this.capability.writeToNBT(tag);
        tag.func_74782_a("stamp", (NBTBase)this.stamp.serializeNBT());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.powered = tag.func_74767_n("powered");
        this.capability.readFromNBT(tag);
        this.stamp.deserializeNBT(tag.func_74775_l("stamp"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem != ItemStack.field_190927_a) {
            if (EnumStampType.getType(heldItem) != EnumStampType.TYPE_NULL && this.stamp.getStackInSlot(0) == ItemStack.field_190927_a) {
                ItemStack newStack = new ItemStack(heldItem.func_77973_b(), 1, heldItem.func_77960_j());
                if (heldItem.func_77942_o()) {
                    newStack.func_77982_d(heldItem.func_77978_p());
                }
                player.func_184611_a(hand, this.stamp.insertItem(0, newStack, false));
                this.func_70296_d();
                return true;
            }
        } else if (this.stamp.getStackInSlot(0) != ItemStack.field_190927_a && !world.field_72995_K) {
            world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.stamp.getStackInSlot(0)));
            this.stamp.setStackInSlot(0, ItemStack.field_190927_a);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.stamp);
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        this.prevPowered = this.powered;
        EnumFacing face = (EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockStamper.facing);
        if (this.func_145831_w().func_180495_p(this.func_174877_v().func_177967_a(face, 2)).func_177230_c() == RegistryManager.stamp_base) {
            if (this.ticksExisted % 80L == 0L && !this.powered && !this.func_145831_w().field_72995_K) {
                ItemStampingOreRecipe oreRecipe;
                ItemStampingRecipe recipe;
                TileEntityStampBase stamp = (TileEntityStampBase)this.func_145831_w().func_175625_s(this.func_174877_v().func_177967_a(face, 2));
                FluidStack fluid = null;
                if (stamp.getFluid() != null) {
                    fluid = new FluidStack(stamp.getFluid(), stamp.getAmount());
                }
                if ((recipe = RecipeRegistry.getStampingRecipe(stamp.inputs.getStackInSlot(0), fluid, EnumStampType.getType(this.stamp.getStackInSlot(0)))) != null && this.capability.getEmber() > 80.0) {
                    IBlockState item;
                    this.capability.removeAmount(80.0, true);
                    if (!this.field_145850_b.field_72995_K) {
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageStamperFX((float)this.func_174877_v().func_177967_a(face, 2).func_177958_n() + 0.5f, (float)this.func_174877_v().func_177967_a(face, 2).func_177956_o() + 1.0f, (float)this.func_174877_v().func_177967_a(face, 2).func_177952_p() + 0.5f));
                    }
                    this.powered = true;
                    ItemStack result = recipe.getResult(stamp.inputs.getStackInSlot(0), stamp.getFluid() != null ? new FluidStack(stamp.getFluid(), stamp.getAmount()) : null, EnumStampType.getType(this.stamp.getStackInSlot(0))).func_77946_l();
                    if (recipe.getStack() != ItemStack.field_190927_a) {
                        stamp.inputs.extractItem(0, recipe.getStack().func_190916_E(), false);
                    }
                    if (recipe.getFluid() != null) {
                        stamp.getTank().drain(recipe.getFluid(), true);
                    }
                    BlockPos off = this.func_174877_v().func_177967_a(face, 1);
                    if (this.func_145831_w().func_175625_s(this.func_174877_v().func_177967_a(face, 3)) instanceof TileEntityBin) {
                        TileEntityBin bin = (TileEntityBin)this.func_145831_w().func_175625_s(this.func_174877_v().func_177967_a(face, 3));
                        ItemStack remainder = bin.inventory.insertItem(0, result, false);
                        if (remainder != ItemStack.field_190927_a && !this.func_145831_w().field_72995_K) {
                            EntityItem item2 = new EntityItem(this.func_145831_w(), (double)off.func_177958_n() + 0.5, (double)off.func_177956_o() + 0.5, (double)off.func_177952_p() + 0.5, remainder);
                            this.func_145831_w().func_72838_d((Entity)item2);
                        }
                        bin.func_70296_d();
                        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v().func_177967_a(face, 3));
                        this.func_70296_d();
                    } else if (!this.func_145831_w().field_72995_K) {
                        item = new EntityItem(this.func_145831_w(), (double)off.func_177958_n() + 0.5, (double)off.func_177956_o() + 0.5, (double)off.func_177952_p() + 0.5, result);
                        this.func_145831_w().func_72838_d((Entity)item);
                    }
                    stamp.func_70296_d();
                    item = this.func_145831_w().func_180495_p(this.func_174877_v().func_177967_a(face, 2));
                }
                if ((oreRecipe = RecipeRegistry.getStampingOreRecipe(stamp.inputs.getStackInSlot(0), fluid, EnumStampType.getType(this.stamp.getStackInSlot(0)))) != null && this.capability.getEmber() > 80.0) {
                    this.capability.removeAmount(80.0, true);
                    this.powered = true;
                    ItemStack result = oreRecipe.getResult(stamp.inputs.getStackInSlot(0), new FluidStack(stamp.getFluid(), stamp.getAmount()), EnumStampType.getType(this.stamp.getStackInSlot(0))).func_77946_l();
                    if (oreRecipe.getClass() != null) {
                        stamp.inputs.extractItem(0, 1, false);
                    }
                    if (recipe.getFluid() != null) {
                        stamp.getTank().drain(recipe.getFluid(), true);
                    }
                    BlockPos off = this.func_174877_v().func_177967_a(face, 1);
                    if (this.func_145831_w().func_175625_s(this.func_174877_v().func_177967_a(face, 3)) instanceof TileEntityBin) {
                        TileEntityBin bin = (TileEntityBin)this.func_145831_w().func_175625_s(this.func_174877_v().func_177967_a(face, 3));
                        ItemStack remainder = bin.inventory.insertItem(0, result, false);
                        if (remainder != ItemStack.field_190927_a && !this.func_145831_w().field_72995_K) {
                            EntityItem item = new EntityItem(this.func_145831_w(), (double)off.func_177958_n() + 0.5, (double)off.func_177956_o() + 0.5, (double)off.func_177952_p() + 0.5, remainder);
                            this.func_145831_w().func_72838_d((Entity)item);
                        }
                        bin.func_70296_d();
                        this.func_70296_d();
                    } else if (!this.func_145831_w().field_72995_K) {
                        EntityItem item = new EntityItem(this.func_145831_w(), (double)off.func_177958_n() + 0.5, (double)off.func_177956_o() + 0.5, (double)off.func_177952_p() + 0.5, result);
                        this.func_145831_w().func_72838_d((Entity)item);
                    }
                    stamp.func_70296_d();
                    IBlockState iBlockState = this.func_145831_w().func_180495_p(this.func_174877_v().func_177967_a(face, 2));
                }
                this.func_70296_d();
                IBlockState iBlockState = this.func_145831_w().func_180495_p(this.func_174877_v());
            } else if (this.ticksExisted % 80L == 10L && this.powered && !this.func_145831_w().field_72995_K) {
                this.powered = false;
                this.func_70296_d();
                IBlockState iBlockState = this.func_145831_w().func_180495_p(this.func_174877_v());
            }
        } else if (this.powered) {
            this.powered = false;
            this.func_70296_d();
            IBlockState iBlockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return (T)this.capability;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.stamp;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }
}

