/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.EventManager;
import teamroots.embers.block.BlockSteamEngine;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultMechCapability;
import teamroots.embers.power.IMechCapability;
import teamroots.embers.power.MechCapabilityProvider;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntitySteamEngine
extends TileEntity
implements ITileEntityBase,
ITickable {
    int ticksExisted = 0;
    BlockPos receivedFrom = null;
    int progress = 0;
    EnumFacing front = EnumFacing.UP;
    public FluidTank tank = new FluidTank(8000);
    public DefaultMechCapability capability = new DefaultMechCapability();
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntitySteamEngine.this.func_70296_d();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (TileEntityFurnace.func_145952_a((ItemStack)stack) == 0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }
    };
    public boolean dirty = false;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        tag.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        tag.func_74768_a("progress", this.progress);
        tag.func_74768_a("front", this.front.func_176745_a());
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.front = EnumFacing.func_82600_a((int)tag.func_74762_e("front"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == MechCapabilityProvider.mechCapability) {
            return facing == this.front;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == MechCapabilityProvider.mechCapability) {
            return (T)this.capability;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        this.capability.setPower(0.0, null);
        this.updateNearby();
        world.func_175690_a(pos, null);
    }

    public void updateNearby() {
        for (EnumFacing f : EnumFacing.values()) {
            TileEntity t = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f));
            if (t == null || f != this.front || !t.hasCapability(MechCapabilityProvider.mechCapability, Misc.getOppositeFace(f))) continue;
            ((IMechCapability)t.getCapability(MechCapabilityProvider.mechCapability, Misc.getOppositeFace(f))).setPower(this.capability.getPower(Misc.getOppositeFace(f)), Misc.getOppositeFace(f));
            t.func_70296_d();
        }
    }

    public void func_73660_a() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockSteamEngine) {
            this.front = (EnumFacing)state.func_177229_b((IProperty)BlockSteamEngine.facing);
        }
        if (this.progress == 0) {
            if (!this.inventory.getStackInSlot(0).func_190926_b() && this.tank.getFluid() != null && this.tank.getFluid().getFluid() == FluidRegistry.WATER && this.tank.getFluidAmount() > 10) {
                ItemStack stack = this.inventory.getStackInSlot(0).func_77946_l();
                stack.func_190920_e(1);
                int fuel = TileEntityFurnace.func_145952_a((ItemStack)stack);
                if (fuel > 0) {
                    this.progress = fuel;
                    this.inventory.getStackInSlot(0).func_190918_g(1);
                    if (this.inventory.getStackInSlot(0).func_190926_b()) {
                        this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                    }
                    this.func_70296_d();
                }
            } else if (this.capability.getPower(null) > 0.0) {
                this.capability.setPower(0.0, null);
                this.func_70296_d();
            }
        } else {
            --this.progress;
            if (this.field_145850_b.field_72995_K) {
                for (int i = 0; i < 4; ++i) {
                    if (this.front == EnumFacing.NORTH || this.front == EnumFacing.SOUTH) {
                        float offX = 0.8125f * (float)Misc.random.nextInt(2);
                        float offZ = 0.4375f * (float)Misc.random.nextInt(2);
                        ParticleUtil.spawnParticleSmoke(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.09375f + offX, (float)this.func_174877_v().func_177956_o() + 1.0f, (float)this.func_174877_v().func_177952_p() + 0.28125f + offZ, 0.025f * (Misc.random.nextFloat() - 0.5f), 0.125f * Misc.random.nextFloat(), 0.025f * (Misc.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 0.5f, 2.0f + Misc.random.nextFloat(), 24);
                    }
                    if (this.front != EnumFacing.EAST && this.front != EnumFacing.WEST) continue;
                    float offZ = 0.8125f * (float)Misc.random.nextInt(2);
                    float offX = 0.4375f * (float)Misc.random.nextInt(2);
                    ParticleUtil.spawnParticleSmoke(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.28125f + offX, (float)this.func_174877_v().func_177956_o() + 1.0f, (float)this.func_174877_v().func_177952_p() + 0.09375f + offZ, 0.025f * (Misc.random.nextFloat() - 0.5f), 0.125f * Misc.random.nextFloat(), 0.025f * (Misc.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 0.5f, 2.0f + Misc.random.nextFloat(), 24);
                }
            }
            this.tank.drain(4, true);
            if (this.tank.getFluidAmount() <= 0) {
                this.progress = 0;
                this.capability.setPower(0.0, null);
                this.func_70296_d();
            }
            if (this.capability.getPower(null) < 20.0) {
                this.capability.setPower(20.0, null);
                this.func_70296_d();
            }
        }
        this.updateNearby();
    }
}

