/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.feature;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.module.Feature;
import vazkii.quark.misc.block.BlockGlowstoneDust;
import vazkii.quark.misc.block.BlockGunpowder;

public class PlaceVanillaDusts
extends Feature {
    public static Block glowstone_dust_block;
    public static Block gunpowder_block;
    boolean enableGlowstone;
    boolean enableGunpowder;
    public static int gunpowderDelay;
    public static int gunpowderDelayNetherrack;

    @Override
    public void setupConfig() {
        this.enableGlowstone = this.loadPropBool("Enable Glowstone", "", true);
        this.enableGunpowder = this.loadPropBool("Enable Gunpowder", "", true);
        gunpowderDelay = this.loadPropInt("Gunpowder Delay", "Amount of ticks between each piece of gunpowder igniting the next", 10);
        gunpowderDelayNetherrack = this.loadPropInt("Gunpowder Delay on Netherrack", "Amount of ticks between each piece of gunpowder igniting the next, if on Netherrack", 5);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (this.enableGlowstone) {
            glowstone_dust_block = new BlockGlowstoneDust();
        }
        if (this.enableGunpowder) {
            gunpowder_block = new BlockGunpowder();
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EnumHand hand = event.getHand();
        EnumFacing face = event.getFace();
        ItemStack stack = event.getItemStack();
        if (this.enableGlowstone && stack.func_77973_b() == Items.field_151114_aO) {
            this.setBlock(player, world, pos, hand, face, glowstone_dust_block);
        } else if (this.enableGunpowder && stack.func_77973_b() == Items.field_151016_H) {
            this.setBlock(player, world, pos, hand, face, gunpowder_block);
        }
    }

    private boolean setBlock(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, Block block) {
        ItemStack itemstack;
        boolean flag = worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos);
        BlockPos blockpos = flag ? pos : pos.func_177972_a(facing);
        if (player.func_175151_a(blockpos, facing, itemstack = player.func_184586_b(hand)) && worldIn.func_190527_a(worldIn.func_180495_p(blockpos).func_177230_c(), blockpos, false, facing, null) && block.func_176196_c(worldIn, blockpos)) {
            worldIn.func_175656_a(blockpos, block.func_176223_P());
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, blockpos, itemstack);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            player.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

