/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.builder.BuilderContainer;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.builder.BuilderTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GuiBuilder
extends GenericGuiContainer<BuilderTileEntity> {
    public static final int BUILDER_WIDTH = 180;
    public static final int BUILDER_HEIGHT = 152;
    private EnergyBar energyBar;
    private ImageChoiceLabel redstoneMode;
    private ChoiceLabel modeChoice;
    private ImageChoiceLabel silentMode;
    private ImageChoiceLabel supportMode;
    private ImageChoiceLabel entityMode;
    private ImageChoiceLabel loopMode;
    private Button currentLevel;
    private ImageChoiceLabel[] anchor = new ImageChoiceLabel[4];
    private ChoiceLabel rotateButton;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/builder.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public GuiBuilder(BuilderTileEntity builderTileEntity, BuilderContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)builderTileEntity, (Container)container, RFTools.GUI_MANUAL_SHAPE, "builder");
        BuilderTileEntity.setCurrentRF((int)builderTileEntity.getEnergyStored());
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((BuilderTileEntity)this.tileEntity).getMaxEnergyStored();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 6, 9, 59))).setShowText(false);
        this.energyBar.setValue(BuilderTileEntity.getCurrentRF());
        this.initRedstoneMode();
        this.currentLevel = new Button(this.field_146297_k, (Gui)this);
        ((Button)((Button)((Button)this.currentLevel.setText("Y:")).setTooltips(new String[]{"Current level the builder is at", TextFormatting.YELLOW + "Press to restart!"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(75, 31, 45, 13))).addButtonEvent(parent -> this.restart());
        Panel positionPanel = this.setupPositionPanel();
        Panel modePanel = this.setupModePanel();
        Panel toplevel = (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.energyBar)).addChild((Widget)modePanel)).addChild((Widget)positionPanel)).addChild((Widget)this.currentLevel)).addChild((Widget)this.redstoneMode);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        ((BuilderTileEntity)this.tileEntity).requestRfFromServer("rftools");
        ((BuilderTileEntity)this.tileEntity).requestCurrentLevel();
    }

    private void initRedstoneMode() {
        this.redstoneMode = new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent((parent, newChoice) -> this.changeRedstoneMode()).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", guiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", guiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", guiElements, 32, 0);
        this.redstoneMode.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(100, 46, 16, 16));
        this.redstoneMode.setCurrentChoice(((BuilderTileEntity)this.tileEntity).getRSMode().ordinal());
    }

    private void changeRedstoneMode() {
        ((BuilderTileEntity)this.tileEntity).setRSMode(RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()]);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setMode", new Argument[]{new Argument("rs", RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()].getDescription())});
    }

    private void restart() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "restart", new Argument[]{new Argument("rs", RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()].getDescription())});
    }

    private Panel setupPositionPanel() {
        this.rotateButton = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{"0", "90", "180", "270"}).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, 4, 42, 14))).setTooltips(new String[]{"Set the horizontal rotation angle"})).addChoiceEvent((parent, newChoice) -> this.updateRotate());
        switch (((BuilderTileEntity)this.tileEntity).getRotate()) {
            case 0: {
                this.rotateButton.setChoice("0");
                break;
            }
            case 1: {
                this.rotateButton.setChoice("90");
                break;
            }
            case 2: {
                this.rotateButton.setChoice("180");
                break;
            }
            case 3: {
                this.rotateButton.setChoice("270");
            }
        }
        Panel positionPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(122, 6, 50, 59))).addChild((Widget)this.rotateButton)).setFilledRectThickness(-2)).setFilledBackground(StyleConfig.colorListBackground);
        String[] choiceDescriptions = new String[]{"Builder at south west corner", "Builder at south east corner", "Builder at north west corner", "Builder at north east corner"};
        for (int y = 0; y <= 1; ++y) {
            for (int x = 0; x <= 1; ++x) {
                int index = x + y * 2;
                this.anchor[index] = (ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setWithBorder(true).setHighlightedChoice(1).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4 + x * 24, 18 + (1 - y) * 19, 17, 17))).setTooltips(new String[]{"Set the anchor where you want to", "place the blocks in front of the", "builder"});
                this.anchor[index].addChoice("off", choiceDescriptions[index], guiElements, (7 + index * 2) * 16, 64);
                this.anchor[index].addChoice("on", choiceDescriptions[index], guiElements, (6 + index * 2) * 16, 64);
                this.anchor[index].addChoiceEvent((widget, s) -> this.selectAnchor(index));
                positionPanel.addChild((Widget)this.anchor[index]);
            }
        }
        if (!this.isShapeCard()) {
            this.anchor[((BuilderTileEntity)this.tileEntity).getAnchor()].setCurrentChoice(1);
        }
        return positionPanel;
    }

    private Panel setupModePanel() {
        this.modeChoice = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{BuilderTileEntity.MODES[0], BuilderTileEntity.MODES[1], BuilderTileEntity.MODES[2], BuilderTileEntity.MODES[3], BuilderTileEntity.MODES[4]}).setTooltips(new String[]{"Set the building mode"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, 4, 42, 14))).setChoiceTooltip(BuilderTileEntity.MODES[0], new String[]{"Copy from space chamber to here", "Chest on top or below with materials"}).setChoiceTooltip(BuilderTileEntity.MODES[1], new String[]{"Move from space chamber to here"}).setChoiceTooltip(BuilderTileEntity.MODES[2], new String[]{"Swap space chamber contents with here"}).setChoiceTooltip(BuilderTileEntity.MODES[3], new String[]{"Move back from here to space chamber"}).setChoiceTooltip(BuilderTileEntity.MODES[4], new String[]{"Collect items in space chamber", "Items will go to chest on top or below"}).addChoiceEvent((parent, newChoice) -> this.updateMode());
        this.modeChoice.setChoice(BuilderTileEntity.MODES[((BuilderTileEntity)this.tileEntity).getMode()]);
        this.silentMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, 18, 17, 17))).setWithBorder(true).setHighlightedChoice(1).setTooltips(new String[]{"Suppress the placement/breaking sound", "when moving blocks"})).addChoiceEvent((parent, newChoice) -> this.setSilentMode());
        this.silentMode.addChoice("off", "Moving blocks make sound", guiElements, 176, 48);
        this.silentMode.addChoice("on", "Block sounds are muted", guiElements, 160, 48);
        this.silentMode.setCurrentChoice(((BuilderTileEntity)this.tileEntity).isSilent() ? 1 : 0);
        this.supportMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(28, 18, 17, 17))).setWithBorder(true).setHighlightedChoice(1).setTooltips(new String[]{"Use supporting blocks when moving.", "Useful for liquids, gravel, ..."})).addChoiceEvent((parent, newChoice) -> this.setSupportMode());
        this.supportMode.addChoice("off", "Support/preview mode disabled", guiElements, 112, 48);
        this.supportMode.addChoice("on", "Support/preview mode enabled", guiElements, 96, 48);
        this.supportMode.setCurrentChoice(((BuilderTileEntity)this.tileEntity).hasSupportMode() ? 1 : 0);
        this.entityMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, 37, 17, 17))).setWithBorder(true).setHighlightedChoice(1).setTooltips(new String[]{"Move entities"})).addChoiceEvent((parent, newChoice) -> this.setEntityMode());
        this.entityMode.addChoice("off", "Entities are not moved", guiElements, 144, 48);
        this.entityMode.addChoice("on", "Entities are moved", guiElements, 128, 48);
        this.entityMode.setCurrentChoice(((BuilderTileEntity)this.tileEntity).hasEntityMode() ? 1 : 0);
        this.loopMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(28, 37, 17, 17))).setWithBorder(true).setHighlightedChoice(1).setTooltips(new String[]{"Loop mode"})).addChoiceEvent((parent, newChoice) -> this.setLoopMode());
        this.loopMode.addChoice("off", "Do a single run and stop", guiElements, 208, 48);
        this.loopMode.addChoice("on", "Keep running with redstone signal", guiElements, 192, 48);
        this.loopMode.setCurrentChoice(((BuilderTileEntity)this.tileEntity).hasLoopMode() ? 1 : 0);
        return (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(23, 6, 50, 59))).addChild((Widget)this.modeChoice)).addChild((Widget)this.silentMode)).addChild((Widget)this.supportMode)).addChild((Widget)this.entityMode)).addChild((Widget)this.loopMode)).setFilledRectThickness(-2)).setFilledBackground(StyleConfig.colorListBackground);
    }

    private void setLoopMode() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setLoop", new Argument[]{new Argument("loop", this.loopMode.getCurrentChoiceIndex() == 1)});
    }

    private void setSilentMode() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setSilent", new Argument[]{new Argument("silent", this.silentMode.getCurrentChoiceIndex() == 1)});
    }

    private void setSupportMode() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setSupport", new Argument[]{new Argument("support", this.supportMode.getCurrentChoiceIndex() == 1)});
    }

    private void setEntityMode() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setEntities", new Argument[]{new Argument("entities", this.entityMode.getCurrentChoiceIndex() == 1)});
    }

    private void selectAnchor(int index) {
        this.updateAnchorSettings(index);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setAnchor", new Argument[]{new Argument("anchor", index)});
    }

    private void updateAnchorSettings(int index) {
        for (int i = 0; i < this.anchor.length; ++i) {
            if (this.isShapeCard()) {
                this.anchor[i].setCurrentChoice(0);
                continue;
            }
            if (this.anchor[i].getCurrentChoiceIndex() == 1 == (i == index)) continue;
            this.anchor[i].setCurrentChoice(i == index ? 1 : 0);
        }
    }

    private void updateMode() {
        String currentChoice = this.modeChoice.getCurrentChoice();
        int mode = 0;
        for (int i = 0; i < BuilderTileEntity.MODES.length; ++i) {
            if (!currentChoice.equals(BuilderTileEntity.MODES[i])) continue;
            mode = i;
            break;
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setMode", new Argument[]{new Argument("mode", mode)});
    }

    private void updateRotate() {
        String choice = this.rotateButton.getCurrentChoice();
        int index = 0;
        if ("0".equals(choice)) {
            index = 0;
        } else if ("90".equals(choice)) {
            index = 1;
        } else if ("180".equals(choice)) {
            index = 2;
        } else if ("270".equals(choice)) {
            index = 3;
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setRotate", new Argument[]{new Argument("rotate", index)});
    }

    private boolean isShapeCard() {
        ItemStack card = ((BuilderTileEntity)this.tileEntity).func_70301_a(0);
        return !card.func_190926_b() && card.func_77973_b() == BuilderSetup.shapeCardItem;
    }

    protected void func_146976_a(float v, int i, int i2) {
        int cury = BuilderTileEntity.getCurrentLevelClientSide();
        this.currentLevel.setText("Y: " + (cury == -1 ? "stop" : Integer.valueOf(cury)));
        ItemStack card = ((BuilderTileEntity)this.tileEntity).func_70301_a(0);
        boolean enabled = card.func_190926_b() ? false : card.func_77973_b() != BuilderSetup.shapeCardItem;
        this.modeChoice.setEnabled(enabled);
        this.rotateButton.setEnabled(enabled);
        this.updateAnchorSettings(((BuilderTileEntity)this.tileEntity).getAnchor());
        this.drawWindow();
        this.energyBar.setValue(BuilderTileEntity.getCurrentRF());
        ((BuilderTileEntity)this.tileEntity).requestRfFromServer("rftools");
        ((BuilderTileEntity)this.tileEntity).requestCurrentLevel();
    }
}

