/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.builder.BuilderConfiguration;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.builder.SpaceChamberRepository;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class SpaceChamberControllerTileEntity
extends GenericTileEntity {
    private BlockPos minCorner;
    private BlockPos maxCorner;
    private int channel = -1;

    public BlockPos getMinCorner() {
        return this.minCorner;
    }

    public BlockPos getMaxCorner() {
        return this.maxCorner;
    }

    public void createChamber(EntityPlayer player) {
        int i;
        int x1 = this.func_174877_v().func_177958_n();
        int y1 = this.func_174877_v().func_177956_o();
        int z1 = this.func_174877_v().func_177952_p();
        int x2 = x1;
        int y2 = y1;
        int z2 = z1;
        for (i = 1; i < BuilderConfiguration.maxSpaceChamberDimension; ++i) {
            if (x2 == x1) {
                if (this.func_145831_w().func_180495_p(new BlockPos(x1 - i, y1, z1)).func_177230_c() == BuilderSetup.spaceChamberBlock) {
                    x2 = x1 - i;
                } else if (this.func_145831_w().func_180495_p(new BlockPos(x1 + i, y1, z1)).func_177230_c() == BuilderSetup.spaceChamberBlock) {
                    x2 = x1 + i;
                }
            }
            if (z2 != z1) continue;
            if (this.func_145831_w().func_180495_p(new BlockPos(x1, y1, z1 - i)).func_177230_c() == BuilderSetup.spaceChamberBlock) {
                z2 = z1 - i;
                continue;
            }
            if (this.func_145831_w().func_180495_p(new BlockPos(x1, y1, z1 + i)).func_177230_c() != BuilderSetup.spaceChamberBlock) continue;
            z2 = z1 + i;
        }
        if (x1 == x2 || z2 == z1) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.func_145831_w().func_180495_p(new BlockPos(x2, y1, z2)).func_177230_c() != BuilderSetup.spaceChamberBlock) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        for (i = 1; i < BuilderConfiguration.maxSpaceChamberDimension; ++i) {
            if (this.func_145831_w().func_180495_p(new BlockPos(x1, y1 - i, z1)).func_177230_c() == BuilderSetup.spaceChamberBlock) {
                y2 = y1 - i;
                break;
            }
            if (this.func_145831_w().func_180495_p(new BlockPos(x1, y1 + i, z1)).func_177230_c() != BuilderSetup.spaceChamberBlock) continue;
            y2 = y1 + i;
            break;
        }
        if (y1 == y2) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.func_145831_w().func_180495_p(new BlockPos(x2, y2, z2)).func_177230_c() != BuilderSetup.spaceChamberBlock) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.func_145831_w().func_180495_p(new BlockPos(x1, y2, z2)).func_177230_c() != BuilderSetup.spaceChamberBlock) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.func_145831_w().func_180495_p(new BlockPos(x2, y2, z1)).func_177230_c() != BuilderSetup.spaceChamberBlock) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        this.minCorner = new BlockPos(Math.min(x1, x2) + 1, Math.min(y1, y2) + 1, Math.min(z1, z2) + 1);
        this.maxCorner = new BlockPos(Math.max(x1, x2) - 1, Math.max(y1, y2) - 1, Math.max(z1, z2) - 1);
        if (this.minCorner.func_177958_n() > this.maxCorner.func_177958_n() || this.minCorner.func_177956_o() > this.maxCorner.func_177956_o() || this.minCorner.func_177952_p() > this.maxCorner.func_177952_p()) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Chamber is too small!"));
            this.minCorner = null;
            this.maxCorner = null;
            return;
        }
        Logging.message((EntityPlayer)player, (String)(TextFormatting.WHITE + "Chamber succesfully created!"));
        SpaceChamberRepository chamberRepository = SpaceChamberRepository.getChannels(this.func_145831_w());
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = chamberRepository.getOrCreateChannel(this.channel);
        chamberChannel.setDimension(this.func_145831_w().field_73011_w.getDimension());
        chamberChannel.setMinCorner(this.minCorner);
        chamberChannel.setMaxCorner(this.maxCorner);
        chamberRepository.save(this.func_145831_w());
        this.markDirtyClient();
    }

    public int getChannel() {
        return this.channel;
    }

    public int getChamberSize() {
        if (this.channel == -1) {
            return -1;
        }
        if (this.minCorner == null) {
            return -1;
        }
        return BlockPosTools.area((BlockPos)this.minCorner, (BlockPos)this.maxCorner);
    }

    public void setChannel(int channel) {
        this.channel = channel;
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.minCorner = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"minCorner");
        this.maxCorner = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"maxCorner");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.channel = tagCompound.func_74762_e("channel");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"minCorner", (BlockPos)this.minCorner);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"maxCorner", (BlockPos)this.maxCorner);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("channel", this.channel);
    }
}

