/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.crafter;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class CraftingRecipe {
    private InventoryCrafting inv = new InventoryCrafting(new Container(){

        public boolean func_75145_c(EntityPlayer var1) {
            return false;
        }
    }, 3, 3);
    private ItemStack result = ItemStack.field_190927_a;
    private boolean recipePresent = false;
    private IRecipe recipe = null;
    private boolean keepOne = false;
    private CraftMode craftMode = CraftMode.EXT;

    public static IRecipe findRecipe(World world, InventoryCrafting inv) {
        for (IRecipe r : CraftingManager.field_193380_a) {
            if (r == null || !r.func_77569_a(inv, world)) continue;
            return r;
        }
        return null;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        NBTTagList nbtTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = nbtTagList.func_150305_b(i);
            this.inv.func_70299_a(i, new ItemStack(nbtTagCompound));
        }
        NBTTagCompound resultCompound = tagCompound.func_74775_l("Result");
        this.result = resultCompound != null ? new ItemStack(resultCompound) : ItemStack.field_190927_a;
        this.keepOne = tagCompound.func_74767_n("Keep");
        this.craftMode = CraftMode.values()[tagCompound.func_74771_c("Int")];
        this.recipePresent = false;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inv.func_70301_a(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (!stack.func_190926_b()) {
                stack.func_77955_b(nbtTagCompound);
            }
            nbtTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        NBTTagCompound resultCompound = new NBTTagCompound();
        if (!this.result.func_190926_b()) {
            this.result.func_77955_b(resultCompound);
        }
        tagCompound.func_74782_a("Result", (NBTBase)resultCompound);
        tagCompound.func_74782_a("Items", (NBTBase)nbtTagList);
        tagCompound.func_74757_a("Keep", this.keepOne);
        tagCompound.func_74774_a("Int", (byte)this.craftMode.ordinal());
    }

    public void setRecipe(ItemStack[] items, ItemStack result) {
        for (int i = 0; i < 9; ++i) {
            this.inv.func_70299_a(i, items[i]);
        }
        this.result = result;
        this.recipePresent = false;
    }

    public InventoryCrafting getInventory() {
        return this.inv;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public IRecipe getCachedRecipe(World world) {
        if (!this.recipePresent) {
            this.recipePresent = true;
            this.recipe = CraftingRecipe.findRecipe(world, this.inv);
        }
        return this.recipe;
    }

    public boolean isKeepOne() {
        return this.keepOne;
    }

    public void setKeepOne(boolean keepOne) {
        this.keepOne = keepOne;
    }

    public CraftMode getCraftMode() {
        return this.craftMode;
    }

    public void setCraftMode(CraftMode craftMode) {
        this.craftMode = craftMode;
    }

    static enum CraftMode {
        EXT("Ext"),
        INT("Int"),
        EXTC("ExtC");

        private final String description;

        private CraftMode(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

