/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient;

import java.util.HashMap;
import mcjty.lib.api.MachineInformation;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ColorChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.IModuleGuiBuilder;
import mcjty.rftools.api.screens.IModuleRenderHelper;
import mcjty.rftools.api.screens.ITextRenderHelper;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.api.screens.data.IModuleDataString;
import mcjty.rftools.blocks.screens.IModuleGuiChanged;
import mcjty.rftools.blocks.screens.modulesclient.helper.ScreenModuleGuiBuilder;
import mcjty.rftools.blocks.screens.modulesclient.helper.ScreenTextHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MachineInformationClientScreenModule
implements IClientScreenModule<IModuleDataString> {
    private String line = "";
    private int labcolor = 0xFFFFFF;
    private int txtcolor = 0xFFFFFF;
    protected int dim = 0;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    private ITextRenderHelper labelCache = new ScreenTextHelper();

    @Override
    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.TEXT;
    }

    @Override
    public int getHeight() {
        return 10;
    }

    @Override
    public void render(IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleDataString screenData, ModuleRenderInfo renderInfo) {
        int xoffset;
        GlStateManager.func_179140_f();
        if (!this.line.isEmpty()) {
            this.labelCache.setup(this.line, 160, renderInfo);
            this.labelCache.renderText(0, currenty, this.labcolor, renderInfo);
            xoffset = 47;
        } else {
            xoffset = 7;
        }
        if (!BlockPosTools.INVALID.equals((Object)this.coordinate) && screenData != null) {
            renderHelper.renderText(xoffset, currenty, this.txtcolor, renderInfo, screenData.get());
        } else {
            renderHelper.renderText(xoffset, currenty, 0xFF0000, renderInfo, "<invalid>");
        }
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    @Override
    public void createGui(IModuleGuiBuilder guiBuilder) {
        ScreenModuleGuiBuilder screenModuleGuiBuilder = (ScreenModuleGuiBuilder)guiBuilder;
        Minecraft mc = Minecraft.func_71410_x();
        Gui gui = screenModuleGuiBuilder.getGui();
        NBTTagCompound currentData = screenModuleGuiBuilder.getCurrentData();
        IModuleGuiChanged moduleGuiChanged = screenModuleGuiBuilder.getModuleGuiChanged();
        Panel panel = new Panel(mc, gui).setLayout((Layout)new VerticalLayout());
        TextField textField = ((TextField)((TextField)new TextField(mc, gui).setDesiredHeight(16)).setTooltips(new String[]{"Text to use as label"})).addTextEvent((parent, newText) -> {
            currentData.func_74778_a("text", newText);
            moduleGuiChanged.updateData();
        });
        panel.addChild((Widget)textField);
        this.addColorPanel(mc, gui, currentData, moduleGuiChanged, panel);
        this.addOptionPanel(mc, gui, currentData, moduleGuiChanged, panel);
        this.addMonitorPanel(mc, gui, currentData, panel);
        if (currentData != null) {
            textField.setText(currentData.func_74779_i("text"));
        }
        screenModuleGuiBuilder.overridePanel(panel);
    }

    private void addOptionPanel(Minecraft mc, Gui gui, NBTTagCompound currentData, IModuleGuiChanged moduleGuiChanged, Panel panel) {
        Panel optionPanel = (Panel)new Panel(mc, gui).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(16);
        HashMap<String, Integer> choiceToIndex = new HashMap<String, Integer>();
        ChoiceLabel tagButton = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel(mc, gui).setDesiredHeight(16)).setDesiredWidth(80);
        optionPanel.addChild((Widget)tagButton);
        int x = currentData.func_74762_e("monitorx");
        int y = currentData.func_74762_e("monitory");
        int z = currentData.func_74762_e("monitorz");
        TileEntity tileEntity = mc.field_71441_e.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity instanceof MachineInformation) {
            int current = currentData.func_74762_e("monitorTag");
            MachineInformation information = (MachineInformation)tileEntity;
            String currentTag = null;
            for (int i = 0; i < information.getTagCount(); ++i) {
                String tag = information.getTagName(i);
                choiceToIndex.put(tag, i);
                tagButton.addChoices(new String[]{tag});
                tagButton.setChoiceTooltip(tag, new String[]{information.getTagDescription(i)});
                if (current != i) continue;
                currentTag = tag;
            }
            if (currentTag != null) {
                tagButton.setChoice(currentTag);
            }
        }
        tagButton.addChoiceEvent((parent, newChoice) -> {
            String choice = tagButton.getCurrentChoice();
            Integer index = (Integer)choiceToIndex.get(choice);
            if (index != null) {
                currentData.func_74768_a("monitorTag", index.intValue());
            }
            moduleGuiChanged.updateData();
        });
        panel.addChild((Widget)optionPanel);
    }

    private void addMonitorPanel(Minecraft mc, Gui gui, NBTTagCompound currentData, Panel panel) {
        String monitoring;
        Panel monitorPanel = (Panel)new Panel(mc, gui).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(16);
        if (currentData.func_74764_b("monitorx")) {
            this.dim = currentData.func_74764_b("monitordim") ? currentData.func_74762_e("monitordim") : currentData.func_74762_e("dim");
            World world = mc.field_71439_g.func_130014_f_();
            if (this.dim == world.field_73011_w.getDimension()) {
                int x = currentData.func_74762_e("monitorx");
                int y = currentData.func_74762_e("monitory");
                int z = currentData.func_74762_e("monitorz");
                monitoring = currentData.func_74779_i("monitorname");
                Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                ((Panel)monitorPanel.addChild((Widget)new BlockRender(mc, gui).setRenderItem((Object)block))).setDesiredWidth(20);
                monitorPanel.addChild((Widget)new Label(mc, gui).setText(x + "," + y + "," + z).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setDesiredWidth(150));
            } else {
                monitoring = "<unreachable>";
            }
        } else {
            monitoring = "<not set>";
        }
        panel.addChild((Widget)monitorPanel);
        panel.addChild((Widget)new Label(mc, gui).setText(monitoring));
    }

    private void addColorPanel(Minecraft mc, Gui gui, NBTTagCompound currentData, IModuleGuiChanged moduleGuiChanged, Panel panel) {
        ColorChoiceLabel labelColorSelector = (ColorChoiceLabel)this.addColorSelector(mc, gui, currentData, moduleGuiChanged, "color").setTooltips(new String[]{"Color for the label"});
        ColorChoiceLabel txtColorSelector = (ColorChoiceLabel)this.addColorSelector(mc, gui, currentData, moduleGuiChanged, "txtcolor").setTooltips(new String[]{"Color for the text"});
        Panel colorPanel = (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(mc, gui).setLayout((Layout)new HorizontalLayout()).addChild((Widget)new Label(mc, gui).setText("L:"))).addChild((Widget)labelColorSelector)).addChild((Widget)new Label(mc, gui).setText("Txt:"))).addChild((Widget)txtColorSelector)).setDesiredHeight(12);
        panel.addChild((Widget)colorPanel);
    }

    private ColorChoiceLabel addColorSelector(Minecraft mc, Gui gui, NBTTagCompound currentData, IModuleGuiChanged moduleGuiChanged, String tagName) {
        int currentColor;
        ColorChoiceLabel colorChoiceLabel = ((ColorChoiceLabel)((ColorChoiceLabel)new ColorChoiceLabel(mc, gui).addColors(new Integer[]{0xFFFFFF, 0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535}).setDesiredWidth(26)).setDesiredHeight(14)).addChoiceEvent((parent, newColor) -> {
            currentData.func_74768_a(tagName, newColor.intValue());
            moduleGuiChanged.updateData();
        });
        if (currentData != null && (currentColor = currentData.func_74762_e(tagName)) != 0) {
            colorChoiceLabel.setCurrentColor(Integer.valueOf(currentColor));
        }
        return colorChoiceLabel;
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            this.labcolor = tagCompound.func_74764_b("color") ? tagCompound.func_74762_e("color") : 0xFFFFFF;
            this.txtcolor = tagCompound.func_74764_b("txtcolor") ? tagCompound.func_74762_e("txtcolor") : 0xFFFFFF;
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
        }
    }

    protected void setupCoordinateFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        if (tagCompound.func_74764_b("monitorx")) {
            this.dim = tagCompound.func_74764_b("monitordim") ? tagCompound.func_74762_e("monitordim") : tagCompound.func_74762_e("dim");
            if (dim == this.dim) {
                BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    @Override
    public boolean needsServerData() {
        return true;
    }
}

