/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.security;

import java.util.Map;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.rftools.blocks.security.SecurityChannels;
import mcjty.rftools.blocks.security.SecurityManagerContainer;
import mcjty.rftools.blocks.security.SecuritySetup;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class SecurityManagerTileEntity
extends GenericTileEntity
implements DefaultSidedInventory {
    public static final String CMD_SETCHANNELNAME = "setChannelName";
    public static final String CMD_SETMODE = "setMode";
    public static final String CMD_ADDPLAYER = "addPlayer";
    public static final String CMD_DELPLAYER = "delPlayer";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, SecurityManagerContainer.factory, 14);

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    private NBTTagCompound getOrCreateNBT(ItemStack cardStack) {
        NBTTagCompound tagCompound = cardStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            cardStack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    private void updateCard(ItemStack cardStack) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (cardStack.func_190926_b()) {
            return;
        }
        NBTTagCompound tagCompound = this.getOrCreateNBT(cardStack);
        if (!tagCompound.func_74764_b("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.func_145831_w());
            int id = securityChannels.newChannel();
            tagCompound.func_74768_a("channel", id);
            securityChannels.save(this.func_145831_w());
            this.markDirtyClient();
        }
    }

    private void updateLinkedCard() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ItemStack masterCard = this.inventoryHelper.getStackInSlot(0);
        if (masterCard.func_190926_b()) {
            return;
        }
        ItemStack linkerCard = this.inventoryHelper.getStackInSlot(1);
        if (linkerCard.func_190926_b()) {
            return;
        }
        NBTTagCompound masterNBT = masterCard.func_77978_p();
        if (masterNBT == null) {
            return;
        }
        NBTTagCompound linkerNBT = this.getOrCreateNBT(linkerCard);
        linkerNBT.func_74768_a("channel", masterNBT.func_74762_e("channel"));
        this.markDirtyClient();
    }

    private void addPlayer(String player) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.func_74764_b("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.func_145831_w());
            int id = tagCompound.func_74762_e("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.addPlayer(player);
            securityChannels.save(this.func_145831_w());
            this.markDirtyClient();
        }
    }

    private void delPlayer(String player) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.func_74764_b("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.func_145831_w());
            int id = tagCompound.func_74762_e("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.delPlayer(player);
            securityChannels.save(this.func_145831_w());
            this.markDirtyClient();
        }
    }

    private void setWhiteListMode(boolean whitelist) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.func_74764_b("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.func_145831_w());
            int id = tagCompound.func_74762_e("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.setWhitelist(whitelist);
            securityChannels.save(this.func_145831_w());
            this.markDirtyClient();
        }
    }

    private void setChannelName(String name) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.func_74764_b("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.func_145831_w());
            int id = tagCompound.func_74762_e("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.setName(name);
            securityChannels.save(this.func_145831_w());
            this.markDirtyClient();
        }
    }

    private NBTTagCompound getCardInfo() {
        ItemStack cardStack = this.inventoryHelper.getStackInSlot(0);
        if (cardStack.func_190926_b()) {
            return null;
        }
        return this.getOrCreateNBT(cardStack);
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (index == 0) {
            this.updateCard(stack);
            this.updateLinkedCard();
        } else if (index == 1) {
            this.updateLinkedCard();
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return ((Object)((Object)SecuritySetup.securityCardItem)).equals(stack.func_77973_b());
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETCHANNELNAME.equals(command)) {
            this.setChannelName(args.get("name").getString());
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            this.setWhiteListMode(args.get("whitelist").getBoolean());
            return true;
        }
        if (CMD_ADDPLAYER.equals(command)) {
            this.addPlayer(args.get("player").getString());
            return true;
        }
        if (CMD_DELPLAYER.equals(command)) {
            this.delPlayer(args.get("player").getString());
            return true;
        }
        return false;
    }
}

