/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import com.mojang.authlib.GameProfile;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.information.IMachineInformation;
import mcjty.lib.api.smartwrench.SmartWrenchSelector;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.environmental.EnvironmentalSetup;
import mcjty.rftools.blocks.shield.AbstractShieldBlock;
import mcjty.rftools.blocks.shield.DamageTypeMode;
import mcjty.rftools.blocks.shield.GuiShield;
import mcjty.rftools.blocks.shield.NoTickShieldBlockTileEntity;
import mcjty.rftools.blocks.shield.RelCoordinate;
import mcjty.rftools.blocks.shield.RelCoordinateShield;
import mcjty.rftools.blocks.shield.ShieldConfiguration;
import mcjty.rftools.blocks.shield.ShieldContainer;
import mcjty.rftools.blocks.shield.ShieldRenderingMode;
import mcjty.rftools.blocks.shield.ShieldSetup;
import mcjty.rftools.blocks.shield.filters.AbstractShieldFilter;
import mcjty.rftools.blocks.shield.filters.PlayerFilter;
import mcjty.rftools.blocks.shield.filters.ShieldFilter;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.shapes.Shape;
import mcjty.typed.Type;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ShieldTEBase
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
SmartWrenchSelector,
ITickable,
IMachineInformation {
    public static final String CMD_SHIELDVISMODE = "shieldVisMode";
    public static final String CMD_APPLYCAMO = "applyCamo";
    public static final String CMD_DAMAGEMODE = "damageMode";
    public static final String CMD_RSMODE = "rsMode";
    public static final String CMD_ADDFILTER = "addFilter";
    public static final String CMD_DELFILTER = "delFilter";
    public static final String CMD_UPFILTER = "upFilter";
    public static final String CMD_DOWNFILTER = "downFilter";
    public static final String CMD_GETFILTERS = "getFilters";
    public static final String CMD_SETCOLOR = "setColor";
    public static final String CLIENTCMD_GETFILTERS = "getFilters";
    public static final String COMPONENT_NAME = "shield_projector";
    private DamageTypeMode damageMode = DamageTypeMode.DAMAGETYPE_GENERIC;
    private boolean shieldComposed = false;
    private int templateMeta = 0;
    private boolean shieldActive = false;
    private int powerTimeout = 0;
    private int shieldColor;
    private int camoRenderPass = 0;
    private int supportedBlocks;
    private float damageFactor = 1.0f;
    private float costFactor = 1.0f;
    private final List<ShieldFilter> filters = new ArrayList<ShieldFilter>();
    private ShieldRenderingMode shieldRenderingMode = ShieldRenderingMode.MODE_SHIELD;
    private List<RelCoordinateShield> shieldBlocks = new ArrayList<RelCoordinateShield>();
    private List<IBlockState> blockStateTable = new ArrayList<IBlockState>();
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, ShieldContainer.factory, 3);
    private static FakePlayer killer = null;
    private ItemStack lootingSword = ItemStack.field_190927_a;

    public ShieldTEBase(int maxEnergy, int maxReceive) {
        super(maxEnergy, maxReceive);
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public void setSupportedBlocks(int supportedBlocks) {
        this.supportedBlocks = supportedBlocks;
    }

    public void setDamageFactor(float factor) {
        this.damageFactor = factor;
    }

    public void setCostFactor(float factor) {
        this.costFactor = factor;
    }

    private Object[] setDamageMode(String mode) {
        DamageTypeMode damageMode = DamageTypeMode.getMode(mode);
        if (damageMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setDamageMode(damageMode);
        return null;
    }

    private Object[] setRedstoneMode(String mode) {
        RedstoneMode redstoneMode = RedstoneMode.getMode((String)mode);
        if (redstoneMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setRSMode(redstoneMode);
        return null;
    }

    private Object[] setShieldRenderingMode(String mode) {
        ShieldRenderingMode renderingMode = ShieldRenderingMode.getMode(mode);
        if (renderingMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setShieldRenderingMode(renderingMode);
        return null;
    }

    private Object[] composeShieldComp(boolean ctrl) {
        boolean done = false;
        if (!this.isShieldComposed()) {
            this.composeShield(ctrl);
            done = true;
        }
        return new Object[]{done};
    }

    private Object[] decomposeShieldComp() {
        boolean done = false;
        if (this.isShieldComposed()) {
            this.decomposeShield();
            done = true;
        }
        return new Object[]{done};
    }

    public boolean isPowered() {
        return this.powerLevel > 0;
    }

    public List<ShieldFilter> getFilters() {
        return this.filters;
    }

    public int getShieldColor() {
        return this.shieldColor;
    }

    public void setShieldColor(int shieldColor) {
        this.shieldColor = shieldColor;
        this.updateShield();
        this.markDirtyClient();
    }

    private void delFilter(int selected) {
        this.filters.remove(selected);
        this.updateShield();
        this.markDirtyClient();
    }

    private void upFilter(int selected) {
        ShieldFilter filter1 = this.filters.get(selected - 1);
        ShieldFilter filter2 = this.filters.get(selected);
        this.filters.set(selected - 1, filter2);
        this.filters.set(selected, filter1);
        this.markDirtyClient();
    }

    private void downFilter(int selected) {
        ShieldFilter filter1 = this.filters.get(selected);
        ShieldFilter filter2 = this.filters.get(selected + 1);
        this.filters.set(selected, filter2);
        this.filters.set(selected + 1, filter1);
        this.markDirtyClient();
    }

    private void addFilter(int action, String type, String player, int selected) {
        ShieldFilter filter = AbstractShieldFilter.createFilter(type);
        filter.setAction(action);
        if (filter instanceof PlayerFilter) {
            ((PlayerFilter)filter).setName(player);
        }
        if (selected == -1) {
            this.filters.add(filter);
        } else {
            this.filters.add(selected, filter);
        }
        this.updateShield();
        this.markDirtyClient();
    }

    public DamageTypeMode getDamageMode() {
        return this.damageMode;
    }

    public void setDamageMode(DamageTypeMode damageMode) {
        this.damageMode = damageMode;
        this.markDirtyClient();
    }

    public ShieldRenderingMode getShieldRenderingMode() {
        return this.shieldRenderingMode;
    }

    public void setShieldRenderingMode(ShieldRenderingMode shieldRenderingMode) {
        this.shieldRenderingMode = shieldRenderingMode;
        if (this.shieldComposed) {
            this.updateShield();
        }
        this.markDirtyClient();
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{2};
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 1 || stack.func_77973_b() == BuilderSetup.shapeCardItem;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 2 && itemStackIn.func_77973_b() == ModItems.dimensionalShardItem;
    }

    private int[] calculateCamoId() {
        ItemStack stack = this.func_70301_a(0);
        int camoId = -1;
        int meta = 0;
        int te = 0;
        if (ShieldRenderingMode.MODE_MIMIC.equals((Object)this.shieldRenderingMode) && !stack.func_190926_b() && stack.func_77973_b() != null) {
            if (!(stack.func_77973_b() instanceof ItemBlock)) {
                return new int[]{camoId, meta, te};
            }
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            camoId = Block.func_149682_b((Block)block);
            meta = stack.func_77960_j();
            if (block.hasTileEntity(block.func_176203_a(meta))) {
                te = 1;
            }
        }
        return new int[]{camoId, meta, te};
    }

    private Block calculateShieldBlock(int damageBits, int[] camoId) {
        if (!this.shieldActive || this.powerTimeout > 0) {
            return Blocks.field_150350_a;
        }
        if (ShieldConfiguration.allowInvisibleShield && ShieldRenderingMode.MODE_INVISIBLE.equals((Object)this.shieldRenderingMode)) {
            if (damageBits == 0) {
                return ShieldSetup.noTickInvisibleShieldBlock;
            }
            return ShieldSetup.invisibleShieldBlock;
        }
        if (camoId[0] == -1) {
            if (damageBits == 0) {
                return ShieldSetup.noTickSolidShieldBlock;
            }
            return ShieldSetup.solidShieldBlock;
        }
        if (damageBits == 0) {
            return ShieldSetup.noTickCamoShieldBlock;
        }
        return ShieldSetup.camoShieldBlock;
    }

    private int calculateDamageBits() {
        int bits = 0;
        for (ShieldFilter filter : this.filters) {
            if ((filter.getAction() & 2) == 0) continue;
            if ("item".equals(filter.getFilterName())) {
                bits |= 1;
                continue;
            }
            if ("animal".equals(filter.getFilterName())) {
                bits |= 2;
                continue;
            }
            if ("hostile".equals(filter.getFilterName())) {
                bits |= 4;
                continue;
            }
            if ("player".equals(filter.getFilterName())) {
                bits |= 8;
                continue;
            }
            if (!"default".equals(filter.getFilterName())) continue;
            bits |= 0xF;
        }
        return bits;
    }

    private int calculateShieldCollisionData() {
        int cd = 0;
        for (ShieldFilter filter : this.filters) {
            if ((filter.getAction() & 1) == 0) continue;
            if ("item".equals(filter.getFilterName())) {
                cd |= 1;
                continue;
            }
            if ("animal".equals(filter.getFilterName())) {
                cd |= 2;
                continue;
            }
            if ("hostile".equals(filter.getFilterName())) {
                cd |= 4;
                continue;
            }
            if ("player".equals(filter.getFilterName())) {
                cd |= 8;
                continue;
            }
            if (!"default".equals(filter.getFilterName())) continue;
            cd |= 0xF;
        }
        return cd;
    }

    private int calculateRfPerTick() {
        if (!this.shieldActive) {
            return 0;
        }
        int s = this.shieldBlocks.size() - 50;
        if (s < 10) {
            s = 10;
        }
        int rf = ShieldConfiguration.rfBase * s / 10;
        if (ShieldRenderingMode.MODE_SHIELD.equals((Object)this.shieldRenderingMode)) {
            rf += ShieldConfiguration.rfShield * s / 10;
        } else if (ShieldRenderingMode.MODE_MIMIC.equals((Object)this.shieldRenderingMode)) {
            rf += ShieldConfiguration.rfCamo * s / 10;
        }
        return rf;
    }

    public boolean isShieldComposed() {
        return this.shieldComposed;
    }

    public boolean isShieldActive() {
        return this.shieldActive;
    }

    public void applyDamageToEntity(Entity entity) {
        DamageSource source;
        int rf;
        if (DamageTypeMode.DAMAGETYPE_GENERIC.equals((Object)this.damageMode)) {
            rf = ShieldConfiguration.rfDamage;
            source = DamageSource.field_76377_j;
        } else {
            rf = ShieldConfiguration.rfDamagePlayer;
            if (killer == null) {
                killer = FakePlayerFactory.get((WorldServer)DimensionManager.getWorld((int)0), (GameProfile)new GameProfile(new UUID(111L, 222L), "rftools_shield"));
            }
            FakePlayer fakePlayer = killer;
            ItemStack shards = this.func_70301_a(2);
            if (!shards.func_190926_b() && shards.func_190916_E() >= ShieldConfiguration.shardsPerLootingKill) {
                this.func_70298_a(2, ShieldConfiguration.shardsPerLootingKill);
                if (this.lootingSword.func_190926_b()) {
                    this.lootingSword = EnvironmentalSetup.createEnchantedItem(Items.field_151048_u, Enchantments.field_185304_p, ShieldConfiguration.lootingKillBonus);
                }
                this.lootingSword.func_77964_b(0);
                fakePlayer.func_184611_a(EnumHand.MAIN_HAND, this.lootingSword);
            } else {
                fakePlayer.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            }
            source = DamageSource.func_76365_a((EntityPlayer)fakePlayer);
        }
        rf = (int)((float)rf * this.costFactor * (4.0f - this.getInfusedFactor()) / 4.0f);
        if (this.getEnergyStored() < rf) {
            return;
        }
        this.consumeEnergy(rf);
        float damage = ShieldConfiguration.damage;
        damage *= this.damageFactor;
        entity.func_70097_a(source, damage *= 1.0f + this.getInfusedFactor() / 2.0f);
    }

    public int getEnergyDiffPerTick() {
        return this.shieldActive ? this.getRfPerTick() : 0;
    }

    @Nullable
    public String getEnergyUnitName() {
        return "RF";
    }

    public boolean isMachineActive() {
        return this.shieldActive;
    }

    public boolean isMachineRunning() {
        return this.shieldActive;
    }

    @Nullable
    public String getMachineStatus() {
        return this.shieldActive ? "active" : "idle";
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        boolean newShieldActive;
        boolean checkPower = false;
        if (this.powerTimeout > 0) {
            --this.powerTimeout;
            this.func_70296_d();
            if (this.powerTimeout > 0) {
                return;
            }
            checkPower = true;
        }
        boolean needsUpdate = false;
        int rf = this.getRfPerTick();
        if (rf > 0) {
            if (this.getEnergyStored() < rf) {
                this.powerTimeout = 100;
                needsUpdate = true;
            } else {
                if (checkPower) {
                    needsUpdate = true;
                }
                this.consumeEnergy(rf);
            }
        }
        if ((newShieldActive = this.isMachineEnabled()) != this.shieldActive) {
            needsUpdate = true;
            this.shieldActive = newShieldActive;
        }
        if (needsUpdate) {
            this.updateShield();
            this.func_70296_d();
        }
    }

    private int getRfPerTick() {
        int rf = this.calculateRfPerTick();
        rf = (int)((float)rf * (2.0f - this.getInfusedFactor()) / 2.0f);
        return rf;
    }

    public void composeDecomposeShield(boolean ctrl) {
        if (this.shieldComposed) {
            this.decomposeShield();
        } else {
            this.composeShield(ctrl);
        }
    }

    public void composeShield(boolean ctrl) {
        HashMap<BlockPos, IBlockState> coordinates;
        this.shieldBlocks.clear();
        this.blockStateTable.clear();
        if (this.isShapedShield()) {
            ItemStack shapeItem = this.inventoryHelper.getStackInSlot(1);
            Shape shape = ShapeCardItem.getShape(shapeItem);
            boolean solid = ShapeCardItem.isSolid(shapeItem);
            BlockPos dimension = ShapeCardItem.getClampedDimension(shapeItem, ShieldConfiguration.maxShieldDimension);
            BlockPos offset = ShapeCardItem.getClampedOffset(shapeItem, ShieldConfiguration.maxShieldOffset);
            HashMap<BlockPos, IBlockState> col = new HashMap<BlockPos, IBlockState>();
            ShapeCardItem.composeFormula(shapeItem, shape.getFormulaFactory().createFormula(), this.func_145831_w(), this.func_174877_v(), dimension, offset, col, this.supportedBlocks, solid, false, null);
            coordinates = col;
        } else {
            this.templateMeta = this.findTemplateMeta();
            HashMap<BlockPos, IBlockState> col = new HashMap<BlockPos, IBlockState>();
            this.findTemplateBlocks(col, this.templateMeta, ctrl, this.func_174877_v());
            coordinates = col;
        }
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        for (Map.Entry entry : coordinates.entrySet()) {
            BlockPos c = (BlockPos)entry.getKey();
            IBlockState state = (IBlockState)entry.getValue();
            int st = -1;
            if (state != null) {
                for (int i = 0; i < this.blockStateTable.size(); ++i) {
                    if (!state.equals(this.blockStateTable.get(i))) continue;
                    st = i;
                    break;
                }
                if (st == -1) {
                    st = this.blockStateTable.size();
                    this.blockStateTable.add(state);
                }
            }
            this.shieldBlocks.add(new RelCoordinateShield(c.func_177958_n() - xCoord, c.func_177956_o() - yCoord, c.func_177952_p() - zCoord, st));
            this.func_145831_w().func_175698_g(c);
        }
        this.shieldComposed = true;
        this.updateShield();
    }

    private boolean isShapedShield() {
        return !this.inventoryHelper.getStackInSlot(1).func_190926_b();
    }

    private int findTemplateMeta() {
        int meta = -1;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IBlockState state;
            BlockPos p = this.func_174877_v().func_177972_a(dir);
            if (p.func_177956_o() < 0 || p.func_177956_o() >= this.func_145831_w().func_72800_K() || !((Object)((Object)ShieldSetup.shieldTemplateBlock)).equals((state = this.func_145831_w().func_180495_p(p)).func_177230_c())) continue;
            meta = state.func_177230_c().func_176201_c(state);
            break;
        }
        return meta;
    }

    public void selectBlock(EntityPlayer player, BlockPos pos) {
        if (!this.shieldComposed) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Shield is not composed. Nothing happens!"));
            return;
        }
        float squaredDistance = (float)this.func_174877_v().func_177954_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        if (squaredDistance > (float)(ShieldConfiguration.maxDisjointShieldDistance * ShieldConfiguration.maxDisjointShieldDistance)) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "This template is too far to connect to the shield!"));
            return;
        }
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        Block origBlock = this.func_145831_w().func_180495_p(pos).func_177230_c();
        if (origBlock == ShieldSetup.shieldTemplateBlock) {
            if (this.isShapedShield()) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "You cannot add template blocks to a shaped shield (using a shape card)!"));
                return;
            }
            HashMap<BlockPos, IBlockState> templateBlocks = new HashMap<BlockPos, IBlockState>();
            IBlockState state = this.func_145831_w().func_180495_p(pos);
            templateBlocks.put(pos, null);
            this.findTemplateBlocks(templateBlocks, state.func_177230_c().func_176201_c(state), false, pos);
            int[] camoId = this.calculateCamoId();
            int cddata = this.calculateShieldCollisionData();
            int damageBits = this.calculateDamageBits();
            Block block = this.calculateShieldBlock(damageBits, camoId);
            for (Map.Entry entry : templateBlocks.entrySet()) {
                BlockPos templateBlock = (BlockPos)entry.getKey();
                RelCoordinateShield relc = new RelCoordinateShield(templateBlock.func_177958_n() - xCoord, templateBlock.func_177956_o() - yCoord, templateBlock.func_177952_p() - zCoord, -1);
                this.shieldBlocks.add(relc);
                this.updateShieldBlock(camoId, cddata, damageBits, block, relc);
            }
        } else if (origBlock instanceof AbstractShieldBlock) {
            this.shieldBlocks.remove(new RelCoordinate(pos.func_177958_n() - xCoord, pos.func_177956_o() - yCoord, pos.func_177952_p() - zCoord));
            if (this.isShapedShield()) {
                this.func_145831_w().func_175698_g(pos);
            } else {
                this.func_145831_w().func_180501_a(pos, ShieldSetup.shieldTemplateBlock.func_176203_a(this.templateMeta), 2);
            }
        } else {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "The selected shield can't do anything with this block!"));
            return;
        }
        this.markDirtyClient();
    }

    private void updateShield() {
        int[] camoId = this.calculateCamoId();
        int cddata = this.calculateShieldCollisionData();
        int damageBits = this.calculateDamageBits();
        Block block = this.calculateShieldBlock(damageBits, camoId);
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (RelCoordinateShield c : this.shieldBlocks) {
            if (Blocks.field_150350_a.equals(block)) {
                pos.func_181079_c(xCoord + c.getDx(), yCoord + c.getDy(), zCoord + c.getDz());
                IBlockState oldState = this.func_145831_w().func_180495_p((BlockPos)pos);
                if (!(oldState.func_177230_c() instanceof AbstractShieldBlock)) continue;
                this.func_145831_w().func_175698_g((BlockPos)pos);
                continue;
            }
            this.updateShieldBlock(camoId, cddata, damageBits, block, c);
        }
        this.markDirtyClient();
    }

    private void updateShieldBlock(int[] camoId, int cddata, int damageBits, Block block, RelCoordinateShield c) {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        BlockPos pp = new BlockPos(xCoord + c.getDx(), yCoord + c.getDy(), zCoord + c.getDz());
        IBlockState oldState = this.func_145831_w().func_180495_p(pp);
        if (!oldState.func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), pp) && oldState.func_177230_c() != ShieldSetup.shieldTemplateBlock) {
            return;
        }
        this.func_145831_w().func_180501_a(pp, block.func_176203_a(camoId[1]), 2);
        TileEntity te = this.func_145831_w().func_175625_s(pp);
        if (te instanceof NoTickShieldBlockTileEntity) {
            NoTickShieldBlockTileEntity shieldBlockTileEntity = (NoTickShieldBlockTileEntity)te;
            if (c.getState() != -1) {
                IBlockState state = this.blockStateTable.get(c.getState());
                int id = Block.func_149682_b((Block)state.func_177230_c());
                shieldBlockTileEntity.setCamoBlock(id, state.func_177230_c().func_176201_c(state), 0);
            } else {
                shieldBlockTileEntity.setCamoBlock(camoId[0], camoId[1], camoId[2]);
            }
            shieldBlockTileEntity.setShieldBlock(this.func_174877_v());
            shieldBlockTileEntity.setDamageBits(damageBits);
            shieldBlockTileEntity.setCollisionData(cddata);
            shieldBlockTileEntity.setShieldColor(this.shieldColor);
            shieldBlockTileEntity.setShieldRenderingMode(this.shieldRenderingMode);
        }
    }

    public void decomposeShield() {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        BlockPos.MutableBlockPos pp = new BlockPos.MutableBlockPos();
        for (RelCoordinate relCoordinate : this.shieldBlocks) {
            int cx = xCoord + relCoordinate.getDx();
            int cy = yCoord + relCoordinate.getDy();
            int cz = zCoord + relCoordinate.getDz();
            pp.func_181079_c(cx, cy, cz);
            Block block = this.func_145831_w().func_180495_p((BlockPos)pp).func_177230_c();
            if (this.func_145831_w().func_175623_d((BlockPos)pp) || block instanceof AbstractShieldBlock) {
                if (this.isShapedShield()) {
                    this.func_145831_w().func_175698_g((BlockPos)pp);
                    continue;
                }
                IBlockState templateBlock = ShieldSetup.shieldTemplateBlock.func_176203_a(this.templateMeta);
                this.func_145831_w().func_180501_a(new BlockPos((Vec3i)pp), templateBlock, 2);
                continue;
            }
            if (this.isShapedShield()) continue;
            BlockTools.spawnItemStack((World)this.func_145831_w(), (int)cx, (int)cy, (int)cz, (ItemStack)new ItemStack((Block)ShieldSetup.shieldTemplateBlock, 1, this.templateMeta));
        }
        this.shieldComposed = false;
        this.shieldActive = false;
        this.shieldBlocks.clear();
        this.blockStateTable.clear();
        this.markDirtyClient();
    }

    private void findTemplateBlocks(Map<BlockPos, IBlockState> coordinateSet, int meta, boolean ctrl, BlockPos start) {
        ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
        if (ctrl) {
            this.addToTodoCornered(coordinateSet, todo, start, meta);
            while (!todo.isEmpty() && coordinateSet.size() < this.supportedBlocks) {
                BlockPos coordinate = (BlockPos)todo.pollFirst();
                coordinateSet.put(coordinate, null);
                this.addToTodoCornered(coordinateSet, todo, coordinate, meta);
            }
        } else {
            this.addToTodoStraight(coordinateSet, todo, start, meta);
            while (!todo.isEmpty() && coordinateSet.size() < this.supportedBlocks) {
                BlockPos coordinate = (BlockPos)todo.pollFirst();
                coordinateSet.put(coordinate, null);
                this.addToTodoStraight(coordinateSet, todo, coordinate, meta);
            }
        }
    }

    private void addToTodoStraight(Map<BlockPos, IBlockState> coordinateSet, Deque<BlockPos> todo, BlockPos coordinate, int meta) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int m;
            IBlockState state;
            BlockPos pp = coordinate.func_177972_a(dir);
            if (pp.func_177956_o() < 0 || pp.func_177956_o() >= this.func_145831_w().func_72800_K() || coordinateSet.containsKey(pp) || !((Object)((Object)ShieldSetup.shieldTemplateBlock)).equals((state = this.func_145831_w().func_180495_p(pp)).func_177230_c()) || (m = state.func_177230_c().func_176201_c(state)) != meta || todo.contains(pp)) continue;
            todo.addLast(pp);
        }
    }

    private void addToTodoCornered(Map<BlockPos, IBlockState> coordinateSet, Deque<BlockPos> todo, BlockPos coordinate, int meta) {
        int x = coordinate.func_177958_n();
        int y = coordinate.func_177956_o();
        int z = coordinate.func_177952_p();
        BlockPos.MutableBlockPos c = new BlockPos.MutableBlockPos();
        for (int xx = x - 1; xx <= x + 1; ++xx) {
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                for (int zz = z - 1; zz <= z + 1; ++zz) {
                    int m;
                    IBlockState state;
                    if (xx == x && yy == y && zz == z || yy < 0 || yy >= this.func_145831_w().func_72800_K()) continue;
                    c.func_181079_c(xx, yy, zz);
                    if (coordinateSet.containsKey(c) || !((Object)((Object)ShieldSetup.shieldTemplateBlock)).equals((state = this.func_145831_w().func_180495_p((BlockPos)c)).func_177230_c()) || (m = state.func_177230_c().func_176201_c(state)) != meta || todo.contains(c)) continue;
                    todo.addLast(c.func_185334_h());
                }
            }
        }
    }

    private static short bytesToShort(byte b1, byte b2) {
        short s1 = (short)(b1 & 0xFF);
        short s2 = (short)(b2 & 0xFF);
        return (short)(s1 * 256 + s2);
    }

    private static byte shortToByte1(short s) {
        return (byte)((s & 0xFF00) >> 8);
    }

    private static byte shortToByte2(short s) {
        return (byte)(s & 0xFF);
    }

    public void readClientDataFromNBT(NBTTagCompound tagCompound) {
        this.powerLevel = tagCompound.func_74771_c("powered");
        this.shieldComposed = tagCompound.func_74767_n("composed");
        this.shieldActive = tagCompound.func_74767_n("active");
        this.powerTimeout = tagCompound.func_74762_e("powerTimeout");
        this.templateMeta = tagCompound.func_74762_e("templateMeta");
        this.shieldRenderingMode = ShieldRenderingMode.values()[tagCompound.func_74762_e("visMode")];
        this.rsMode = RedstoneMode.values()[tagCompound.func_74771_c(CMD_RSMODE)];
        this.damageMode = DamageTypeMode.values()[tagCompound.func_74771_c(CMD_DAMAGEMODE)];
        this.camoRenderPass = tagCompound.func_74762_e("camoRenderPass");
        this.shieldColor = tagCompound.func_74762_e("shieldColor");
        if (this.shieldColor == 0) {
            this.shieldColor = 9895880;
        }
        this.readFiltersFromNBT(tagCompound);
    }

    public void writeClientDataToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74774_a("powered", (byte)this.powerLevel);
        tagCompound.func_74757_a("composed", this.shieldComposed);
        tagCompound.func_74757_a("active", this.shieldActive);
        tagCompound.func_74768_a("powerTimeout", this.powerTimeout);
        tagCompound.func_74768_a("templateMeta", this.templateMeta);
        tagCompound.func_74768_a("visMode", this.shieldRenderingMode.ordinal());
        tagCompound.func_74774_a(CMD_RSMODE, (byte)this.rsMode.ordinal());
        tagCompound.func_74774_a(CMD_DAMAGEMODE, (byte)this.damageMode.ordinal());
        tagCompound.func_74768_a("camoRenderPass", this.camoRenderPass);
        tagCompound.func_74768_a("shieldColor", this.shieldColor);
        this.writeFiltersToNBT(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.shieldComposed = tagCompound.func_74767_n("composed");
        this.shieldActive = tagCompound.func_74767_n("active");
        this.powerTimeout = tagCompound.func_74762_e("powerTimeout");
        this.templateMeta = tagCompound.func_74762_e("templateMeta");
        this.shieldBlocks.clear();
        this.blockStateTable.clear();
        if (tagCompound.func_74764_b("relcoordsNew")) {
            byte[] byteArray = tagCompound.func_74770_j("relcoordsNew");
            int j = 0;
            for (int i = 0; i < byteArray.length / 8; ++i) {
                short dx = ShieldTEBase.bytesToShort(byteArray[j + 0], byteArray[j + 1]);
                short dy = ShieldTEBase.bytesToShort(byteArray[j + 2], byteArray[j + 3]);
                short dz = ShieldTEBase.bytesToShort(byteArray[j + 4], byteArray[j + 5]);
                short st = ShieldTEBase.bytesToShort(byteArray[j + 6], byteArray[j + 7]);
                j += 8;
                this.shieldBlocks.add(new RelCoordinateShield(dx, dy, dz, st));
            }
            NBTTagList list = tagCompound.func_150295_c("gstates", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tc = (NBTTagCompound)list.func_179238_g(i);
                String b = tc.func_74779_i("b");
                int m = tc.func_74762_e("m");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(b));
                if (block == null) {
                    block = Blocks.field_150348_b;
                    m = 0;
                }
                IBlockState state = block.func_176203_a(m);
                this.blockStateTable.add(state);
            }
        } else {
            byte[] byteArray = tagCompound.func_74770_j("relcoords");
            int j = 0;
            for (int i = 0; i < byteArray.length / 6; ++i) {
                short dx = ShieldTEBase.bytesToShort(byteArray[j + 0], byteArray[j + 1]);
                short dy = ShieldTEBase.bytesToShort(byteArray[j + 2], byteArray[j + 3]);
                short dz = ShieldTEBase.bytesToShort(byteArray[j + 4], byteArray[j + 5]);
                j += 6;
                this.shieldBlocks.add(new RelCoordinateShield(dx, dy, dz, -1));
            }
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.shieldRenderingMode = ShieldRenderingMode.values()[tagCompound.func_74762_e("visMode")];
        this.damageMode = DamageTypeMode.values()[tagCompound.func_74771_c(CMD_DAMAGEMODE)];
        this.camoRenderPass = tagCompound.func_74762_e("camoRenderPass");
        this.shieldColor = tagCompound.func_74762_e("shieldColor");
        if (this.shieldColor == 0) {
            this.shieldColor = 9895880;
        }
        this.readFiltersFromNBT(tagCompound);
    }

    private void readFiltersFromNBT(NBTTagCompound tagCompound) {
        this.filters.clear();
        NBTTagList filterList = tagCompound.func_150295_c("filters", 10);
        if (filterList != null) {
            for (int i = 0; i < filterList.func_74745_c(); ++i) {
                NBTTagCompound compound = filterList.func_150305_b(i);
                this.filters.add(AbstractShieldFilter.createFilter(compound));
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("composed", this.shieldComposed);
        tagCompound.func_74757_a("active", this.shieldActive);
        tagCompound.func_74768_a("powerTimeout", this.powerTimeout);
        tagCompound.func_74768_a("templateMeta", this.templateMeta);
        byte[] blocks = new byte[this.shieldBlocks.size() * 8];
        int j = 0;
        for (RelCoordinateShield c : this.shieldBlocks) {
            blocks[j + 0] = ShieldTEBase.shortToByte1((short)c.getDx());
            blocks[j + 1] = ShieldTEBase.shortToByte2((short)c.getDx());
            blocks[j + 2] = ShieldTEBase.shortToByte1((short)c.getDy());
            blocks[j + 3] = ShieldTEBase.shortToByte2((short)c.getDy());
            blocks[j + 4] = ShieldTEBase.shortToByte1((short)c.getDz());
            blocks[j + 5] = ShieldTEBase.shortToByte2((short)c.getDz());
            blocks[j + 6] = ShieldTEBase.shortToByte1((short)c.getState());
            blocks[j + 7] = ShieldTEBase.shortToByte2((short)c.getState());
            j += 8;
        }
        tagCompound.func_74773_a("relcoordsNew", blocks);
        NBTTagList list = new NBTTagList();
        for (IBlockState state : this.blockStateTable) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74778_a("b", state.func_177230_c().getRegistryName().toString());
            tc.func_74768_a("m", state.func_177230_c().func_176201_c(state));
            list.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("gstates", (NBTBase)list);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("visMode", this.shieldRenderingMode.ordinal());
        tagCompound.func_74774_a(CMD_DAMAGEMODE, (byte)this.damageMode.ordinal());
        tagCompound.func_74768_a("camoRenderPass", this.camoRenderPass);
        tagCompound.func_74768_a("shieldColor", this.shieldColor);
        this.writeFiltersToNBT(tagCompound);
    }

    private void writeFiltersToNBT(NBTTagCompound tagCompound) {
        NBTTagList filterList = new NBTTagList();
        for (ShieldFilter filter : this.filters) {
            NBTTagCompound compound = new NBTTagCompound();
            filter.writeToNBT(compound);
            filterList.func_74742_a((NBTBase)compound);
        }
        tagCompound.func_74782_a("filters", (NBTBase)filterList);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SHIELDVISMODE.equals(command)) {
            String m = args.get("mode").getString();
            this.setShieldRenderingMode(ShieldRenderingMode.getMode(m));
            return true;
        }
        if (CMD_APPLYCAMO.equals(command)) {
            this.camoRenderPass = args.get("pass").getInteger();
            this.updateShield();
            return true;
        }
        if (CMD_ADDFILTER.equals(command)) {
            int action = args.get("action").getInteger();
            String type = args.get("type").getString();
            String player = args.get("player").getString();
            int selected = args.get("selected").getInteger();
            this.addFilter(action, type, player, selected);
            return true;
        }
        if (CMD_DELFILTER.equals(command)) {
            int selected = args.get("selected").getInteger();
            this.delFilter(selected);
            return true;
        }
        if (CMD_UPFILTER.equals(command)) {
            int selected = args.get("selected").getInteger();
            this.upFilter(selected);
            return true;
        }
        if (CMD_DOWNFILTER.equals(command)) {
            int selected = args.get("selected").getInteger();
            this.downFilter(selected);
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            String m = args.get("rs").getString();
            this.setRSMode(RedstoneMode.getMode((String)m));
            return true;
        }
        if (CMD_DAMAGEMODE.equals(command)) {
            String m = args.get("mode").getString();
            this.setDamageMode(DamageTypeMode.getMode(m));
            return true;
        }
        if (CMD_SETCOLOR.equals(command)) {
            int color = args.get("color").getInteger();
            this.setShieldColor(color);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, Map<String, Argument> args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getFilters".equals(command)) {
            return type.convert(this.getFilters());
        }
        return Collections.emptyList();
    }

    public <T> boolean execute(String command, List<T> list, Type<T> type) {
        boolean rc = super.execute(command, list, type);
        if (rc) {
            return true;
        }
        if ("getFilters".equals(command)) {
            GuiShield.storeFiltersForClient(Type.create(ShieldFilter.class).convert(list));
            return true;
        }
        return false;
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack stackInSlot;
        if (index == 1 && !this.inventoryHelper.getStackInSlot(index).func_190926_b() && amount > 0) {
            this.decomposeShield();
        }
        if (!(stackInSlot = this.inventoryHelper.getStackInSlot(index)).func_190926_b()) {
            if (stackInSlot.func_190916_E() <= amount) {
                ItemStack old = stackInSlot.func_77946_l();
                this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, ItemStack.field_190927_a);
                this.func_70296_d();
                return old;
            }
            ItemStack its = stackInSlot.func_77979_a(amount);
            if (stackInSlot.func_190926_b()) {
                this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return its;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index == 1 && (stack.func_190926_b() && !this.inventoryHelper.getStackInSlot(index).func_190926_b() || !stack.func_190926_b() && this.inventoryHelper.getStackInSlot(index).func_190926_b())) {
            this.decomposeShield();
        }
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            int amount = this.func_70297_j_();
            if (amount <= 0) {
                stack.func_190920_e(0);
            } else {
                stack.func_190920_e(amount);
            }
        }
        this.func_70296_d();
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }
}

