/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import java.util.Map;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketServerCommand;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.spawner.MatterBeamerContainer;
import mcjty.rftools.blocks.spawner.SpawnerConfiguration;
import mcjty.rftools.blocks.spawner.SpawnerTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MatterBeamerTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable {
    public static final int TICKTIME = 20;
    public static String CMD_SETDESTINATION = "setDest";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, MatterBeamerContainer.factory, 1);
    private BlockPos destination = null;
    private boolean glowing = false;
    private int ticker = 20;

    public MatterBeamerTileEntity() {
        super(SpawnerConfiguration.BEAMER_MAXENERGY, SpawnerConfiguration.BEAMER_RECEIVEPERTICK);
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    public boolean isPowered() {
        return this.powerLevel != 0;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    private void checkStateServer() {
        if (this.powerLevel == 0) {
            this.disableBlockGlow();
            return;
        }
        --this.ticker;
        if (this.ticker > 0) {
            return;
        }
        this.ticker = 20;
        TileEntity te = null;
        if (this.destination != null) {
            te = this.func_145831_w().func_175625_s(this.destination);
            if (!(te instanceof SpawnerTileEntity)) {
                this.setDestination(null);
                return;
            }
        } else {
            return;
        }
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack.func_190926_b()) {
            this.disableBlockGlow();
            return;
        }
        SpawnerTileEntity spawnerTileEntity = (SpawnerTileEntity)te;
        int maxblocks = (int)((double)SpawnerConfiguration.beamBlocksPerSend * (1.01 + (double)this.getInfusedFactor() * 2.0));
        int numblocks = Math.min(maxblocks, itemStack.func_190916_E());
        int rf = (int)((float)(SpawnerConfiguration.beamRfPerObject * numblocks) * (4.0f - this.getInfusedFactor()) / 4.0f);
        if (this.getEnergyStored() < rf) {
            return;
        }
        this.consumeEnergy(rf);
        if (spawnerTileEntity.addMatter(itemStack, numblocks, this.getInfusedFactor())) {
            this.inventoryHelper.decrStackSize(0, numblocks);
            this.enableBlockGlow();
        }
    }

    private void disableBlockGlow() {
        if (this.glowing) {
            this.glowing = false;
            this.markDirtyClient();
        }
    }

    private void enableBlockGlow() {
        if (!this.glowing) {
            this.glowing = true;
            this.markDirtyClient();
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean oldglowing = this.glowing;
        super.onDataPacket(net, packet);
        if (this.func_145831_w().field_72995_K && oldglowing != this.glowing) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        return new AxisAlignedBB((double)(xCoord - 4), (double)(yCoord - 4), (double)(zCoord - 4), (double)(xCoord + 5), (double)(yCoord + 5), (double)(zCoord + 5));
    }

    public void useWrench(EntityPlayer player) {
        BlockPos coord = RFTools.instance.clientInfo.getSelectedTE();
        TileEntity tileEntity = null;
        if (coord != null) {
            tileEntity = this.func_145831_w().func_175625_s(coord);
        }
        if (!(tileEntity instanceof MatterBeamerTileEntity)) {
            RFTools.instance.clientInfo.setSelectedTE(this.func_174877_v());
            SpawnerTileEntity destinationTE = this.getDestinationTE();
            if (destinationTE == null) {
                RFTools.instance.clientInfo.setDestinationTE(null);
            } else {
                RFTools.instance.clientInfo.setDestinationTE(destinationTE.func_174877_v());
            }
            Logging.message((EntityPlayer)player, (String)"Select a spawner as destination");
        } else if (coord.equals((Object)this.func_174877_v())) {
            RFTools.instance.clientInfo.setSelectedTE(null);
            RFTools.instance.clientInfo.setDestinationTE(null);
            this.setDestination(null);
            Logging.message((EntityPlayer)player, (String)"Destination cleared!");
        }
    }

    public void setDestination(BlockPos destination) {
        this.destination = destination;
        this.disableBlockGlow();
        this.func_70296_d();
        if (this.func_145831_w().field_72995_K) {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketServerCommand(this.func_174877_v(), CMD_SETDESTINATION, new Argument[]{new Argument("dest", destination)}));
        } else {
            this.markDirtyClient();
        }
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    private SpawnerTileEntity getDestinationTE() {
        if (this.destination == null) {
            return null;
        }
        TileEntity te = this.func_145831_w().func_175625_s(this.destination);
        if (te instanceof SpawnerTileEntity) {
            return (SpawnerTileEntity)te;
        }
        this.destination = null;
        this.markDirtyClient();
        return null;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.destination = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"dest");
        this.glowing = tagCompound.func_74767_n("glowing");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"dest", (BlockPos)this.destination);
        tagCompound.func_74757_a("glowing", this.glowing);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public int[] func_180463_a(EnumFacing side) {
        return MatterBeamerContainer.factory.getAccessibleSlots();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return MatterBeamerContainer.factory.isInputSlot(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return MatterBeamerContainer.factory.isOutputSlot(index);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETDESTINATION.equals(command)) {
            this.setDestination(args.get("dest").getCoordinate());
            return true;
        }
        return false;
    }
}

