/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.clientinfo.InfoPacketClient;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.blocks.storage.StorageInfoPacketClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class StorageInfoPacketServer
implements InfoPacketServer {
    private int dimension;
    private BlockPos pos;

    public StorageInfoPacketServer() {
    }

    public StorageInfoPacketServer(int dimension, BlockPos pos) {
        this.dimension = dimension;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.pos = NetworkTools.readPos((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
    }

    public Optional<InfoPacketClient> onMessageServer(EntityPlayerMP player) {
        TileEntity te;
        WorldServer world = DimensionManager.getWorld((int)this.dimension);
        int cnt = -1;
        String nameModule = "";
        if (world != null && (te = world.func_175625_s(this.pos)) instanceof ModularStorageTileEntity) {
            ModularStorageTileEntity modularStorageTileEntity = (ModularStorageTileEntity)te;
            cnt = modularStorageTileEntity.getNumStacks();
            ItemStack storageModule = modularStorageTileEntity.func_70301_a(0);
            if (!storageModule.func_190926_b() && storageModule.func_77978_p().func_74764_b("display")) {
                nameModule = storageModule.func_82833_r();
            }
        }
        return Optional.of(new StorageInfoPacketClient(cnt, nameModule));
    }
}

