/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericEnergyStorageTileEntity;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Scrollable;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.teleporter.DialingDeviceTileEntity;
import mcjty.rftools.blocks.teleporter.PacketGetReceivers;
import mcjty.rftools.blocks.teleporter.PacketGetTransmitters;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinationClientInfo;
import mcjty.rftools.blocks.teleporter.TransmitterInfo;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiDialingDevice
extends GenericGuiContainer<DialingDeviceTileEntity> {
    public static final int DIALER_WIDTH = 256;
    public static final int DIALER_HEIGHT = 224;
    private static final ResourceLocation guielements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private EnergyBar energyBar;
    private WidgetList transmitterList;
    private WidgetList receiverList;
    private Button dialButton;
    private Button dialOnceButton;
    private Button interruptButton;
    private ImageChoiceLabel favoriteButton;
    private Button statusButton;
    private Label statusLabel;
    private boolean analyzerAvailable = false;
    private boolean lastDialedTransmitter = false;
    private boolean lastCheckedReceiver = false;
    public static int fromServer_receiverStatus = -1;
    public static int fromServer_dialResult = -1;
    public static List<TeleportDestinationClientInfo> fromServer_receivers = null;
    public static List<TransmitterInfo> fromServer_transmitters = null;
    private List<TeleportDestinationClientInfo> receivers = null;
    private boolean receiversFiltered = false;
    private List<TransmitterInfo> transmitters = null;
    private int listDirty = 10;

    public GuiDialingDevice(DialingDeviceTileEntity dialingDeviceTileEntity, EmptyContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)dialingDeviceTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "tpdialer");
        GenericEnergyStorageTileEntity.setCurrentRF((int)dialingDeviceTileEntity.getEnergyStored());
        this.field_146999_f = 256;
        this.field_147000_g = 224;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((DialingDeviceTileEntity)this.tileEntity).getMaxEnergyStored();
        this.energyBar = ((EnergyBar)((EnergyBar)((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setFilledRectThickness(1)).setHorizontal().setDesiredWidth(80)).setDesiredHeight(12)).setMaxValue(maxEnergyStored).setShowText(false);
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        Panel transmitterPanel = this.setupTransmitterPanel();
        Panel receiverPanel = this.setupReceiverPanel();
        this.dialButton = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Dial")).setTooltips(new String[]{"Start a connection between", "the selected transmitter", "and the selected receiver"})).setDesiredHeight(14)).setDesiredWidth(65)).addButtonEvent(parent -> this.dial(false));
        this.dialOnceButton = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Dial Once")).setTooltips(new String[]{"Dial a connection for a", "single teleport"})).setDesiredHeight(14)).setDesiredWidth(65)).addButtonEvent(parent -> this.dial(true));
        this.interruptButton = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Interrupt")).setTooltips(new String[]{"Interrupt a connection", "for the selected transmitter"})).setDesiredHeight(14)).setDesiredWidth(65)).addButtonEvent(parent -> this.interruptDial());
        this.favoriteButton = (ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent((parent, newChoice) -> this.changeShowFavorite()).setDesiredWidth(10)).setDesiredHeight(10);
        this.favoriteButton.addChoice("No", "Unfavorited receiver", guielements, 131, 19);
        this.favoriteButton.addChoice("Yes", "Favorited receiver", guielements, 115, 19);
        this.favoriteButton.setCurrentChoice(((DialingDeviceTileEntity)this.tileEntity).isShowOnlyFavorites() ? 1 : 0);
        Panel buttonPanel = (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)this.dialButton)).addChild((Widget)this.dialOnceButton)).addChild((Widget)this.interruptButton)).addChild((Widget)this.favoriteButton)).setDesiredHeight(16);
        this.analyzerAvailable = DialingDeviceTileEntity.isDestinationAnalyzerAvailable((World)this.field_146297_k.field_71441_e, ((DialingDeviceTileEntity)this.tileEntity).func_174877_v());
        this.statusButton = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Check")).setDesiredHeight(14)).setDesiredWidth(65)).setEnabled(this.analyzerAvailable)).addButtonEvent(parent -> this.checkStatus());
        if (this.analyzerAvailable) {
            this.statusButton.setTooltips(new String[]{"Check the status of", "the selected receiver"});
        } else {
            this.statusButton.setTooltips(new String[]{"Check the status of", "the selected receiver", "(needs an adjacent analyzer!)"});
        }
        this.statusLabel = new Label(this.field_146297_k, (Gui)this);
        this.statusLabel.setDesiredWidth(170).setDesiredHeight(14).setFilledRectThickness(1);
        Panel statusPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)this.statusButton)).addChild((Widget)this.statusLabel)).setDesiredHeight(16);
        AbstractContainerWidget toplevel = ((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)((VerticalLayout)new VerticalLayout().setVerticalMargin(3)).setSpacing(1)).addChild((Widget)this.energyBar)).addChild((Widget)transmitterPanel)).addChild((Widget)receiverPanel)).addChild((Widget)buttonPanel)).addChild((Widget)statusPanel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, 256, 224));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        Keyboard.enableRepeatEvents((boolean)true);
        fromServer_receivers = null;
        fromServer_transmitters = null;
        this.listDirty = 0;
        this.clearSelectedStatus();
        this.requestReceivers();
        this.requestTransmitters();
        ((DialingDeviceTileEntity)this.tileEntity).requestRfFromServer("rftools");
    }

    private Panel setupReceiverPanel() {
        this.receiverList = ((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setRowheight(14).setDesiredHeight(100)).setPropagateEventsToChildren(true).addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void select(Widget parent, int index) {
                GuiDialingDevice.this.clearSelectedStatus();
            }

            public void doubleClick(Widget parent, int index) {
                GuiDialingDevice.this.hilightSelectedReceiver(index);
            }
        });
        Slider receiverSlider = ((Slider)((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(11)).setDesiredHeight(100)).setVertical().setScrollable((Scrollable)this.receiverList);
        return (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(3)).addChild((Widget)this.receiverList)).addChild((Widget)receiverSlider)).setDesiredHeight(106)).setFilledBackground(-6381922);
    }

    private Panel setupTransmitterPanel() {
        this.transmitterList = ((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setRowheight(18).setDesiredHeight(58)).addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void select(Widget parent, int index) {
                GuiDialingDevice.this.clearSelectedStatus();
                GuiDialingDevice.this.selectReceiverFromTransmitter();
            }

            public void doubleClick(Widget parent, int index) {
                GuiDialingDevice.this.hilightSelectedTransmitter(index);
            }
        });
        Slider transmitterSlider = ((Slider)((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(11)).setDesiredHeight(58)).setVertical().setScrollable((Scrollable)this.transmitterList);
        return (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(3)).addChild((Widget)this.transmitterList)).addChild((Widget)transmitterSlider)).setDesiredHeight(64)).setFilledBackground(-6381922);
    }

    private void clearSelectedStatus() {
        this.lastDialedTransmitter = false;
        this.lastCheckedReceiver = false;
    }

    private void hilightSelectedTransmitter(int index) {
        TransmitterInfo transmitterInfo = this.getSelectedTransmitter(index);
        if (transmitterInfo == null) {
            return;
        }
        BlockPos c = transmitterInfo.getCoordinate();
        RFTools.instance.clientInfo.hilightBlock(c, System.currentTimeMillis() + 5000L);
        GuiDialingDevice guiDialingDevice = this;
        guiDialingDevice.field_146297_k.func_71410_x().field_71439_g.func_71053_j();
    }

    private void hilightSelectedReceiver(int index) {
        TeleportDestinationClientInfo destination = this.getSelectedReceiver(index);
        if (destination == null) {
            return;
        }
        BlockPos c = destination.getCoordinate();
        double distance = new Vec3d((double)c.func_177958_n(), (double)c.func_177956_o(), (double)c.func_177952_p()).func_72438_d(this.field_146297_k.field_71439_g.func_174791_d());
        if (destination.getDimension() != this.field_146297_k.field_71441_e.field_73011_w.getDimension() || distance > 150.0) {
            Logging.warn((EntityPlayer)this.field_146297_k.field_71439_g, (String)"Receiver is too far to hilight!");
            GuiDialingDevice guiDialingDevice = this;
            guiDialingDevice.field_146297_k.func_71410_x().field_71439_g.func_71053_j();
            return;
        }
        RFTools.instance.clientInfo.hilightBlock(c, System.currentTimeMillis() + 5000L);
        Logging.message((EntityPlayer)this.field_146297_k.field_71439_g, (String)"The receiver is now highlighted");
        GuiDialingDevice guiDialingDevice = this;
        guiDialingDevice.field_146297_k.func_71410_x().field_71439_g.func_71053_j();
    }

    private void setStatusError(String message) {
        this.statusLabel.setText(message);
        this.statusLabel.setColor(-1);
        this.statusLabel.setFilledBackground(-65536, -7864320);
    }

    private void setStatusMessage(String message) {
        this.statusLabel.setText(message);
        this.statusLabel.setColor(-16777216);
        this.statusLabel.setFilledBackground(-16711936, -16742400);
    }

    private void checkStatus() {
        int receiverSelected = this.receiverList.getSelected();
        TeleportDestinationClientInfo destination = this.getSelectedReceiver(receiverSelected);
        if (destination == null) {
            return;
        }
        BlockPos c = destination.getCoordinate();
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketRequestIntegerFromServer("rftools", ((DialingDeviceTileEntity)this.tileEntity).func_174877_v(), "checkStatus", "status", new Argument[]{new Argument("c", c), new Argument("dim", destination.getDimension())}));
        this.lastCheckedReceiver = true;
        this.listDirty = 0;
    }

    private void showStatus(int dialResult) {
        if ((dialResult & 8) != 0) {
            this.setStatusError("Dialing device power low!");
            return;
        }
        if ((dialResult & 0x10) != 0) {
            this.setStatusError("Matter receiver power low!");
            return;
        }
        if ((dialResult & 0x200) != 0) {
            this.setStatusError("Destination dimension power low!");
            return;
        }
        if ((dialResult & 0x20) != 0) {
            this.setStatusError("No access to transmitter!");
            return;
        }
        if ((dialResult & 0x40) != 0) {
            this.setStatusError("No access to receiver!");
            return;
        }
        if ((dialResult & 4) != 0) {
            this.setStatusError("Invalid destination!");
            return;
        }
        if ((dialResult & 0x100) != 0) {
            this.setStatusError("Invalid source!");
            return;
        }
        if ((dialResult & 1) != 0) {
            this.setStatusError("Receiver blocked!");
            return;
        }
        if ((dialResult & 2) != 0) {
            this.setStatusError("Transmitter blocked!");
            return;
        }
        if ((dialResult & 0x400) != 0) {
            this.setStatusError("Invalid transmitter!!");
            return;
        }
        if ((dialResult & 0x80) != 0) {
            this.setStatusMessage("Interrupted!");
            return;
        }
        this.setStatusMessage("Dial ok!");
    }

    private void selectReceiverFromTransmitter() {
        this.receiverList.setSelected(-1);
        TeleportDestination destination = this.getSelectedTransmitterDestination();
        if (destination == null) {
            return;
        }
        int i = 0;
        for (TeleportDestination teleportDestination : this.receivers) {
            if (teleportDestination.getDimension() == destination.getDimension() && teleportDestination.getCoordinate().equals((Object)destination.getCoordinate())) {
                this.receiverList.setSelected(i);
                return;
            }
            ++i;
        }
    }

    private void dial(boolean once) {
        int transmitterSelected = this.transmitterList.getSelected();
        TransmitterInfo transmitterInfo = this.getSelectedTransmitter(transmitterSelected);
        if (transmitterInfo == null) {
            return;
        }
        int receiverSelected = this.receiverList.getSelected();
        TeleportDestinationClientInfo destination = this.getSelectedReceiver(receiverSelected);
        if (destination == null) {
            return;
        }
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketRequestIntegerFromServer("rftools", ((DialingDeviceTileEntity)this.tileEntity).func_174877_v(), once ? "dialOnce" : "dial", "dialResult", new Argument[]{new Argument("player", this.field_146297_k.field_71439_g.func_70005_c_()), new Argument("trans", transmitterInfo.getCoordinate()), new Argument("transDim", this.field_146297_k.field_71441_e.field_73011_w.getDimension()), new Argument("c", destination.getCoordinate()), new Argument("dim", destination.getDimension())}));
        this.lastDialedTransmitter = true;
        this.listDirty = 0;
    }

    private TeleportDestinationClientInfo getSelectedReceiver(int receiverSelected) {
        if (receiverSelected == -1) {
            return null;
        }
        if (receiverSelected >= this.receivers.size()) {
            return null;
        }
        return this.receivers.get(receiverSelected);
    }

    private void interruptDial() {
        int transmitterSelected = this.transmitterList.getSelected();
        TransmitterInfo transmitterInfo = this.getSelectedTransmitter(transmitterSelected);
        if (transmitterInfo == null) {
            return;
        }
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketRequestIntegerFromServer("rftools", ((DialingDeviceTileEntity)this.tileEntity).func_174877_v(), "dial", "dialResult", new Argument[]{new Argument("player", this.field_146297_k.field_71439_g.func_70005_c_()), new Argument("trans", transmitterInfo.getCoordinate()), new Argument("transDim", this.field_146297_k.field_71441_e.field_73011_w.getDimension()), new Argument("c", (BlockPos)null), new Argument("dim", 0)}));
        this.lastDialedTransmitter = true;
        this.listDirty = 0;
    }

    private void requestReceivers() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetReceivers(((DialingDeviceTileEntity)this.tileEntity).func_174877_v(), this.field_146297_k.field_71439_g.func_70005_c_()));
    }

    private void requestTransmitters() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetTransmitters(((DialingDeviceTileEntity)this.tileEntity).func_174877_v()));
    }

    private void changeShowFavorite() {
        boolean fav = this.favoriteButton.getCurrentChoiceIndex() == 1;
        this.sendServerCommand(RFToolsMessages.INSTANCE, "showFavorite", new Argument[]{new Argument("favorite", fav)});
        this.listDirty = 0;
        this.transmitterList.setSelected(-1);
        this.receiverList.setSelected(-1);
    }

    private void changeFavorite() {
        int receiverSelected = this.receiverList.getSelected();
        TeleportDestinationClientInfo destination = this.getSelectedReceiver(receiverSelected);
        if (destination == null) {
            return;
        }
        boolean favorite = destination.isFavorite();
        destination.setFavorite(!favorite);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "favorite", new Argument[]{new Argument("player", this.field_146297_k.field_71439_g.func_70005_c_()), new Argument("receiver", destination.getCoordinate()), new Argument("dimension", destination.getDimension()), new Argument("favorite", !favorite)});
        this.listDirty = 0;
    }

    private void populateReceivers() {
        boolean newReceiversFiltered;
        List<TeleportDestinationClientInfo> newReceivers = fromServer_receivers;
        if (newReceivers == null) {
            return;
        }
        boolean bl = newReceiversFiltered = this.favoriteButton.getCurrentChoiceIndex() == 1;
        if (newReceivers.equals(this.receivers) && newReceiversFiltered == this.receiversFiltered) {
            return;
        }
        this.receiversFiltered = newReceiversFiltered;
        if (this.receiversFiltered) {
            this.receivers = new ArrayList<TeleportDestinationClientInfo>();
            for (TeleportDestinationClientInfo receiver : newReceivers) {
                if (!receiver.isFavorite()) continue;
                this.receivers.add(receiver);
            }
        } else {
            this.receivers = new ArrayList<TeleportDestinationClientInfo>(newReceivers);
        }
        this.receiverList.removeChildren();
        for (TeleportDestinationClientInfo destination : this.receivers) {
            BlockPos coordinate = destination.getCoordinate();
            String dimName = destination.getDimensionName();
            if (dimName == null || dimName.trim().isEmpty()) {
                dimName = "Id " + destination.getDimension();
            }
            boolean favorite = destination.isFavorite();
            Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(3));
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal).setText(destination.getName()).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setDesiredWidth(96).setTooltips(new String[]{"The name of the", "destination receiver:", destination.getName() + " (" + BlockPosTools.toString((BlockPos)coordinate) + ")"}));
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal).setText(dimName).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setDynamic(true).setTooltips(new String[]{"The name of the", "destination dimension:", dimName}).setDesiredWidth(110));
            ImageChoiceLabel choiceLabel = (ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent((parent, newChoice) -> this.changeFavorite()).setDesiredWidth(10);
            choiceLabel.addChoice("No", "Not favorited", guielements, 131, 19);
            choiceLabel.addChoice("Yes", "Favorited", guielements, 115, 19);
            choiceLabel.setCurrentChoice(favorite ? 1 : 0);
            panel.addChild((Widget)choiceLabel);
            this.receiverList.addChild((Widget)panel);
        }
    }

    private TeleportDestination getSelectedTransmitterDestination() {
        int transmitterSelected = this.transmitterList.getSelected();
        TransmitterInfo transmitterInfo = this.getSelectedTransmitter(transmitterSelected);
        if (transmitterInfo == null) {
            return null;
        }
        TeleportDestination destination = transmitterInfo.getTeleportDestination();
        if (destination.isValid()) {
            return destination;
        }
        return null;
    }

    private void populateTransmitters() {
        List<TransmitterInfo> newTransmitters = fromServer_transmitters;
        if (newTransmitters == null) {
            return;
        }
        if (newTransmitters.equals(this.transmitters)) {
            return;
        }
        this.transmitters = new ArrayList<TransmitterInfo>(newTransmitters);
        this.transmitterList.removeChildren();
        for (TransmitterInfo transmitterInfo : this.transmitters) {
            BlockPos coordinate = transmitterInfo.getCoordinate();
            TeleportDestination destination = transmitterInfo.getTeleportDestination();
            Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout().setHorizontalMargin(3));
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal).setText(transmitterInfo.getName()).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setDesiredWidth(102));
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal).setDynamic(true).setText(BlockPosTools.toString((BlockPos)coordinate)).setDesiredWidth(90));
            panel.addChild((Widget)new ImageLabel(this.field_146297_k, (Gui)this).setImage(guielements, destination.isValid() ? 80 : 96, 0).setDesiredWidth(16));
            this.transmitterList.addChild((Widget)panel);
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.requestListsIfNeeded();
        this.populateReceivers();
        this.populateTransmitters();
        if (this.lastDialedTransmitter) {
            this.showStatus(fromServer_dialResult);
        } else if (this.lastCheckedReceiver) {
            this.showStatus(fromServer_receiverStatus);
        } else {
            this.statusLabel.setText("");
            this.statusLabel.setColor(-16777216);
            this.statusLabel.setFilledBackground(-1);
        }
        this.enableButtons();
        this.drawWindow();
        int currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((DialingDeviceTileEntity)this.tileEntity).requestRfFromServer("rftools");
    }

    private void requestListsIfNeeded() {
        if (fromServer_receivers != null && fromServer_transmitters != null) {
            return;
        }
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestReceivers();
            this.requestTransmitters();
            this.listDirty = 10;
        }
    }

    private String calculateDistance(int transmitterSelected, int receiverSelected) {
        TransmitterInfo transmitterInfo = this.getSelectedTransmitter(transmitterSelected);
        if (transmitterInfo == null) {
            return "?";
        }
        TeleportDestinationClientInfo teleportDestination = this.getSelectedReceiver(receiverSelected);
        if (teleportDestination == null) {
            return "?";
        }
        return DialingDeviceTileEntity.calculateDistance((World)this.field_146297_k.field_71441_e, transmitterInfo, teleportDestination);
    }

    private TransmitterInfo getSelectedTransmitter(int transmitterSelected) {
        if (transmitterSelected == -1) {
            return null;
        }
        if (transmitterSelected >= this.transmitters.size()) {
            return null;
        }
        return this.transmitters.get(transmitterSelected);
    }

    private void enableButtons() {
        int transmitterSelected = this.transmitterList.getSelected();
        if (this.transmitters == null || transmitterSelected >= this.transmitters.size()) {
            transmitterSelected = -1;
            this.transmitterList.setSelected(-1);
        }
        int receiverSelected = this.receiverList.getSelected();
        if (this.receivers == null || receiverSelected >= this.receivers.size()) {
            receiverSelected = -1;
            this.receiverList.setSelected(-1);
        }
        if (transmitterSelected != -1 && receiverSelected != -1) {
            this.dialButton.setEnabled(true);
            this.dialOnceButton.setEnabled(true);
            String distance = this.calculateDistance(transmitterSelected, receiverSelected);
            this.dialButton.setTooltips(new String[]{"Start a connection between", "the selected transmitter", "and the selected receiver.", "Distance: " + distance});
            this.dialOnceButton.setTooltips(new String[]{"Dial a connection for a", "single teleport.", "Distance: " + distance});
        } else {
            this.dialButton.setEnabled(false);
            this.dialOnceButton.setEnabled(false);
            this.dialButton.setTooltips(new String[]{"Start a connection between", "the selected transmitter", "and the selected receiver"});
            this.dialOnceButton.setTooltips(new String[]{"Dial a connection for a", "single teleport"});
        }
        if (transmitterSelected != -1) {
            TeleportDestination destination = this.getSelectedTransmitterDestination();
            this.interruptButton.setEnabled(destination != null);
        } else {
            this.interruptButton.setEnabled(false);
        }
        if (receiverSelected != -1) {
            this.statusButton.setEnabled(this.analyzerAvailable);
        } else {
            this.statusButton.setEnabled(false);
        }
    }
}

