/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.blocks.storage.ModularStorageItemContainer;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.RemoteStorageItemContainer;
import mcjty.rftools.blocks.storagemonitor.StorageScannerContainer;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.PacketGridToClient;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRequestGridSync
implements IMessage {
    private BlockPos pos;

    public void fromBytes(ByteBuf buf) {
        this.pos = buf.readBoolean() ? NetworkTools.readPos((ByteBuf)buf) : null;
    }

    public void toBytes(ByteBuf buf) {
        if (this.pos != null) {
            buf.writeBoolean(true);
            NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        } else {
            buf.writeBoolean(false);
        }
    }

    public PacketRequestGridSync() {
    }

    public PacketRequestGridSync(BlockPos pos) {
        this.pos = pos;
    }

    public static class Handler
    implements IMessageHandler<PacketRequestGridSync, IMessage> {
        public IMessage onMessage(PacketRequestGridSync message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketRequestGridSync message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.func_130014_f_();
            CraftingGridProvider provider = null;
            if (message.pos == null) {
                ItemStack mainhand = player.func_184614_ca();
                if (!mainhand.func_190926_b() && mainhand.func_77973_b() == ModularStorageSetup.storageModuleTabletItem) {
                    if (player.field_71070_bA instanceof ModularStorageItemContainer) {
                        ModularStorageItemContainer storageItemContainer = (ModularStorageItemContainer)player.field_71070_bA;
                        provider = storageItemContainer.getCraftingGridProvider();
                    } else if (player.field_71070_bA instanceof RemoteStorageItemContainer) {
                        RemoteStorageItemContainer storageItemContainer = (RemoteStorageItemContainer)player.field_71070_bA;
                        provider = storageItemContainer.getCraftingGridProvider();
                    } else if (player.field_71070_bA instanceof StorageScannerContainer) {
                        StorageScannerContainer storageItemContainer = (StorageScannerContainer)player.field_71070_bA;
                        provider = storageItemContainer.getStorageScannerTileEntity();
                    }
                }
            } else {
                TileEntity te = world.func_175625_s(message.pos);
                if (te instanceof CraftingGridProvider) {
                    provider = (CraftingGridProvider)te;
                }
            }
            if (provider != null) {
                RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketGridToClient(message.pos, provider.getCraftingGrid()), player);
            }
        }
    }
}

