/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.modifier;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.gui.Scrollable;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.rftools.RFTools;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.modifier.ModifierCommand;
import mcjty.rftools.items.modifier.ModifierContainer;
import mcjty.rftools.items.modifier.ModifierEntry;
import mcjty.rftools.items.modifier.ModifierFilterOperation;
import mcjty.rftools.items.modifier.ModifierFilterType;
import mcjty.rftools.items.modifier.ModifierItem;
import mcjty.rftools.items.modifier.PacketUpdateModifier;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiModifier
extends GenericGuiContainer {
    public static final int MODIFIER_WIDTH = 180;
    public static final int MODIFIER_HEIGHT = 228;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/modifier.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private ChoiceLabel mode;
    private ChoiceLabel op;
    private Button add;
    private Button del;
    private Button up;
    private Button down;
    private WidgetList list;

    public GuiModifier(ModifierContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, null, (Container)container, RFTools.GUI_MANUAL_SHAPE, "modifier");
        this.field_146999_f = 180;
        this.field_147000_g = 228;
    }

    private ItemStack getItem() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        return player.func_184586_b(EnumHand.MAIN_HAND);
    }

    private boolean isValidItem() {
        ItemStack item = this.getItem();
        return !item.func_190926_b() && item.func_77973_b() == ModItems.modifierItem;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackground(iconLocation);
        this.mode = new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{ModifierFilterType.FILTER_SLOT.getCode(), ModifierFilterType.FILTER_ORE.getCode(), ModifierFilterType.FILTER_LIQUID.getCode(), ModifierFilterType.FILTER_TILEENTITY.getCode()});
        this.mode.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(30, 9, 45, 14));
        toplevel.addChild((Widget)this.mode);
        this.op = new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{ModifierFilterOperation.OPERATION_SLOT.getCode(), ModifierFilterOperation.OPERATION_VOID.getCode()});
        this.op.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(110, 9, 40, 14));
        toplevel.addChild((Widget)this.op);
        this.add = (Button)new Button(this.field_146297_k, (Gui)this).setText("Add");
        this.add.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 30, 40, 13));
        this.add.addButtonEvent(parent -> this.addOp());
        toplevel.addChild((Widget)this.add);
        this.del = (Button)new Button(this.field_146297_k, (Gui)this).setText("Del");
        this.del.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(52, 30, 40, 13));
        this.del.addButtonEvent(parent -> this.delOp());
        toplevel.addChild((Widget)this.del);
        this.up = (Button)new Button(this.field_146297_k, (Gui)this).setText("Up");
        this.up.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(110, 30, 30, 13));
        this.up.addButtonEvent(parent -> this.upOp());
        toplevel.addChild((Widget)this.up);
        this.down = (Button)new Button(this.field_146297_k, (Gui)this).setText("Down");
        this.down.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(142, 30, 30, 13));
        this.down.addButtonEvent(parent -> this.downOp());
        toplevel.addChild((Widget)this.down);
        this.list = new WidgetList(this.field_146297_k, (Gui)this);
        this.list.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(9, 45, 153, 95));
        toplevel.addChild((Widget)this.list);
        Slider slider = new Slider(this.field_146297_k, (Gui)this).setVertical().setScrollable((Scrollable)this.list);
        slider.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(162, 45, 10, 95));
        toplevel.addChild((Widget)slider);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void refreshList() {
        this.list.removeChildren();
        List<ModifierEntry> modifiers = this.getModifiers();
        for (ModifierEntry modifier : modifiers) {
            ItemStack stackIn = modifier.getIn();
            ItemStack stackOut = modifier.getOut();
            ModifierFilterType type = modifier.getType();
            ModifierFilterOperation op = modifier.getOp();
            Panel panel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setDesiredHeight(18)).setDesiredWidth(150);
            panel.addChild((Widget)((BlockRender)new BlockRender(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(1, 0, 18, 18))).setRenderItem((Object)stackIn));
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(type.getCode() + " -> " + op.getCode()).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(22, 0, 100, 18)));
            panel.addChild((Widget)((BlockRender)new BlockRender(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(130, 0, 18, 18))).setRenderItem((Object)stackOut));
            this.list.addChild((Widget)panel);
        }
    }

    private List<ModifierEntry> getModifiers() {
        if (!this.isValidItem()) {
            return Collections.emptyList();
        }
        ItemStack item = this.getItem();
        return ModifierItem.getModifiers(item);
    }

    private void addOp() {
        if (!this.isValidItem()) {
            return;
        }
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateModifier(ModifierCommand.ADD, 0, ModifierFilterType.getByCode(this.mode.getCurrentChoice()), ModifierFilterOperation.getByCode(this.op.getCurrentChoice())));
    }

    private void delOp() {
        if (this.list.getSelected() < 0) {
            return;
        }
        if (!this.isValidItem()) {
            return;
        }
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateModifier(ModifierCommand.DEL, this.list.getSelected(), ModifierFilterType.getByCode(this.mode.getCurrentChoice()), ModifierFilterOperation.getByCode(this.op.getCurrentChoice())));
    }

    private void upOp() {
        if (this.list.getSelected() <= 0) {
            return;
        }
        if (!this.isValidItem()) {
            return;
        }
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateModifier(ModifierCommand.UP, this.list.getSelected(), ModifierFilterType.getByCode(this.mode.getCurrentChoice()), ModifierFilterOperation.getByCode(this.op.getCurrentChoice())));
        this.list.setSelected(this.list.getSelected() - 1);
    }

    private void downOp() {
        if (this.list.getSelected() > this.list.getChildCount() - 1) {
            return;
        }
        if (!this.isValidItem()) {
            return;
        }
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateModifier(ModifierCommand.DOWN, this.list.getSelected(), ModifierFilterType.getByCode(this.mode.getCurrentChoice()), ModifierFilterOperation.getByCode(this.op.getCurrentChoice())));
        this.list.setSelected(this.list.getSelected() + 1);
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.refreshList();
        this.del.setEnabled(this.list.getSelected() >= 0 && this.list.getChildCount() > 0 && this.list.getSelected() < this.list.getChildCount());
        this.up.setEnabled(this.list.getSelected() > 0 && this.list.getSelected() < this.list.getChildCount());
        this.down.setEnabled(this.list.getSelected() < this.list.getChildCount() - 1 && this.list.getSelected() >= 0);
        this.drawWindow();
    }
}

