/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import io.netty.buffer.ByteBuf;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.items.teleportprobe.AdvancedChargedPorterItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketCycleDestination
implements IMessage {
    private boolean next;

    public void fromBytes(ByteBuf buf) {
        this.next = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.next);
    }

    public PacketCycleDestination() {
    }

    public PacketCycleDestination(boolean next) {
        this.next = next;
    }

    public static class Handler
    implements IMessageHandler<PacketCycleDestination, IMessage> {
        public IMessage onMessage(PacketCycleDestination message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketCycleDestination message, MessageContext ctx) {
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            ItemStack stack = playerEntity.func_184614_ca();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof AdvancedChargedPorterItem) {
                int tgt;
                NBTTagCompound tagCompound = stack.func_77978_p();
                if (tagCompound == null) {
                    return;
                }
                TeleportDestinations destinations = TeleportDestinations.getDestinations(playerEntity.func_130014_f_());
                int curtarget = tagCompound.func_74762_e("target");
                int donext = 0;
                for (int i = 0; i < 16 && (donext = this.checkTarget(playerEntity, tagCompound, destinations, curtarget, donext, tgt = message.next ? i % 8 : (16 - i) % 8)) != 2; ++i) {
                }
            }
        }

        private int checkTarget(EntityPlayerMP playerEntity, NBTTagCompound tagCompound, TeleportDestinations destinations, int curtarget, int donext, int tgt) {
            TeleportDestination destination;
            int target;
            GlobalCoordinate gc;
            if (tagCompound.func_74764_b("target" + tgt) && (gc = destinations.getCoordinateForId(target = tagCompound.func_74762_e("target" + tgt))) != null && (destination = destinations.getDestination(gc)) != null) {
                if (donext == 1) {
                    String name = destination.getName() + " (dimension " + destination.getDimension() + ")";
                    tagCompound.func_74768_a("target", target);
                    TextComponentString component = new TextComponentString(TextFormatting.GREEN + "Target: " + TextFormatting.WHITE + name);
                    if (playerEntity instanceof EntityPlayer) {
                        playerEntity.func_146105_b((ITextComponent)component, false);
                    } else {
                        playerEntity.func_145747_a((ITextComponent)component);
                    }
                    donext = 2;
                } else if (target == curtarget) {
                    donext = 1;
                }
            }
            return donext;
        }
    }
}

