/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.items.teleportprobe.TeleportProbeItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketForceTeleport
implements IMessage {
    private BlockPos pos;
    private int dim;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.dim = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeInt(this.dim);
    }

    public PacketForceTeleport() {
    }

    public PacketForceTeleport(BlockPos pos, int dim) {
        this.pos = pos;
        this.dim = dim;
    }

    public static class Handler
    implements IMessageHandler<PacketForceTeleport, IMessage> {
        public IMessage onMessage(PacketForceTeleport message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketForceTeleport message, MessageContext ctx) {
            boolean probeInOffHand;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            boolean probeInMainHand = !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof TeleportProbeItem;
            boolean bl = probeInOffHand = !player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof TeleportProbeItem;
            if (!probeInMainHand && !probeInOffHand) {
                return;
            }
            int x = message.pos.func_177958_n();
            int y = message.pos.func_177956_o();
            int z = message.pos.func_177952_p();
            int currentId = player.func_130014_f_().field_73011_w.getDimension();
            if (currentId != message.dim) {
                TeleportationTools.teleportToDimension((EntityPlayer)player, message.dim, (double)x + 0.5, y + 1, (double)z + 0.5);
            } else {
                player.func_70634_a((double)x + 0.5, (double)y + 1.5, (double)z + 0.5);
            }
        }
    }
}

