/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import java.util.ArrayList;
import java.util.List;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.shapes.IFormula;
import mcjty.rftools.shapes.IFormulaFactory;
import mcjty.rftools.shapes.Scan;
import mcjty.rftools.shapes.ScanDataManager;
import mcjty.rftools.shapes.ScanDataManagerClient;
import mcjty.rftools.shapes.ShapeBlockInfo;
import mcjty.rftools.shapes.ShapeModifier;
import mcjty.rftools.shapes.ShapeOperation;
import mcjty.rftools.shapes.ShapeRotation;
import mcjty.rftools.varia.Check32;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Formulas {
    static final IFormulaFactory FORMULA_SCAN = () -> new IFormula(){
        private byte[] data;
        private int x1;
        private int y1;
        private int z1;
        private int dx;
        private int dy;
        private int dz;
        private IBlockState lastState = null;
        private List palette = new ArrayList();

        @Override
        public void getCheckSumClient(NBTTagCompound tc, Check32 crc) {
            ShapeCardItem.getLocalChecksum(tc, crc);
            int scanId = tc.func_74762_e("scanid");
            crc.add(scanId);
            crc.add(ScanDataManagerClient.getScansClient().getScanDirtyCounterClient(scanId));
        }

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            this.data = null;
            if (card == null) {
                return;
            }
            this.dx = dimension.func_177958_n();
            this.dy = dimension.func_177956_o();
            this.dz = dimension.func_177952_p();
            if (this.dx <= 0 || this.dy <= 0 || this.dz <= 0) {
                return;
            }
            int xCoord = thisCoord.func_177958_n();
            int yCoord = thisCoord.func_177956_o();
            int zCoord = thisCoord.func_177952_p();
            BlockPos tl = new BlockPos(xCoord - this.dx / 2 + offset.func_177958_n(), yCoord - this.dy / 2 + offset.func_177956_o(), zCoord - this.dz / 2 + offset.func_177952_p());
            this.x1 = tl.func_177958_n();
            this.y1 = tl.func_177956_o();
            this.z1 = tl.func_177952_p();
            this.palette.clear();
            int scanId = card.func_74762_e("scanid");
            if (scanId != 0) {
                Scan scan = ScanDataManager.getScans().loadScan(scanId);
                this.palette = new ArrayList<IBlockState>(scan.getMaterialPalette());
                byte[] datas = scan.getRledata();
                this.data = new byte[this.dx * this.dy * this.dz];
                int j = 0;
                for (int i = 0; i < datas.length / 2; ++i) {
                    int cnt = datas[i * 2] & 0xFF;
                    int c = datas[i * 2 + 1] & 0xFF;
                    if (c == 255) {
                        c = 0;
                    }
                    while (cnt > 0 && j < this.data.length) {
                        this.data[j++] = (byte)c;
                        --cnt;
                    }
                    if (j >= this.data.length) break;
                }
            }
        }

        @Override
        public boolean isBorder(int x, int y, int z) {
            if (x <= this.x1 || x >= this.x1 + this.dx - 1 || y <= this.y1 || y >= this.y1 + this.dy - 1 || z <= this.z1 || z >= this.z1 + this.dz - 1) {
                return this.isInsideSafe(x, y, z);
            }
            if (this.data == null) {
                return false;
            }
            int index = (x - this.x1) * this.dy * this.dz + (z - this.z1) * this.dy + (y - this.y1);
            if (!(this.isInsideInternal(index - 1) && this.isInsideInternal(index + 1) && this.isInsideInternal(index - this.dy) && this.isInsideInternal(index + this.dy) && this.isInsideInternal(index - this.dy * this.dz) && this.isInsideInternal(index + this.dy * this.dz))) {
                return this.isInsideInternal(index);
            }
            return false;
        }

        @Override
        public boolean isVisible(int x, int y, int z) {
            int index = (x - this.x1) * this.dy * this.dz + (z - this.z1) * this.dy + (y - this.y1);
            return this.isClear(index - 1) || this.isClear(index + 1) || this.isClear(index - this.dy) || this.isClear(index + this.dy) || this.isClear(index - this.dy * this.dz) || this.isClear(index + this.dy * this.dz);
        }

        public boolean isClear(int index) {
            if (!this.isInsideInternal(index)) {
                return true;
            }
            IBlockState state = this.getLastState();
            if (state != null) {
                return ShapeBlockInfo.isNonSolidBlock(state.func_177230_c());
            }
            return false;
        }

        private boolean isInsideInternal(int index) {
            if (this.data[index] == 0) {
                return false;
            }
            int idx = (this.data[index] & 0xFF) - 1;
            this.lastState = (IBlockState)this.palette.get(idx);
            return true;
        }

        @Override
        public boolean isInsideSafe(int x, int y, int z) {
            if (x < this.x1 || x >= this.x1 + this.dx || y < this.y1 || y >= this.y1 + this.dy || z < this.z1 || z >= this.z1 + this.dz) {
                return false;
            }
            return this.isInside(x, y, z);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            if (this.data == null) {
                return false;
            }
            int index = (x - this.x1) * this.dy * this.dz + (z - this.z1) * this.dy + (y - this.y1);
            return this.isInsideInternal(index);
        }

        @Override
        public IBlockState getLastState() {
            return this.lastState;
        }
    };
    static final IFormulaFactory FORMULA_COMPOSITION = new IFormulaFactory(){

        @Override
        public IFormula createFormula() {
            return new IFormula(){
                private BlockPos thisCoord;
                private IBlockState blockState;
                private List<IFormula> formulas = new ArrayList<IFormula>();
                private List<Bounds> bounds = new ArrayList<Bounds>();
                private List<ShapeModifier> modifiers = new ArrayList<ShapeModifier>();
                private List<IBlockState> blockStates = new ArrayList<IBlockState>();

                @Override
                public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
                    this.thisCoord = thisCoord;
                    if (card == null) {
                        return;
                    }
                    int dx = dimension.func_177958_n();
                    int dy = dimension.func_177956_o();
                    int dz = dimension.func_177952_p();
                    if (dx <= 0 || dy <= 0 || dz <= 0) {
                        return;
                    }
                    NBTTagList children = card.func_150295_c("children", 10);
                    for (int i = 0; i < children.func_74745_c(); ++i) {
                        Block block;
                        NBTTagCompound childTag = children.func_150305_b(i);
                        IFormula formula = ShapeCardItem.createCorrectFormula(childTag);
                        String op = childTag.func_74779_i("mod_op");
                        ShapeOperation operation = ShapeOperation.getByName(op);
                        boolean flip = childTag.func_74767_n("mod_flipy");
                        String rot = childTag.func_74779_i("mod_rot");
                        ShapeRotation rotation = ShapeRotation.getByName(rot);
                        this.modifiers.add(new ShapeModifier(operation, flip, rotation));
                        BlockPos dim = ShapeCardItem.getClampedDimension(childTag, ScannerConfiguration.maxScannerDimension);
                        BlockPos off = ShapeCardItem.getClampedOffset(childTag, ScannerConfiguration.maxScannerOffset);
                        BlockPos o = off.func_177971_a((Vec3i)offset);
                        formula.setup(thisCoord, dim, o, childTag);
                        this.formulas.add(formula);
                        dim = rotation.transformDimension(dim);
                        BlockPos tl = new BlockPos(o.func_177958_n() - dim.func_177958_n() / 2, o.func_177956_o() - dim.func_177956_o() / 2, o.func_177952_p() - dim.func_177952_p() / 2);
                        this.bounds.add(new Bounds(tl, tl.func_177971_a((Vec3i)dim), o));
                        IBlockState state = null;
                        if (childTag.func_74764_b("ghost_block") && (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(childTag.func_74779_i("ghost_block")))) != null) {
                            int meta = childTag.func_74762_e("ghost_meta");
                            state = block.func_176203_a(meta);
                        }
                        this.blockStates.add(state);
                    }
                }

                @Override
                public void getCheckSumClient(NBTTagCompound tc, Check32 crc) {
                    ShapeCardItem.getLocalChecksum(tc, crc);
                    NBTTagList children = tc.func_150295_c("children", 10);
                    for (int i = 0; i < children.func_74745_c(); ++i) {
                        NBTTagCompound childTag = children.func_150305_b(i);
                        IFormula formula = ShapeCardItem.createCorrectFormula(childTag);
                        formula.getCheckSumClient(childTag, crc);
                        crc.add(childTag.func_74767_n("mod_flipy") ? 1 : 0);
                        String rot = childTag.func_74779_i("mod_rot");
                        ShapeRotation rotation = ShapeRotation.getByName(rot);
                        crc.add(rotation.ordinal());
                        String op = childTag.func_74779_i("mod_op");
                        ShapeOperation operation = ShapeOperation.getByName(op);
                        crc.add(operation.ordinal());
                        if (!childTag.func_74764_b("ghost_block")) continue;
                        Object state = null;
                        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(childTag.func_74779_i("ghost_block")));
                        if (block == null) continue;
                        crc.add(Block.func_149682_b((Block)block));
                        int meta = childTag.func_74762_e("ghost_meta");
                        crc.add(meta);
                    }
                }

                @Override
                public IBlockState getLastState() {
                    return this.blockState;
                }

                @Override
                public boolean isInside(int x, int y, int z) {
                    this.blockState = null;
                    x -= this.thisCoord.func_177958_n();
                    y -= this.thisCoord.func_177956_o();
                    z -= this.thisCoord.func_177952_p();
                    boolean ok = false;
                    block10: for (int i = 0; i < this.formulas.size(); ++i) {
                        IFormula formula = this.formulas.get(i);
                        Bounds bounds = this.bounds.get(i);
                        ShapeModifier modifier = this.modifiers.get(i);
                        boolean inside = false;
                        if (bounds.in(x, y, z)) {
                            int tx = x;
                            int ty = y;
                            int tz = z;
                            BlockPos o = bounds.getOffset();
                            switch (modifier.getRotation()) {
                                default: {
                                    break;
                                }
                                case X: {
                                    tx = x;
                                    ty = z - o.func_177952_p() + o.func_177956_o();
                                    tz = y - o.func_177956_o() + o.func_177952_p();
                                    break;
                                }
                                case Y: {
                                    tx = z - o.func_177952_p() + o.func_177958_n();
                                    ty = y;
                                    tz = x - o.func_177958_n() + o.func_177952_p();
                                    break;
                                }
                                case Z: {
                                    tx = y - o.func_177956_o() + o.func_177958_n();
                                    ty = x - o.func_177958_n() + o.func_177956_o();
                                    tz = z;
                                }
                            }
                            if (modifier.isFlipY()) {
                                ty = o.func_177956_o() - (ty - o.func_177956_o());
                            }
                            inside = formula.isInside(tx + this.thisCoord.func_177958_n(), ty + this.thisCoord.func_177956_o(), tz + this.thisCoord.func_177952_p());
                        }
                        switch (modifier.getOperation()) {
                            case UNION: {
                                if (!inside) continue block10;
                                ok = true;
                                this.blockState = this.blockStates.get(i);
                                if (this.blockState != null) continue block10;
                                this.blockState = formula.getLastState();
                                continue block10;
                            }
                            case SUBTRACT: {
                                if (!inside) continue block10;
                                ok = false;
                                continue block10;
                            }
                            case INTERSECT: {
                                if (inside && ok) {
                                    if (this.blockState != null) continue block10;
                                    this.blockState = this.blockStates.get(i);
                                    if (this.blockState != null) continue block10;
                                    this.blockState = formula.getLastState();
                                    continue block10;
                                }
                                ok = false;
                            }
                        }
                    }
                    return ok;
                }

                @Override
                public boolean isCustom() {
                    return true;
                }
            };
        }
    };
    static final IFormulaFactory FORMULA_TORUS = () -> new IFormula(){
        private float smallRadius;
        private float bigRadius;
        private float centerx;
        private float centery;
        private float centerz;

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.func_177958_n();
            int dy = dimension.func_177956_o();
            int dz = dimension.func_177952_p();
            this.smallRadius = (float)(dy - 2) / 2.0f;
            this.bigRadius = (float)(dx - 2) / 2.0f - this.smallRadius;
            int xCoord = thisCoord.func_177958_n();
            int yCoord = thisCoord.func_177956_o();
            int zCoord = thisCoord.func_177952_p();
            this.centerx = (float)(xCoord + offset.func_177958_n()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centery = (float)(yCoord + offset.func_177956_o()) + (dy % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.func_177952_p()) + (dz % 2 != 0 ? 0.0f : -0.5f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            double rr = (double)this.bigRadius - Math.sqrt(((float)x - this.centerx) * ((float)x - this.centerx) + ((float)z - this.centerz) * ((float)z - this.centerz));
            double f = rr * rr + (double)(((float)y - this.centery) * ((float)y - this.centery)) - (double)(this.smallRadius * this.smallRadius);
            return f < 0.0;
        }
    };
    static final IFormulaFactory FORMULA_HEART = () -> new IFormula(){
        private float centerx;
        private float centery;
        private float centerz;
        private int dx;
        private int dy;
        private int dz;

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            this.dx = dimension.func_177958_n();
            this.dy = dimension.func_177956_o();
            this.dz = dimension.func_177952_p();
            int xCoord = thisCoord.func_177958_n();
            int yCoord = thisCoord.func_177956_o();
            int zCoord = thisCoord.func_177952_p();
            this.centerx = (float)(xCoord + offset.func_177958_n()) + (this.dx % 2 != 0 ? 0.0f : -0.5f);
            this.centery = (float)(yCoord + offset.func_177956_o()) + (this.dy % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.func_177952_p()) + (this.dz % 2 != 0 ? 0.0f : -0.5f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            double f3;
            double f2;
            double xx = (double)((float)x - this.centerx) * 2.6 / (double)this.dx + 0.1;
            double yy = (double)((float)z - this.centerz) * 1.6 / (double)this.dz + 0.1;
            double zz = (double)((float)y - this.centery) * 2.4 / (double)this.dy + 0.2;
            double f1 = Math.pow(xx * xx + 2.25 * yy * yy + zz * zz - 1.0, 3.0);
            double f = f1 - (f2 = xx * xx * zz * zz * zz) - (f3 = 0.1125 * yy * yy * zz * zz * zz);
            return f < 0.0;
        }
    };
    static final IFormulaFactory FORMULA_SPHERE = () -> new IFormula(){
        private float centerx;
        private float centery;
        private float centerz;
        private float dx2;
        private float dy2;
        private float dz2;
        private int davg;

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.func_177958_n();
            int dy = dimension.func_177956_o();
            int dz = dimension.func_177952_p();
            int xCoord = thisCoord.func_177958_n();
            int yCoord = thisCoord.func_177956_o();
            int zCoord = thisCoord.func_177952_p();
            this.centerx = (float)(xCoord + offset.func_177958_n()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centery = (float)(yCoord + offset.func_177956_o()) + (dy % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.func_177952_p()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.8f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dy2 = dy == 0 ? 0.5f : ((float)dy + factor) * ((float)dy + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dy + dz) + factor * 3.0f) / 3.0f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            double distance = Math.sqrt(Formulas.squaredDistance3D(this.centerx, this.centery, this.centerz, x, y, z, this.dx2, this.dy2, this.dz2));
            return (int)(distance * (double)(this.davg / 2 + 1)) <= this.davg / 2 - 1;
        }
    };
    static final IFormulaFactory FORMULA_TOPDOME = () -> new IFormula(){
        private float centerx;
        private float centery;
        private float centerz;
        private float dx2;
        private float dy2;
        private float dz2;
        private int davg;

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.func_177958_n();
            int dy = dimension.func_177956_o();
            int dz = dimension.func_177952_p();
            int xCoord = thisCoord.func_177958_n();
            int yCoord = thisCoord.func_177956_o();
            int zCoord = thisCoord.func_177952_p();
            this.centerx = (float)(xCoord + offset.func_177958_n()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centery = (float)(yCoord + offset.func_177956_o()) + (dy % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.func_177952_p()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.8f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dy2 = dy == 0 ? 0.5f : ((float)dy + factor) * ((float)dy + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dy + dz) + factor * 3.0f) / 3.0f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            if ((float)y < this.centery) {
                return false;
            }
            double distance = Math.sqrt(Formulas.squaredDistance3D(this.centerx, this.centery, this.centerz, x, y, z, this.dx2, this.dy2, this.dz2));
            return (int)(distance * (double)(this.davg / 2 + 1)) <= this.davg / 2 - 1;
        }
    };
    static final IFormulaFactory FORMULA_BOTTOMDOME = () -> new IFormula(){
        private float centerx;
        private float centery;
        private float centerz;
        private float dx2;
        private float dy2;
        private float dz2;
        private int davg;

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.func_177958_n();
            int dy = dimension.func_177956_o();
            int dz = dimension.func_177952_p();
            int xCoord = thisCoord.func_177958_n();
            int yCoord = thisCoord.func_177956_o();
            int zCoord = thisCoord.func_177952_p();
            this.centerx = (float)(xCoord + offset.func_177958_n()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centery = (float)(yCoord + offset.func_177956_o()) + (dy % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.func_177952_p()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.8f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dy2 = dy == 0 ? 0.5f : ((float)dy + factor) * ((float)dy + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dy + dz) + factor * 3.0f) / 3.0f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            if ((float)y > this.centery) {
                return false;
            }
            double distance = Math.sqrt(Formulas.squaredDistance3D(this.centerx, this.centery, this.centerz, x, y, z, this.dx2, this.dy2, this.dz2));
            return (int)(distance * (double)(this.davg / 2 + 1)) <= this.davg / 2 - 1;
        }
    };
    static final IFormulaFactory FORMULA_BOX = () -> new IFormula(){
        private int x1;
        private int y1;
        private int z1;
        private int x2;
        private int y2;
        private int z2;

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.func_177958_n();
            int dy = dimension.func_177956_o();
            int dz = dimension.func_177952_p();
            int xCoord = thisCoord.func_177958_n();
            int yCoord = thisCoord.func_177956_o();
            int zCoord = thisCoord.func_177952_p();
            BlockPos tl = new BlockPos(xCoord - dx / 2 + offset.func_177958_n(), yCoord - dy / 2 + offset.func_177956_o(), zCoord - dz / 2 + offset.func_177952_p());
            this.x1 = tl.func_177958_n();
            this.y1 = tl.func_177956_o();
            this.z1 = tl.func_177952_p();
            this.x2 = this.x1 + dx;
            this.y2 = this.y1 + dy;
            this.z2 = this.z1 + dz;
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            return x >= this.x1 && x < this.x2 && y >= this.y1 && y < this.y2 && z >= this.z1 && z < this.z2;
        }

        @Override
        public boolean isBorder(int x, int y, int z) {
            return x == this.x1 || x == this.x2 - 1 || y == this.y1 || y == this.y2 - 1 || z == this.z1 || z == this.z2 - 1;
        }
    };
    static final IFormulaFactory FORMULA_CAPPED_CYLINDER = () -> new IFormula(){
        private float centerx;
        private float centerz;
        private float dx2;
        private float dz2;
        private int davg;
        private int y1;
        private int y2;

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.func_177958_n();
            int dy = dimension.func_177956_o();
            int dz = dimension.func_177952_p();
            int xCoord = thisCoord.func_177958_n();
            int yCoord = thisCoord.func_177956_o();
            int zCoord = thisCoord.func_177952_p();
            this.centerx = (float)(xCoord + offset.func_177958_n()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.func_177952_p()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.7f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dz) + factor * 2.0f) / 2.0f);
            this.y1 = yCoord - dy / 2 + offset.func_177956_o();
            this.y2 = this.y1 + dy;
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            if (y < this.y1 || y >= this.y2) {
                return false;
            }
            double distance = Math.sqrt(Formulas.squaredDistance2D(this.centerx, this.centerz, x, z, this.dx2, this.dz2));
            return (int)(distance * (double)(this.davg / 2 + 1)) <= this.davg / 2 - 1;
        }
    };
    static final IFormulaFactory FORMULA_CYLINDER = () -> new IFormula(){
        private float centerx;
        private float centerz;
        private float dx2;
        private float dz2;
        private int davg;

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.func_177958_n();
            int dy = dimension.func_177956_o();
            int dz = dimension.func_177952_p();
            int xCoord = thisCoord.func_177958_n();
            int yCoord = thisCoord.func_177956_o();
            int zCoord = thisCoord.func_177952_p();
            this.centerx = (float)(xCoord + offset.func_177958_n()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.func_177952_p()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.7f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dz) + factor * 2.0f) / 2.0f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            double distance = Math.sqrt(Formulas.squaredDistance2D(this.centerx, this.centerz, x, z, this.dx2, this.dz2));
            return (int)(distance * (double)(this.davg / 2 + 1)) <= this.davg / 2 - 1;
        }
    };
    static final IFormulaFactory FORMULA_CONE = () -> new IFormula(){
        private float centerx;
        private float centerz;
        private float dx2;
        private float dz2;
        private float dy;
        private float topy;
        private int davg;

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.func_177958_n();
            int dy = dimension.func_177956_o();
            int dz = dimension.func_177952_p();
            int xCoord = thisCoord.func_177958_n();
            int yCoord = thisCoord.func_177956_o();
            int zCoord = thisCoord.func_177952_p();
            this.centerx = (float)(xCoord + offset.func_177958_n()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.func_177952_p()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.7f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dz) + factor * 2.0f) / 2.0f);
            this.dy = (float)dy + 0.5f;
            this.topy = yCoord + offset.func_177956_o() + dy / 2;
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            double distance = Math.sqrt(Formulas.squaredDistance2D(this.centerx, this.centerz, x, z, this.dx2, this.dz2));
            return (float)((int)(distance * (double)(this.davg / 2 + 1))) <= (float)(this.davg / 2 - 1) * (this.topy - (float)y) / this.dy;
        }
    };
    static final IFormulaFactory FORMULA_PRISM = () -> new IFormula(){
        private int x1;
        private int y1;
        private int z1;
        private int x2;
        private int y2;
        private int z2;

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.func_177958_n();
            int dy = dimension.func_177956_o();
            int dz = dimension.func_177952_p();
            int xCoord = thisCoord.func_177958_n();
            int yCoord = thisCoord.func_177956_o();
            int zCoord = thisCoord.func_177952_p();
            BlockPos tl = new BlockPos(xCoord - dx / 2 + offset.func_177958_n(), yCoord - dy / 2 + offset.func_177956_o(), zCoord - dz / 2 + offset.func_177952_p());
            this.x1 = tl.func_177958_n();
            this.y1 = tl.func_177956_o();
            this.z1 = tl.func_177952_p();
            this.x2 = this.x1 + dx;
            this.y2 = this.y1 + dy;
            this.z2 = this.z1 + dz;
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            if (y < this.y1 || y >= this.y2) {
                return false;
            }
            int dy = y - this.y1;
            return x >= this.x1 + dy && x < this.x2 - dy && z >= this.z1 + dy && z < this.z2 - dy;
        }
    };

    private static float squaredDistance3D(float cx, float cy, float cz, float x1, float y1, float z1, float dx2, float dy2, float dz2) {
        return (x1 - cx) * (x1 - cx) / dx2 + (y1 - cy) * (y1 - cy) / dy2 + (z1 - cz) * (z1 - cz) / dz2;
    }

    private static float squaredDistance2D(float cx, float cz, float x1, float z1, float dx2, float dz2) {
        return (x1 - cx) * (x1 - cx) / dx2 + (z1 - cz) * (z1 - cz) / dz2;
    }

    public static class Bounds {
        private BlockPos p1;
        private BlockPos p2;
        private BlockPos offset;

        public Bounds(BlockPos p1, BlockPos p2, BlockPos offset) {
            this.p1 = p1;
            this.p2 = p2;
            this.offset = offset;
        }

        public BlockPos getP1() {
            return this.p1;
        }

        public BlockPos getP2() {
            return this.p2;
        }

        public BlockPos getOffset() {
            return this.offset;
        }

        public boolean in(BlockPos p) {
            int x = p.func_177958_n();
            int y = p.func_177956_o();
            int z = p.func_177952_p();
            return this.in(x, y, z);
        }

        public boolean in(int x, int y, int z) {
            return x >= this.p1.func_177958_n() && x < this.p2.func_177958_n() && y >= this.p1.func_177956_o() && y < this.p2.func_177956_o() && z >= this.p1.func_177952_p() && z < this.p2.func_177952_p();
        }
    }
}

