/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mcjty.rftools.RFTools;
import mcjty.rftools.shapes.BeaconType;
import mcjty.rftools.shapes.ScanDataManagerClient;
import mcjty.rftools.shapes.ScanExtraData;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketReturnExtraData
implements IMessage {
    private int scanId;
    private ScanExtraData data;

    public void fromBytes(ByteBuf buf) {
        this.scanId = buf.readInt();
        int size = buf.readInt();
        if (size == -1) {
            this.data = null;
        } else {
            this.data = new ScanExtraData();
            for (int i = 0; i < size; ++i) {
                long p = buf.readLong();
                BeaconType type = BeaconType.VALUES[buf.readByte()];
                boolean doBeacon = buf.readBoolean();
                this.data.addBeacon(BlockPos.func_177969_a((long)p), type, doBeacon);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.scanId);
        if (this.data == null) {
            buf.writeInt(-1);
        } else {
            List<ScanExtraData.Beacon> beacons = this.data.getBeacons();
            buf.writeInt(beacons.size());
            for (ScanExtraData.Beacon beacon : beacons) {
                buf.writeLong(beacon.getPos().func_177986_g());
                buf.writeByte(beacon.getType().ordinal());
                buf.writeBoolean(beacon.isDoBeacon());
            }
        }
    }

    public PacketReturnExtraData() {
    }

    public PacketReturnExtraData(int scanId, ScanExtraData extraData) {
        this.scanId = scanId;
        this.data = extraData;
    }

    public static class Handler
    implements IMessageHandler<PacketReturnExtraData, IMessage> {
        public IMessage onMessage(PacketReturnExtraData message, MessageContext ctx) {
            RFTools.proxy.addScheduledTaskClient(() -> this.handle(message));
            return null;
        }

        private void handle(PacketReturnExtraData message) {
            ScanDataManagerClient.getScansClient().registerExtraDataFromServer(message.scanId, message.data);
        }
    }
}

