/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import io.netty.buffer.ByteBuf;
import mcjty.rftools.RFTools;
import mcjty.rftools.shapes.ScanDataManagerClient;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketReturnScanDirty
implements IMessage {
    private int scanId;
    private int dirtyCounter;

    public void fromBytes(ByteBuf buf) {
        this.scanId = buf.readInt();
        this.dirtyCounter = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.scanId);
        buf.writeInt(this.dirtyCounter);
    }

    public PacketReturnScanDirty() {
    }

    public PacketReturnScanDirty(int scanId, int dirtyCounter) {
        this.scanId = scanId;
        this.dirtyCounter = dirtyCounter;
    }

    public static class Handler
    implements IMessageHandler<PacketReturnScanDirty, IMessage> {
        public IMessage onMessage(PacketReturnScanDirty message, MessageContext ctx) {
            RFTools.proxy.addScheduledTaskClient(() -> this.handle(message));
            return null;
        }

        private void handle(PacketReturnScanDirty message) {
            ScanDataManagerClient.getScansClient().getOrCreateScan(message.scanId).setDirtyCounter(message.dirtyCounter);
        }
    }
}

