/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.enchantment;

import com.oitsjustjose.vtweaks.enchantment.EnchantmentAutosmelt;
import com.oitsjustjose.vtweaks.enchantment.EnchantmentHypermending;
import com.oitsjustjose.vtweaks.enchantment.EnchantmentImperishable;
import com.oitsjustjose.vtweaks.enchantment.EnchantmentLumbering;
import com.oitsjustjose.vtweaks.enchantment.EnchantmentMultifaceted;
import com.oitsjustjose.vtweaks.enchantment.EnchantmentStepboost;
import com.oitsjustjose.vtweaks.enchantment.FeatherFallingTweak;
import com.oitsjustjose.vtweaks.enchantment.handler.EnchantmentAutosmeltHandler;
import com.oitsjustjose.vtweaks.enchantment.handler.EnchantmentHypermendingHandler;
import com.oitsjustjose.vtweaks.enchantment.handler.EnchantmentImperishableHandler;
import com.oitsjustjose.vtweaks.enchantment.handler.EnchantmentLumberingHandler;
import com.oitsjustjose.vtweaks.enchantment.handler.EnchantmentMultifacetedHandler;
import com.oitsjustjose.vtweaks.enchantment.handler.EnchantmentStepboostHandler;
import com.oitsjustjose.vtweaks.util.Config;
import com.oitsjustjose.vtweaks.util.MultifacetedCrafting;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Enchantments {
    private static Enchantments instance;
    public Enchantment hypermending;
    public Enchantment autosmelt;
    public Enchantment stepboost;
    public Enchantment lumbering;
    public Enchantment imperishable;
    public Enchantment multifaceted;
    private ArrayList<Enchantment> toRegister = new ArrayList();

    public Enchantments() {
        this.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        instance = this;
    }

    public static Enchantments getInstance() {
        return instance;
    }

    private void init() {
        if (Config.getInstance().enableEnchHypermending) {
            this.hypermending = new EnchantmentHypermending();
            this.registerEnchantment(this.hypermending);
            MinecraftForge.EVENT_BUS.register((Object)new EnchantmentHypermendingHandler());
        }
        if (Config.getInstance().enableEnchAutosmelt) {
            this.autosmelt = new EnchantmentAutosmelt();
            this.registerEnchantment(this.autosmelt);
            MinecraftForge.EVENT_BUS.register((Object)new EnchantmentAutosmeltHandler());
        }
        if (Config.getInstance().enableEnchStepboost) {
            this.stepboost = new EnchantmentStepboost();
            this.registerEnchantment(this.stepboost);
            MinecraftForge.EVENT_BUS.register((Object)new EnchantmentStepboostHandler());
        }
        if (Config.getInstance().enableEnchLumbering) {
            this.lumbering = new EnchantmentLumbering();
            this.registerEnchantment(this.lumbering);
            MinecraftForge.EVENT_BUS.register((Object)new EnchantmentLumberingHandler());
        }
        if (Config.getInstance().enableEnchImperishable) {
            this.imperishable = new EnchantmentImperishable();
            this.registerEnchantment(this.imperishable);
            MinecraftForge.EVENT_BUS.register((Object)new EnchantmentImperishableHandler());
        }
        if (Config.getInstance().enableEnchMultifaceted) {
            this.multifaceted = new EnchantmentMultifaceted();
            this.registerEnchantment(this.multifaceted);
            MinecraftForge.EVENT_BUS.register((Object)new EnchantmentMultifacetedHandler());
            MinecraftForge.EVENT_BUS.register((Object)new MultifacetedCrafting());
        }
        if (Config.getInstance().enableFeatherFallingTweak) {
            MinecraftForge.EVENT_BUS.register((Object)new FeatherFallingTweak());
        }
    }

    public void registerEnchantment(Enchantment ench) {
        this.toRegister.add(ench);
    }

    @SubscribeEvent
    public void handleRegistry(RegistryEvent.Register<Enchantment> event) {
        for (Enchantment e : this.toRegister) {
            event.getRegistry().register((IForgeRegistryEntry)e);
        }
    }
}

