/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.enchantment.handler;

import com.oitsjustjose.vtweaks.enchantment.Enchantments;
import com.oitsjustjose.vtweaks.util.Config;
import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentAutosmeltHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void register(BlockEvent.HarvestDropsEvent event) {
        if (!Config.getInstance().enableEnchAutosmelt) {
            return;
        }
        if (event.getHarvester() == null || event.getHarvester().func_184614_ca() == null) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        World world = event.getWorld();
        ItemStack heldItem = player.func_184614_ca();
        int autosmeltLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.getInstance().autosmelt, (ItemStack)heldItem);
        if (autosmeltLevel > 0) {
            ListIterator<ItemStack> iter = event.getDrops().listIterator();
            while (iter.hasNext()) {
                ItemStack temp = ((ItemStack)iter.next()).func_77946_l();
                ItemStack newDrop = FurnaceRecipes.func_77602_a().func_151395_a(temp.func_77946_l());
                if (newDrop.func_190926_b()) continue;
                newDrop = newDrop.func_77946_l();
                newDrop.func_190920_e(temp.func_190916_E());
                if (event.getFortuneLevel() > 0 && this.shouldFortuneSmelt(temp)) {
                    newDrop.func_190920_e(newDrop.func_190916_E() * world.field_73012_v.nextInt(event.getFortuneLevel() + 1) + 1);
                }
                iter.set(newDrop);
                this.spawnXP(event.getWorld(), event.getPos(), newDrop.func_77946_l());
            }
        }
    }

    void spawnXP(World world, BlockPos pos, ItemStack itemstack) {
        int xpSplit;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int stackSize = itemstack.func_190916_E();
        float smeltingXP = FurnaceRecipes.func_77602_a().func_151398_b(itemstack);
        if (smeltingXP == 0.0f) {
            stackSize = 0;
        } else if (smeltingXP < 1.0f) {
            xpSplit = MathHelper.func_76141_d((float)((float)stackSize * smeltingXP));
            if (xpSplit < MathHelper.func_76123_f((float)((float)stackSize * smeltingXP)) && (float)Math.random() < (float)stackSize * smeltingXP - (float)xpSplit) {
                ++xpSplit;
            }
            stackSize = xpSplit;
        }
        while (stackSize > 0) {
            xpSplit = EntityXPOrb.func_70527_a((int)stackSize);
            stackSize -= xpSplit;
            world.func_72838_d((Entity)new EntityXPOrb(world, (double)x, (double)y + 0.5, (double)z, xpSplit));
        }
    }

    boolean shouldFortuneSmelt(ItemStack stack) {
        if (!Config.getInstance().enableAutosmeltFortuneInteraction) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block.getRegistryName().toString().toLowerCase().contains("ore")) {
                return true;
            }
            for (String s : Config.getInstance().autosmeltOverrides) {
                if (!block.getRegistryName().toString().toLowerCase().contains(s)) continue;
                return true;
            }
        }
        return false;
    }
}

