/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.event;

import com.oitsjustjose.vtweaks.util.Config;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ToolTips {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerTweak(ItemTooltipEvent event) {
        boolean shift;
        if (event.getItemStack().func_190926_b()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        boolean bl = shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        if (stack.func_77973_b() instanceof ItemFood) {
            if (Config.getInstance().foodTooltipSetting == 0) {
                return;
            }
            ItemFood food = (ItemFood)stack.func_77973_b();
            int hunger = food.func_150905_g(stack);
            float saturation = food.func_150906_h(stack) * 10.0f;
            if (Config.getInstance().foodTooltipSetting == 1) {
                event.getToolTip().add(this.getHungerString(hunger));
                event.getToolTip().add(this.getSaturationString(saturation));
            } else if (Config.getInstance().foodTooltipSetting == 2 && shift) {
                event.getToolTip().add(this.getHungerString(hunger));
                event.getToolTip().add(this.getSaturationString(saturation));
            }
        }
        if (stack.func_77973_b().func_77645_m()) {
            if (Config.getInstance().durabilityTooltipSetting == 0) {
                return;
            }
            if (Config.getInstance().durabilityTooltipSetting == 1) {
                event.getToolTip().add(this.getDurabilityString(stack));
            } else if (Config.getInstance().durabilityTooltipSetting == 2 && shift) {
                event.getToolTip().add(this.getDurabilityString(stack));
            }
        }
    }

    private String getHungerString(int hunger) {
        String ret = TextFormatting.GRAY + "Hunger:";
        for (int i = 0; i < hunger / 2; ++i) {
            ret = ret + TextFormatting.DARK_RED + "\u25a0";
        }
        if (hunger % 2 != 0) {
            ret = ret + TextFormatting.RED + "\u25a0";
        }
        return ret;
    }

    private String getSaturationString(float saturation) {
        String ret = TextFormatting.GRAY + "Saturation:";
        if (saturation <= 1.0f) {
            ret = ret + TextFormatting.DARK_RED + "\u25a0";
            return ret;
        }
        if (saturation <= 2.0f) {
            ret = ret + TextFormatting.RED + "\u25a0";
            return ret;
        }
        if (saturation <= 3.0f) {
            ret = ret + TextFormatting.GOLD + "\u25a0";
            return ret;
        }
        if (saturation <= 4.0f) {
            ret = ret + TextFormatting.YELLOW + "\u25a0";
            return ret;
        }
        if (saturation <= 5.0f) {
            ret = ret + TextFormatting.GREEN + "\u25a0";
            return ret;
        }
        if (saturation <= 6.0f) {
            ret = ret + TextFormatting.DARK_GREEN + "\u25a0";
            return ret;
        }
        if (saturation <= 7.0f) {
            ret = ret + TextFormatting.DARK_AQUA + "\u25a0";
            return ret;
        }
        if (saturation <= 8.0f) {
            ret = ret + TextFormatting.BLUE + "\u25a0";
            return ret;
        }
        if (saturation <= 9.0f) {
            ret = ret + TextFormatting.DARK_PURPLE + "\u25a0";
            return ret;
        }
        ret = ret + TextFormatting.LIGHT_PURPLE + "\u25a0";
        return ret;
    }

    private String getDurabilityString(ItemStack itemstack) {
        String ret = "Durability: ";
        int max = itemstack.func_77958_k() + 1;
        int damage = itemstack.func_77952_i();
        float percentage = 1.0f - (float)damage / (float)max;
        if ((double)percentage >= 0.9) {
            ret = ret + TextFormatting.LIGHT_PURPLE + (max - damage) + " / " + max + TextFormatting.RESET;
            return ret;
        }
        if ((double)percentage >= 0.8) {
            ret = ret + TextFormatting.DARK_PURPLE + (max - damage) + " / " + max + TextFormatting.RESET;
            return ret;
        }
        if ((double)percentage >= 0.7) {
            ret = ret + TextFormatting.BLUE + (max - damage) + " / " + max + TextFormatting.RESET;
            return ret;
        }
        if ((double)percentage >= 0.6) {
            ret = ret + TextFormatting.DARK_AQUA + (max - damage) + " / " + max + TextFormatting.RESET;
            return ret;
        }
        if ((double)percentage >= 0.5) {
            ret = ret + TextFormatting.DARK_GREEN + (max - damage) + " / " + max + TextFormatting.RESET;
            return ret;
        }
        if ((double)percentage >= 0.4) {
            ret = ret + TextFormatting.GREEN + (max - damage) + " / " + max + TextFormatting.RESET;
            return ret;
        }
        if ((double)percentage >= 0.3) {
            ret = ret + TextFormatting.YELLOW + (max - damage) + " / " + max + TextFormatting.RESET;
            return ret;
        }
        if ((double)percentage >= 0.2) {
            ret = ret + TextFormatting.GOLD + (max - damage) + " / " + max + TextFormatting.RESET;
            return ret;
        }
        if ((double)percentage >= 0.1) {
            ret = ret + TextFormatting.RED + (max - damage) + " / " + max + TextFormatting.RESET;
            return ret;
        }
        if ((double)percentage < 0.1) {
            ret = ret + TextFormatting.DARK_RED + (max - damage) + " / " + max + TextFormatting.RESET;
            return ret;
        }
        ret = ret + (max - damage) + " / " + max;
        return ret;
    }
}

