/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.event.blocktweaks;

import com.oitsjustjose.vtweaks.util.Config;
import com.oitsjustjose.vtweaks.util.HelperFunctions;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CropHelper {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerVanilla(PlayerInteractEvent.RightClickBlock event) {
        if (!Config.getInstance().enableCropHelper) {
            return;
        }
        if (event.getWorld().func_180495_p(event.getPos()) == null || event.getEntityPlayer() == null || event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        Block harvestable = state.func_177230_c();
        for (String blackList : Config.getInstance().cropHelperBlacklist) {
            if (!harvestable.getClass().getName().toLowerCase().contains(blackList.toLowerCase())) continue;
            return;
        }
        if (harvestable instanceof BlockCrops) {
            if (this.harvestGenericCrop(event.getWorld(), event.getPos(), state, event.getEntityPlayer())) {
                event.setCanceled(true);
            }
        } else if (harvestable instanceof BlockNetherWart) {
            if (this.harvestNetherWart(event.getWorld(), event.getPos(), state, event.getEntityPlayer())) {
                event.setCanceled(true);
            }
        } else if (harvestable instanceof BlockCocoa && this.harvestCocoaPod(event.getWorld(), event.getPos(), state, event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }

    public boolean harvestGenericCrop(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockCrops crop = (BlockCrops)state.func_177230_c();
        if (crop.func_185525_y(state)) {
            if (!world.field_72995_K) {
                NonNullList drops = NonNullList.func_191196_a();
                Item mainDrop = crop.func_180660_a(state, world.field_73012_v, 0);
                crop.getDrops(drops, (IBlockAccess)world, pos, state, 0);
                if (mainDrop != null) {
                    Iterator iter = drops.iterator();
                    while (iter.hasNext()) {
                        ItemStack next = (ItemStack)iter.next();
                        if (next.func_77973_b() == mainDrop && next.func_77973_b() != Items.field_151174_bG && next.func_77973_b() != Items.field_151172_bF) continue;
                        iter.remove();
                        break;
                    }
                }
                for (ItemStack i : drops) {
                    this.dropItem(world, player.func_180425_c(), i);
                }
                world.func_175656_a(pos, crop.func_185528_e(0));
            }
            player.func_184609_a(EnumHand.MAIN_HAND);
            return true;
        }
        return false;
    }

    public boolean harvestNetherWart(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockNetherWart wart = (BlockNetherWart)state.func_177230_c();
        NonNullList drops = NonNullList.func_191196_a();
        wart.getDrops(drops, (IBlockAccess)world, pos, state, 0);
        if (drops.size() > 1) {
            if (!world.field_72995_K) {
                drops.remove(0);
                for (ItemStack i : drops) {
                    this.dropItem(world, player.func_180425_c(), i);
                }
                world.func_175656_a(pos, wart.func_176223_P());
            }
            player.func_184609_a(EnumHand.MAIN_HAND);
            return true;
        }
        return false;
    }

    public boolean harvestCocoaPod(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockCocoa cocoa = (BlockCocoa)state.func_177230_c();
        NonNullList drops = NonNullList.func_191196_a();
        cocoa.getDrops(drops, (IBlockAccess)world, pos, state, 0);
        if (drops.size() > 1) {
            if (!world.field_72995_K) {
                drops.remove(0);
                for (ItemStack i : drops) {
                    this.dropItem(world, player.func_180425_c(), i);
                }
                world.func_175656_a(pos, state.func_177226_a((IProperty)BlockCocoa.field_176501_a, (Comparable)Integer.valueOf(0)));
            }
            player.func_184609_a(EnumHand.MAIN_HAND);
            return true;
        }
        return false;
    }

    public void dropItem(World world, BlockPos pos, ItemStack itemstack) {
        world.func_72838_d((Entity)HelperFunctions.createItemEntity(world, pos, itemstack));
    }
}

