/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.util;

import com.google.common.collect.ImmutableList;
import com.oitsjustjose.vtweaks.enchantment.Enchantments;
import com.oitsjustjose.vtweaks.util.Config;
import com.oitsjustjose.vtweaks.util.HelperFunctions;
import java.util.ArrayList;
import java.util.Collection;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IVanillaRecipeFactory;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JEICompat
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IVanillaRecipeFactory factory = jeiHelpers.getVanillaRecipeFactory();
        if (Config.getInstance().enableRecipeHorseArmor) {
            this.addMirroredAnvilRecipe(factory, registry, new ItemStack((Item)Items.field_151165_aa), new ItemStack(Items.field_151138_bX));
            this.addMirroredAnvilRecipe(factory, registry, new ItemStack((Item)Items.field_151149_ai), new ItemStack(Items.field_151136_bY));
            this.addMirroredAnvilRecipe(factory, registry, new ItemStack((Item)Items.field_151173_ae), new ItemStack(Items.field_151125_bZ));
        }
        if (Config.getInstance().enableEnchHypermending) {
            this.addAnvilRecipe(factory, registry, new ItemStack(Items.field_151099_bA), new ItemStack(Items.field_151156_bN), HelperFunctions.getEnchantedBook(Enchantments.getInstance().hypermending));
        }
        if (Config.getInstance().enableEnchAutosmelt) {
            this.addAnvilRecipe(factory, registry, new ItemStack(Items.field_151099_bA), new ItemStack(Items.field_151129_at), HelperFunctions.getEnchantedBook(Enchantments.getInstance().autosmelt));
        }
        if (Config.getInstance().enableEnchStepboost) {
            ArrayList<ItemStack> stairs = new ArrayList<ItemStack>();
            ArrayList<ItemStack> output = new ArrayList<ItemStack>();
            ItemStack stepboostBook = HelperFunctions.getEnchantedBook(Enchantments.getInstance().stepboost);
            for (int i = 0; i < Block.field_149771_c.func_148742_b().size(); ++i) {
                Block b = (Block)Block.field_149771_c.func_148754_a(i);
                if (b == null || !b.getRegistryName().toString().contains("stair")) continue;
                stairs.add(new ItemStack(b, 16));
                output.add(stepboostBook);
            }
            registry.addRecipes((Collection)ImmutableList.of((Object)factory.createAnvilRecipe(new ItemStack(Items.field_151099_bA), stairs, output)), "minecraft.anvil");
        }
        if (Config.getInstance().enableEnchLumbering) {
            this.addAnvilRecipe(factory, registry, new ItemStack(Items.field_151099_bA), new ItemStack(Items.field_151006_E), HelperFunctions.getEnchantedBook(Enchantments.getInstance().lumbering));
        }
        if (Config.getInstance().enableEnchMultifaceted) {
            registry.addIngredientInfo((Object)HelperFunctions.getEnchantedBook(Enchantments.getInstance().multifaceted), ItemStack.class, new String[]{"recipe.multifaceted.name"});
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    void addMirroredAnvilRecipe(IVanillaRecipeFactory factory, IModRegistry registry, ItemStack input, ItemStack output) {
        ArrayList<ItemStack> inputTemp = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputTemp = new ArrayList<ItemStack>();
        inputTemp.add(input);
        outputTemp.add(output);
        registry.addRecipes((Collection)ImmutableList.of((Object)factory.createAnvilRecipe(input, inputTemp, outputTemp)), "minecraft.anvil");
    }

    void addAnvilRecipe(IVanillaRecipeFactory factory, IModRegistry registry, ItemStack inputLeft, ItemStack inputRight, ItemStack output) {
        ArrayList<ItemStack> rightTemp = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputTemp = new ArrayList<ItemStack>();
        rightTemp.add(inputRight);
        outputTemp.add(output);
        registry.addRecipes((Collection)ImmutableList.of((Object)factory.createAnvilRecipe(inputLeft, rightTemp, outputTemp)), "minecraft.anvil");
    }
}

