/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.util;

import com.google.common.collect.Lists;
import com.oitsjustjose.vtweaks.enchantment.Enchantments;
import com.oitsjustjose.vtweaks.util.HelperFunctions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MultifacetedCrafting {
    @SubscribeEvent
    public void register(ExplosionEvent event) {
        if (event.getExplosion() == null || event.getWorld() == null) {
            return;
        }
        World world = event.getWorld();
        List locations = event.getExplosion().func_180343_e();
        List<EntityItem> items = this.getItems(world, locations);
        BlockPos centerPos = new BlockPos(event.getExplosion().getPosition());
        if (!this.allItemsUndamaged(items)) {
            return;
        }
        if (!this.allItemsPresent(items)) {
            return;
        }
        EntityItem enchantedBook = HelperFunctions.createItemEntity(world, centerPos, HelperFunctions.getEnchantedBook(Enchantments.getInstance().multifaceted));
        enchantedBook.func_184224_h(true);
        enchantedBook.func_174873_u();
        enchantedBook.func_184195_f(true);
        world.func_72838_d((Entity)enchantedBook);
        for (EntityItem i : items) {
            i.func_70106_y();
        }
    }

    List<EntityItem> getItems(World world, List<BlockPos> positions) {
        ArrayList retList = Lists.newArrayList();
        for (BlockPos pos : positions) {
            retList.addAll(world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1))));
        }
        return retList;
    }

    public boolean allItemsUndamaged(List<EntityItem> items) {
        for (EntityItem i : items) {
            if (i.func_92059_d().func_77952_i() <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean allItemsPresent(List<EntityItem> items) {
        boolean foundAxe = false;
        boolean foundShovel = false;
        boolean foundBook = false;
        for (EntityItem i : items) {
            if (i.func_92059_d().func_77973_b() == Items.field_151056_x) {
                foundAxe = true;
                continue;
            }
            if (i.func_92059_d().func_77973_b() == Items.field_151047_v) {
                foundShovel = true;
                continue;
            }
            if (i.func_92059_d().func_77973_b() == Items.field_151099_bA) {
                foundBook = true;
                continue;
            }
            return false;
        }
        return foundAxe && foundShovel && foundBook;
    }
}

