/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiCharger;
import cofh.thermalexpansion.gui.container.machine.ContainerCharger;
import cofh.thermalexpansion.util.managers.machine.ChargerManager;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileCharger
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.CHARGER.getMetadata();
    private static final int[] ENERGY_TRANSFER = new int[]{1000, 4000, 9000, 16000, 25000};
    public static int basePower = 50;
    private int inputTracker;
    private int outputTracker;
    private IEnergyContainerItem containerItem = null;
    private boolean hasContainerItem = false;
    private IEnergyStorage handler = null;
    private boolean hasEnergyHandler = false;
    protected boolean augmentThroughput;

    public static void initialize() {
        TileCharger.SIDE_CONFIGS[TileCharger.TYPE] = new TileTEBase.SideConfig();
        TileCharger.SIDE_CONFIGS[TileCharger.TYPE].numConfig = 5;
        TileCharger.SIDE_CONFIGS[TileCharger.TYPE].slotGroups = new int[][]{new int[0], {0}, {2}, {0, 2}, {0, 2}};
        TileCharger.SIDE_CONFIGS[TileCharger.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileCharger.SIDE_CONFIGS[TileCharger.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileCharger.SLOT_CONFIGS[TileCharger.TYPE] = new TileTEBase.SlotConfig();
        TileCharger.SLOT_CONFIGS[TileCharger.TYPE].allowInsertionSlot = new boolean[]{true, false, false, false};
        TileCharger.SLOT_CONFIGS[TileCharger.TYPE].allowExtractionSlot = new boolean[]{false, false, true, false};
        TileCharger.VALID_AUGMENTS[TileCharger.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineChargerThroughput");
        TileCharger.LIGHT_VALUES[TileCharger.TYPE] = 7;
        GameRegistry.registerTileEntity(TileCharger.class, (String)"thermalexpansion:machine_charger");
        TileCharger.config();
    }

    public static void config() {
        String category = "Machine.Charger";
        BlockMachine.enable[TileCharger.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for an Energetic Infuser. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        TileCharger.ENERGY_CONFIGS[TileCharger.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage, disableScaling);
    }

    public TileCharger() {
        this.inventory = new ItemStack[4];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
    }

    public int getType() {
        return TYPE;
    }

    private void updateContainerItem() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.processTickContainerItem();
            if (this.canFinishContainerItem()) {
                this.transferContainerItem();
                this.transferOutput();
                this.transferInput();
                if (!this.redstoneControlOrDisable() || !this.canStartContainerItem()) {
                    this.processOff();
                } else {
                    this.processTickContainerItem();
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferOutput();
                this.transferInput();
            }
            if (this.timeCheckEighth() && this.canStartContainerItem()) {
                this.processTickContainerItem();
                this.isActive = true;
            }
        }
        this.updateIfChanged(curActive);
        this.chargeEnergy();
    }

    private boolean canStartContainerItem() {
        if (!EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[1])) {
            this.containerItem = null;
            this.hasContainerItem = false;
            return false;
        }
        return true;
    }

    private boolean canFinishContainerItem() {
        return this.containerItem.getEnergyStored(this.inventory[1]) >= this.containerItem.getMaxEnergyStored(this.inventory[1]);
    }

    private int processTickContainerItem() {
        int energy = this.containerItem.receiveEnergy(this.inventory[1], this.calcEnergyItem(), false);
        this.energyStorage.modifyEnergyStored(-energy);
        return energy;
    }

    private void updateHandler() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.processTickHandler();
            if (this.canFinishHandler()) {
                this.transferHandler();
                this.transferOutput();
                this.transferInput();
                if (!this.redstoneControlOrDisable() || !this.canStartHandler()) {
                    this.processOff();
                } else {
                    this.processTickHandler();
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferOutput();
                this.transferInput();
            }
            if (this.timeCheckEighth() && this.canStartHandler()) {
                this.processTickHandler();
                this.isActive = true;
            }
        }
        this.updateIfChanged(curActive);
        this.chargeEnergy();
    }

    private boolean canStartHandler() {
        if (!EnergyHelper.isEnergyHandler((ItemStack)this.inventory[1])) {
            this.handler = null;
            this.hasEnergyHandler = false;
            return false;
        }
        return true;
    }

    private boolean canFinishHandler() {
        return this.handler.canReceive() && this.handler.getEnergyStored() >= this.handler.getMaxEnergyStored();
    }

    private int processTickHandler() {
        int energy = this.handler.receiveEnergy(this.calcEnergyItem(), false);
        this.energyStorage.modifyEnergyStored(-energy);
        return energy;
    }

    @Override
    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        if (this.hasContainerItem) {
            this.updateContainerItem();
        } else if (this.hasEnergyHandler) {
            this.updateHandler();
        } else {
            super.func_73660_a();
        }
    }

    @Override
    protected int getMaxInputSlot() {
        return -1;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0].func_190926_b() || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        if (!this.hasContainerItem && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0])) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
            this.inventory[0].func_190918_g(1);
            if (this.inventory[0].func_190916_E() <= 0) {
                this.inventory[0] = ItemStack.field_190927_a;
            }
            this.containerItem = (IEnergyContainerItem)this.inventory[1].func_77973_b();
            this.hasContainerItem = true;
            return false;
        }
        if (!this.hasEnergyHandler && EnergyHelper.isEnergyHandler((ItemStack)this.inventory[0])) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
            this.inventory[0].func_190918_g(1);
            if (this.inventory[0].func_190916_E() <= 0) {
                this.inventory[0] = ItemStack.field_190927_a;
            }
            this.handler = (IEnergyStorage)this.inventory[1].getCapability(CapabilityEnergy.ENERGY, null);
            this.hasEnergyHandler = true;
            return false;
        }
        ChargerManager.ChargerRecipe recipe = ChargerManager.getRecipe(this.inventory[0]);
        if (recipe == null) {
            return false;
        }
        if (this.inventory[0].func_190916_E() < recipe.getInput().func_190916_E()) {
            return false;
        }
        ItemStack output = recipe.getOutput();
        return this.inventory[2].func_190926_b() || this.inventory[2].func_77969_a(output) && this.inventory[2].func_190916_E() + output.func_190916_E() <= output.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        if (this.hasContainerItem || this.hasEnergyHandler) {
            return true;
        }
        ChargerManager.ChargerRecipe recipe = ChargerManager.getRecipe(this.inventory[1]);
        return recipe != null && recipe.getInput().func_190916_E() <= this.inventory[1].func_190916_E();
    }

    @Override
    protected void processStart() {
        ChargerManager.ChargerRecipe recipe = ChargerManager.getRecipe(this.inventory[0]);
        this.processRem = this.processMax = recipe.getEnergy() * this.energyMod / 100;
        this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)recipe.getInput().func_190916_E());
        this.inventory[0].func_190918_g(recipe.getInput().func_190916_E());
        if (this.inventory[0].func_190916_E() <= 0) {
            this.inventory[0] = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void processFinish() {
        ChargerManager.ChargerRecipe recipe = ChargerManager.getRecipe(this.inventory[1]);
        if (recipe == null) {
            this.processOff();
            return;
        }
        ItemStack output = recipe.getOutput();
        if (this.inventory[2].func_190926_b()) {
            this.inventory[2] = ItemHelper.cloneStack((ItemStack)output);
        } else {
            this.inventory[2].func_190917_f(output.func_190916_E());
        }
        this.inventory[1] = ItemStack.field_190927_a;
    }

    @Override
    protected void transferInput() {
        if (!this.enableAutoInput) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.enableAutoOutput) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(2, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    private void transferContainerItem() {
        if (this.hasContainerItem) {
            if (this.inventory[2].func_190926_b()) {
                this.inventory[2] = ItemHelper.cloneStack((ItemStack)this.inventory[1], (int)1);
                this.inventory[1] = ItemStack.field_190927_a;
                this.containerItem = null;
                this.hasContainerItem = false;
            } else if (ItemHelper.itemsIdentical((ItemStack)this.inventory[1], (ItemStack)this.inventory[2]) && this.inventory[1].func_77976_d() > 1 && this.inventory[2].func_190916_E() + 1 <= this.inventory[2].func_77976_d()) {
                this.inventory[2].func_190917_f(1);
                this.inventory[1] = ItemStack.field_190927_a;
                this.containerItem = null;
                this.hasContainerItem = false;
            }
        }
        if (!this.hasContainerItem && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0])) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
            this.inventory[0].func_190918_g(1);
            if (this.inventory[0].func_190916_E() <= 0) {
                this.inventory[0] = ItemStack.field_190927_a;
            }
            this.containerItem = (IEnergyContainerItem)this.inventory[1].func_77973_b();
            this.hasContainerItem = true;
        }
    }

    private void transferHandler() {
        if (this.hasEnergyHandler) {
            if (this.inventory[2].func_190926_b()) {
                this.inventory[2] = ItemHelper.cloneStack((ItemStack)this.inventory[1], (int)1);
                this.inventory[1] = ItemStack.field_190927_a;
                this.handler = null;
                this.hasEnergyHandler = false;
            } else if (ItemHelper.itemsIdentical((ItemStack)this.inventory[1], (ItemStack)this.inventory[2]) && this.inventory[1].func_77976_d() > 1 && this.inventory[2].func_190916_E() + 1 <= this.inventory[2].func_77976_d()) {
                this.inventory[2].func_190917_f(1);
                this.inventory[1] = ItemStack.field_190927_a;
                this.handler = null;
                this.hasEnergyHandler = false;
            }
        }
        if (!this.hasEnergyHandler && EnergyHelper.isEnergyHandler((ItemStack)this.inventory[0])) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
            this.inventory[0].func_190918_g(1);
            if (this.inventory[0].func_190916_E() <= 0) {
                this.inventory[0] = ItemStack.field_190927_a;
            }
            this.handler = (IEnergyStorage)this.inventory[1].getCapability(CapabilityEnergy.ENERGY, null);
            this.hasEnergyHandler = true;
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCharger(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerCharger(inventory, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        if (!this.inventory[1].func_190926_b() && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[1])) {
            this.containerItem = (IEnergyContainerItem)this.inventory[1].func_77973_b();
            this.hasContainerItem = true;
        } else if (EnergyHelper.isEnergyHandler((ItemStack)this.inventory[1])) {
            this.handler = (IEnergyStorage)this.inventory[1].getCapability(CapabilityEnergy.ENERGY, null);
            this.hasEnergyHandler = true;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        return nbt;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addBool(this.augmentThroughput);
        payload.addBool(this.hasContainerItem);
        payload.addBool(this.hasEnergyHandler);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.augmentThroughput = payload.getBool();
        this.hasContainerItem = payload.getBool();
        this.hasEnergyHandler = payload.getBool();
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentThroughput = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (this.augmentThroughput) {
            this.energyStorage.setMaxTransfer(this.getEnergyTransfer(this.level) * 4);
        }
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentThroughput && "machineChargerThroughput".equals(id)) {
            this.augmentThroughput = true;
            this.hasModeAugment = true;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    private int calcEnergyItem() {
        if (!this.augmentThroughput) {
            return this.calcEnergy();
        }
        return Math.min(this.energyStorage.getEnergyStored(), this.getEnergyTransfer(this.level));
    }

    private int getEnergyTransfer(int level) {
        return ENERGY_TRANSFER[MathHelper.clamp((int)level, (int)0, (int)4)];
    }

    @Override
    public int getInfoEnergyPerTick() {
        if (!this.isActive) {
            return 0;
        }
        return (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[1]) || EnergyHelper.isEnergyHandler((ItemStack)this.inventory[1])) && this.augmentThroughput ? this.getEnergyTransfer(this.level) : this.calcEnergy();
    }

    @Override
    public int getInfoMaxEnergyPerTick() {
        return (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[1]) || EnergyHelper.isEnergyHandler((ItemStack)this.inventory[1])) && this.augmentThroughput ? this.getEnergyTransfer(this.level) : this.energyConfig.maxPower;
    }

    @Override
    public int updateAccelerable() {
        if (this.hasContainerItem) {
            return this.processTickContainerItem();
        }
        if (this.hasEnergyHandler) {
            return this.processTickHandler();
        }
        return this.processTick();
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = super.func_70298_a(slot, amount);
        if (ServerHelper.isServerWorld((World)this.field_145850_b) && slot == 1 && this.isActive && (this.inventory[slot].func_190926_b() || !this.hasValidInput())) {
            this.processOff();
            this.containerItem = null;
            this.hasContainerItem = false;
            this.handler = null;
            this.hasEnergyHandler = false;
        }
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (ServerHelper.isServerWorld((World)this.field_145850_b) && slot == 1) {
            if (!(!this.isActive || this.inventory[slot].func_190926_b() || !stack.func_190926_b() && stack.func_77969_a(this.inventory[slot]) && this.hasValidInput())) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(this.field_145850_b);
                this.processRem = 0;
            }
            this.containerItem = null;
            this.hasContainerItem = false;
            this.handler = null;
            this.hasEnergyHandler = false;
        }
        this.inventory[slot] = stack;
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    @Override
    public void func_70296_d() {
        if (this.isActive && !this.hasValidInput()) {
            this.containerItem = null;
            this.hasContainerItem = false;
            this.handler = null;
            this.hasEnergyHandler = false;
        }
        super.func_70296_d();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0 || EnergyHelper.isEnergyContainerItem((ItemStack)stack) || EnergyHelper.isEnergyHandler((ItemStack)stack) || ChargerManager.recipeExists(stack);
    }
}

