/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import cofh.api.fluid.IFluidContainerItem;
import cofh.api.tileentity.IRedstoneControl;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.util.capabilities.FluidContainerItemWrapper;
import cofh.core.util.helpers.RedstoneControlHelper;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.ItemBlockTEBase;
import cofh.thermalexpansion.block.storage.TileTank;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;

public class ItemBlockTank
extends ItemBlockTEBase
implements IFluidContainerItem,
IEnchantableItem {
    public ItemBlockTank(Block block) {
        super(block);
        this.func_77625_d(1);
    }

    @Override
    public ItemStack setDefaultTag(ItemStack stack, int level) {
        RedstoneControlHelper.setControl((ItemStack)stack, (IRedstoneControl.ControlMode)IRedstoneControl.ControlMode.DISABLED);
        stack.func_77978_p().func_74774_a("Level", (byte)level);
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        return "tile.thermalexpansion.storage.tank.name";
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        SecurityHelper.addOwnerInformation((ItemStack)stack, tooltip);
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        SecurityHelper.addAccessInformation((ItemStack)stack, tooltip);
        tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.storage.tank"));
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Fluid"));
        if (fluid != null) {
            String color = "\u00a77";
            if (fluid.getFluid().getRarity() == EnumRarity.UNCOMMON) {
                color = "\u00a7e";
            } else if (fluid.getFluid().getRarity() == EnumRarity.RARE) {
                color = "\u00a7b";
            } else if (fluid.getFluid().getRarity() == EnumRarity.EPIC) {
                color = "\u00a7d";
            }
            tooltip.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + color + fluid.getFluid().getLocalizedName(fluid) + "\u00a77");
            if (this.isCreative(stack)) {
                tooltip.add(StringHelper.localize((String)"info.cofh.infiniteSource"));
            } else {
                tooltip.add(StringHelper.localize((String)"info.cofh.level") + ": " + StringHelper.formatNumber((long)fluid.amount) + " / " + StringHelper.formatNumber((long)this.getCapacity(stack)) + " mB");
            }
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.localize((String)"info.cofh.empty"));
            if (this.isCreative(stack)) {
                tooltip.add(StringHelper.localize((String)"info.cofh.infiniteSource"));
            } else {
                tooltip.add(StringHelper.localize((String)"info.cofh.level") + ": 0 / " + StringHelper.formatNumber((long)this.getCapacity(stack)) + " mB");
            }
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 10;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack retStack = stack.func_77946_l();
        this.drain(retStack, 1000, true);
        return retStack;
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.func_77978_p() == null) {
            this.setDefaultTag(container);
        }
        if (!container.func_77978_p().func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
    }

    public int getCapacity(ItemStack container) {
        return TileTank.getCapacity(this.getLevel(container), EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)container));
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container.func_77978_p() == null) {
            this.setDefaultTag(container);
        }
        if (resource == null || this.isCreative(container)) {
            return 0;
        }
        int capacity = this.getCapacity(container);
        if (!doFill) {
            if (!container.func_77978_p().func_74764_b("Fluid")) {
                return Math.min(capacity, resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
            if (stack == null) {
                return Math.min(capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(capacity - stack.amount, resource.amount);
        }
        if (!container.func_77978_p().func_74764_b("Fluid")) {
            NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
            if (capacity < resource.amount) {
                fluidTag.func_74768_a("Amount", capacity);
                container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
                return capacity;
            }
            fluidTag.func_74768_a("Amount", resource.amount);
            container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
            return resource.amount;
        }
        NBTTagCompound fluidTag = container.func_77978_p().func_74775_l("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (!stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = capacity - stack.amount;
        if (resource.amount < filled) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = capacity;
        }
        container.func_77978_p().func_74782_a("Fluid", (NBTBase)stack.writeToNBT(fluidTag));
        return filled;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.func_77978_p() == null) {
            this.setDefaultTag(container);
        }
        if (!container.func_77978_p().func_74764_b("Fluid") || maxDrain == 0) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
        if (stack == null) {
            return null;
        }
        int drained = Math.min(stack.amount, maxDrain);
        if (doDrain && !this.isCreative(container)) {
            if (maxDrain >= stack.amount) {
                container.func_77978_p().func_82580_o("Fluid");
                return stack;
            }
            NBTTagCompound fluidTag = container.func_77978_p().func_74775_l("Fluid");
            fluidTag.func_74768_a("Amount", fluidTag.func_74762_e("Amount") - drained);
            container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        stack.amount = drained;
        return stack;
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.holding;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidContainerItemWrapper(stack, (IFluidContainerItem)this);
    }
}

