/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import cofh.api.tileentity.IInventoryRetainer;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.core.init.CoreProps;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileInventory;
import cofh.thermalexpansion.block.storage.BlockStrongbox;
import cofh.thermalexpansion.gui.client.storage.GuiStrongbox;
import cofh.thermalexpansion.gui.container.storage.ContainerStrongbox;
import cofh.thermalexpansion.init.TETextures;
import java.util.Arrays;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.api.IDropoffManager;

@Optional.Interface(iface="vazkii.quark.api.IDropoffManager", modid="quark")
public class TileStrongbox
extends TileInventory
implements ITickable,
ISidedInventory,
IReconfigurableFacing,
IInventoryRetainer,
IDropoffManager {
    private static boolean enableSecurity = true;
    private static final int TIME_CONSTANT = 200;
    byte facing = (byte)3;
    public byte enchantHolding;
    private int offset = MathHelper.RANDOM.nextInt(200);
    public float prevLidAngle;
    public float lidAngle;
    public int numUsingPlayers;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileStrongbox.class, (String)"thermalexpansion:storage_strongbox");
        TileStrongbox.config();
    }

    public static void config() {
        String category = "Storage.Strongbox";
        String comment = "If TRUE, Strongboxes are securable.";
        enableSecurity = ThermalExpansion.CONFIG.get(category, "Securable", enableSecurity, comment);
        comment = "If TRUE, Strongboxes are enabled.";
        BlockStrongbox.enable = ThermalExpansion.CONFIG.get(category, "Enable", true, comment);
        comment = "If TRUE, 'Classic' Crafting is enabled - Non-Creative Upgrade Kits WILL NOT WORK.";
        BlockStrongbox.enableClassicRecipes = ThermalExpansion.CONFIG.get(category, "ClassicCrafting", BlockStrongbox.enableClassicRecipes, comment);
        comment = "If TRUE, Strongboxes can be upgraded in a Crafting Table using Kits. If Classic Crafting is enabled, only the Creative Conversion Kit may be used in this fashion.";
        BlockStrongbox.enableUpgradeKitCrafting = ThermalExpansion.CONFIG.get(category, "UpgradeKitCrafting", BlockStrongbox.enableUpgradeKitCrafting, comment);
    }

    public String getTileName() {
        return "tile.thermalexpansion.storage.strongbox.name";
    }

    public int getType() {
        return 0;
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    @Override
    protected boolean setLevel(int level) {
        if (super.setLevel(level)) {
            if (this.inventory.length != CoreProps.STORAGE_SIZE[this.getStorageIndex()]) {
                int i;
                ItemStack[] tempInv = new ItemStack[this.inventory.length];
                for (i = 0; i < tempInv.length && i < this.inventory.length; ++i) {
                    tempInv[i] = this.inventory[i].func_190926_b() ? ItemStack.field_190927_a : this.inventory[i].func_77946_l();
                }
                this.createInventory();
                for (i = 0; i < tempInv.length && i < this.inventory.length; ++i) {
                    this.inventory[i] = tempInv[i].func_190926_b() ? ItemStack.field_190927_a : tempInv[i].func_77946_l();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected int getNumAugmentSlots(int level) {
        return 0;
    }

    public boolean onWrench(EntityPlayer player, EnumFacing side) {
        return this.rotateBlock();
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numUsingPlayers = type;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        this.getNumPlayers();
        if (this.numUsingPlayers > 0 && !this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 200L == 0L) {
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numUsingPlayers);
        }
        this.prevLidAngle = this.lidAngle;
        this.lidAngle = MathHelper.approachLinear((float)this.lidAngle, (float)(this.numUsingPlayers > 0 ? 1.0f : 0.0f), (float)0.1f);
        if ((double)this.prevLidAngle >= 0.5 && (double)this.lidAngle < 0.5) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        } else if (this.prevLidAngle == 0.0f && this.lidAngle > 0.0f) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public static int getCapacity(int level, int enchant) {
        return CoreProps.STORAGE_SIZE[Math.min(2 * (1 + level) + enchant, CoreProps.STORAGE_SIZE.length - 1)];
    }

    public void createInventory() {
        this.inventory = new ItemStack[CoreProps.STORAGE_SIZE[this.getStorageIndex()]];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
    }

    public void getNumPlayers() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        if (this.numUsingPlayers != 0 && (this.field_145850_b.func_82737_E() + (long)this.offset) % 200L == 0L) {
            this.numUsingPlayers = 0;
            float dist = 5.0f;
            for (EntityPlayer player : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - dist), (double)((float)this.field_174879_c.func_177956_o() - dist), (double)((float)this.field_174879_c.func_177952_p() - dist), (double)((float)(this.field_174879_c.func_177958_n() + 1) + dist), (double)((float)(this.field_174879_c.func_177956_o() + 1) + dist), (double)((float)(this.field_174879_c.func_177952_p() + 1) + dist)))) {
                TileStrongbox box;
                if (!(player.field_71070_bA instanceof ContainerStrongbox) || (box = ((ContainerStrongbox)player.field_71070_bA).getTile()) != this) continue;
                ++this.numUsingPlayers;
            }
        }
    }

    public int getStorageIndex() {
        if (this.isCreative) {
            return 0;
        }
        return Math.min(2 * (1 + this.level) + this.enchantHolding, CoreProps.STORAGE_SIZE.length - 1);
    }

    public double getRadianLidAngle(float f) {
        float angle = MathHelper.interpolate((float)this.prevLidAngle, (float)this.lidAngle, (float)f);
        angle = 1.0f - angle;
        angle = 1.0f - angle * angle * angle;
        return (double)angle * Math.PI * -0.5;
    }

    public TextureAtlasSprite getBreakTexture() {
        if (this.isCreative) {
            return TETextures.STRONGBOX_TOP_C;
        }
        return TETextures.STRONGBOX_TOP[this.level];
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiStrongbox(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerStrongbox(inventory, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.enchantHolding = nbt.func_74771_c("EncHolding");
        super.func_145839_a(nbt);
        this.facing = nbt.func_74771_c("Facing");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("Facing", this.facing);
        nbt.func_74774_a("EncHolding", this.enchantHolding);
        return nbt;
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addByte(this.facing);
        payload.addByte(this.enchantHolding);
        return payload;
    }

    public PacketCoFHBase getGuiPacket() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.facing = payload.getByte();
        byte tempEnchant = this.enchantHolding;
        this.enchantHolding = payload.getByte();
        if (this.inventory.length <= 0 || this.enchantHolding != tempEnchant) {
            this.createInventory();
        }
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        if (this.isCreative) {
            return ItemHelper.cloneStack((ItemStack)this.inventory[slot], (int)amount);
        }
        return super.func_70298_a(slot, amount);
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        if (this.isCreative) {
            return ItemHelper.cloneStack((ItemStack)this.inventory[slot]);
        }
        return super.func_70301_a(slot);
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (this.isCreative) {
            if (stack.func_190926_b()) {
                return;
            }
            this.inventory[slot] = stack;
            this.inventory[slot].func_190920_e(stack.func_77976_d());
            return;
        }
        super.func_70299_a(slot, stack);
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        if (player.func_175149_v()) {
            return;
        }
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        ++this.numUsingPlayers;
        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numUsingPlayers);
        this.callNeighborStateChange();
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
        if (player.func_175149_v()) {
            return;
        }
        if (this.func_145838_q() instanceof BlockStrongbox) {
            --this.numUsingPlayers;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numUsingPlayers);
            this.callNeighborStateChange();
        }
    }

    public int getFacing() {
        return this.facing;
    }

    public boolean allowYAxisFacing() {
        return false;
    }

    public boolean rotateBlock() {
        this.facing = BlockHelper.SIDE_LEFT[this.facing];
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(int side) {
        if (side < 2 || side > 5) {
            return false;
        }
        this.facing = (byte)side;
        this.func_70296_d();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.access.isPublic() ? CoreProps.SLOTS[this.getStorageIndex()] : CoreProps.EMPTY_INVENTORY;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.access.isPublic();
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return this.access.isPublic();
    }

    public boolean retainInventory() {
        return true;
    }

    public boolean acceptsDropoff(EntityPlayer player) {
        return player != null && this.canPlayerAccess(player);
    }
}

