/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.machine;

import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementDualScaled;
import cofh.core.gui.element.ElementEnergyStored;
import cofh.core.gui.element.ElementFluid;
import cofh.core.gui.element.ElementFluidTank;
import cofh.thermalexpansion.block.machine.TileExtruder;
import cofh.thermalexpansion.gui.client.GuiPoweredBase;
import cofh.thermalexpansion.gui.container.machine.ContainerExtruder;
import cofh.thermalexpansion.gui.element.ElementSlotOverlay;
import java.io.IOException;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidTank;

public class GuiExtruder
extends GuiPoweredBase {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/machine/extruder.png");
    private TileExtruder myTile;
    private ElementBase slotInput;
    private ElementBase slotOutput;
    private ElementFluid progressLava;
    private ElementFluid progressWater;
    private ElementDualScaled progressOverlay;
    private ElementFluidTank hotTank;
    private ElementFluidTank coldTank;

    public GuiExtruder(InventoryPlayer inventory, TileEntity tile) {
        super((Container)new ContainerExtruder(inventory, tile), tile, inventory.field_70458_d, TEXTURE);
        this.generateInfo("tab.thermalexpansion.machine.extruder");
        this.myTile = (TileExtruder)tile;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.slotInput = this.addElement(new ElementSlotOverlay(this, 152, 9).setSlotInfo(ElementSlotOverlay.SlotColor.BLUE, ElementSlotOverlay.SlotType.TANK, ElementSlotOverlay.SlotRender.FULL));
        this.slotOutput = this.addElement(new ElementSlotOverlay(this, 76, 45).setSlotInfo(ElementSlotOverlay.SlotColor.ORANGE, ElementSlotOverlay.SlotType.OUTPUT, ElementSlotOverlay.SlotRender.FULL));
        if (!this.myTile.smallStorage()) {
            this.addElement((ElementBase)new ElementEnergyStored((GuiContainerCore)this, 8, 8, this.myTile.getEnergyStorage()));
        }
        this.coldTank = (ElementFluidTank)this.addElement((ElementBase)new ElementFluidTank((GuiContainerCore)this, 161, 9, (IFluidTank)this.myTile.getTank(1)).setAlwaysShow(true).setThin());
        this.hotTank = (ElementFluidTank)this.addElement((ElementBase)new ElementFluidTank((GuiContainerCore)this, 152, 9, (IFluidTank)this.myTile.getTank(0)).setAlwaysShow(true).setThin());
        this.progressLava = (ElementFluid)this.addElement(new ElementFluid((GuiContainerCore)this, 112, 49).setFluid(FluidRegistry.LAVA).setSize(24, 8));
        this.progressWater = (ElementFluid)this.addElement(new ElementFluid((GuiContainerCore)this, 112, 57).setFluid(FluidRegistry.WATER).setSize(24, 8));
        this.progressOverlay = (ElementDualScaled)this.addElement(new ElementDualScaled((GuiContainerCore)this, 112, 49).setMode(2).setBackground(false).setSize(24, 16).setTexture("cofh:textures/gui/elements/progress_fluid_left.png", 64, 16));
    }

    protected void updateElementInformation() {
        super.updateElementInformation();
        this.slotInput.setVisible(this.myTile.hasSideType(1) || this.baseTile.hasSideType(8));
        this.slotOutput.setVisible(this.myTile.hasSideType(4) || this.baseTile.hasSideType(8));
        if (this.myTile.augmentNoWater()) {
            this.hotTank.setDefault().drawTank(true);
        } else {
            this.hotTank.setThin().drawTank(false);
        }
        this.coldTank.setVisible(!this.myTile.augmentNoWater());
        this.progressLava.setPosition(136 - this.myTile.getScaledProgress(24), 49);
        this.progressLava.setSize(this.myTile.getScaledProgress(24), this.myTile.augmentNoWater() ? 16 : 8);
        this.progressWater.setPosition(136 - this.myTile.getScaledProgress(24), 57);
        this.progressWater.setSize(this.myTile.getScaledProgress(24), this.myTile.augmentNoWater() ? 0 : 8);
        this.progressOverlay.setQuantity(this.myTile.getScaledProgress(24));
    }

    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        this.field_146297_k.field_71446_o.func_110577_a(this.texture);
        this.drawCurSelection();
        this.drawPrevSelection();
        if (!this.myTile.augmentNoWater()) {
            this.func_73729_b(this.field_147003_i + 159, this.field_147009_r + 9, 159, 9, 2, 60);
        }
    }

    protected void func_73864_a(int mX, int mY, int mouseButton) throws IOException {
        if (48 <= this.mouseX && this.mouseX < 128 && 18 <= this.mouseY && this.mouseY < 36) {
            if (49 <= this.mouseX && this.mouseX < 67) {
                this.myTile.setMode(0);
            } else if (79 <= this.mouseX && this.mouseX < 97) {
                this.myTile.setMode(1);
            } else if (109 <= this.mouseX && this.mouseX < 127) {
                this.myTile.setMode(2);
            }
        } else {
            super.func_73864_a(mX, mY, mouseButton);
        }
    }

    private void drawCurSelection() {
        int offset = 32;
        if (this.myTile.getPrevSelection() == this.myTile.getCurSelection() && this.myTile.isActive) {
            offset = 64;
        }
        switch (this.myTile.getCurSelection()) {
            case 0: {
                this.func_73729_b(this.field_147003_i + 42, this.field_147009_r + 11, 192, offset, 32, 32);
                break;
            }
            case 1: {
                this.func_73729_b(this.field_147003_i + 72, this.field_147009_r + 11, 192, offset, 32, 32);
                break;
            }
            case 2: {
                this.func_73729_b(this.field_147003_i + 102, this.field_147009_r + 11, 192, offset, 32, 32);
            }
        }
    }

    private void drawPrevSelection() {
        switch (this.myTile.getPrevSelection()) {
            case 0: {
                this.func_73729_b(this.field_147003_i + 42, this.field_147009_r + 11, 224, 32, 32, 32);
                break;
            }
            case 1: {
                this.func_73729_b(this.field_147003_i + 72, this.field_147009_r + 11, 224, 32, 32, 32);
                break;
            }
            case 2: {
                this.func_73729_b(this.field_147003_i + 102, this.field_147009_r + 11, 224, 32, 32, 32);
            }
        }
    }
}

