/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.storage;

import cofh.api.core.ISecurable;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.gui.element.tab.TabInfo;
import cofh.core.gui.element.tab.TabSecurity;
import cofh.core.init.CoreProps;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.storage.TileStrongbox;
import cofh.thermalexpansion.gui.container.storage.ContainerStrongbox;
import java.util.UUID;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.Optional;
import vazkii.quark.api.IChestButtonCallback;

@Optional.Interface(iface="vazkii.quark.api.IChestButtonCallback", modid="quark")
public class GuiStrongbox
extends GuiContainerCore
implements IChestButtonCallback {
    protected TileStrongbox baseTile;
    protected UUID playerName;
    protected int storageIndex;
    protected TabBase securityTab;

    public GuiStrongbox(InventoryPlayer inventory, TileEntity tile) {
        super((Container)new ContainerStrongbox(inventory, tile));
        this.baseTile = (TileStrongbox)tile;
        this.playerName = SecurityHelper.getID((EntityPlayer)inventory.field_70458_d);
        this.storageIndex = this.baseTile.getStorageIndex();
        this.texture = CoreProps.TEXTURE_STORAGE[this.storageIndex];
        this.name = this.baseTile.func_70005_c_();
        this.field_146999_f = 14 + 18 * MathHelper.clamp((int)this.storageIndex, (int)9, (int)14);
        this.field_147000_g = 112 + 18 * MathHelper.clamp((int)this.storageIndex, (int)2, (int)9);
        this.generateInfo("tab.thermalexpansion.storage.strongbox");
        if (!this.baseTile.isCreative && this.baseTile.enchantHolding <= 0) {
            this.myInfo = this.myInfo + "\n\n" + StringHelper.localize((String)"tab.thermalexpansion.storage.enchant");
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.securityTab = this.addTab((TabBase)new TabSecurity((GuiContainerCore)this, (ISecurable)this.baseTile, this.playerName));
        this.securityTab.setVisible(this.baseTile.enableSecurity() && this.baseTile.isSecured());
        if (!this.myInfo.isEmpty()) {
            this.addTab((TabBase)new TabInfo((GuiContainerCore)this, this.myInfo));
        }
    }

    protected void func_146976_a(float partialTick, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.texture);
        if (this.field_146999_f > 256 || this.field_147000_g > 256) {
            this.drawSizedTexturedModalRect(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g, 512.0f, 512.0f);
        } else {
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        this.mouseX = x - this.field_147003_i;
        this.mouseY = y - this.field_147009_r;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawElements(partialTick, false);
        this.drawTabs(partialTick, false);
        GlStateManager.func_179121_F();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.baseTile.canAccess()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.securityTab.setVisible(this.baseTile.enableSecurity() && this.baseTile.isSecured());
    }

    public boolean onAddChestButton(GuiButton button, int buttonType) {
        button.field_146128_h += this.field_146999_f + 20;
        return true;
    }
}

