/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.core.util.ModPlugin;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.machine.CompactorManager;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import cofh.thermalfoundation.item.ItemMaterial;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;

public class PluginIC2
extends ModPlugin {
    public static final String MOD_ID = "ic2";
    public static final String MOD_NAME = "IndustrialCraft 2";

    public PluginIC2() {
        super(MOD_ID, MOD_NAME);
    }

    public boolean initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for IndustrialCraft 2 is enabled.";
        boolean bl = this.enable = Loader.isModLoaded((String)MOD_ID) && ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!this.enable) {
            return false;
        }
        return !this.error;
    }

    public boolean register() {
        if (!this.enable) {
            return false;
        }
        try {
            ItemStack logRubber = this.getItemStack("rubber_wood", 1, 0);
            ItemStack saplingRubber = this.getItemStack("sapling", 1, 0);
            InsolatorManager.addDefaultTreeRecipe(saplingRubber, ItemHelper.cloneStack((ItemStack)logRubber, (int)4), saplingRubber, 50, InsolatorManager.Type.TREE);
            ItemStack coalBall = this.getItemStack("crafting", 1, 16);
            ItemStack coalBallCompressed = this.getItemStack("crafting", 1, 17);
            ItemStack coalChunk = this.getItemStack("crafting", 1, 18);
            int energy = 4000;
            CompactorManager.addRecipe(energy, coalBall, coalBallCompressed, CompactorManager.Mode.PRESS);
            CompactorManager.addRecipe(energy, coalBallCompressed, coalChunk, CompactorManager.Mode.PRESS);
            CompactorManager.addRecipe(energy, coalChunk, ItemMaterial.gemDiamond, CompactorManager.Mode.PRESS);
            Fluid biomass = FluidRegistry.getFluid((String)"ic2biomass");
            Fluid biogas = FluidRegistry.getFluid((String)"ic2biogas");
            int energy2 = 5000;
            if (biomass != null && biogas != null) {
                RefineryManager.addRecipe(energy2, new FluidStack(biomass, 25), new FluidStack(biogas, 500), this.getItemStack("crop_res", 1, 2), 5);
            }
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: IndustrialCraft 2 Plugin encountered an error:", t);
            this.error = true;
        }
        if (!this.error) {
            ThermalExpansion.LOG.info("Thermal Expansion: IndustrialCraft 2 Plugin Enabled.");
        }
        return !this.error;
    }
}

