/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.core.util.ModPlugin;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.TapperManager;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;

public class PluginRustic
extends ModPlugin {
    public static final String MOD_ID = "rustic";
    public static final String MOD_NAME = "Rustic";

    public PluginRustic() {
        super(MOD_ID, MOD_NAME);
    }

    public boolean initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Rustic is enabled.";
        boolean bl = this.enable = Loader.isModLoaded((String)MOD_ID) && ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!this.enable) {
            return false;
        }
        return !this.error;
    }

    public boolean register() {
        if (!this.enable) {
            return false;
        }
        try {
            ItemStack beeswax = this.getItemStack("beeswax");
            ItemStack chiliPepper = this.getItemStack("chili_pepper");
            ItemStack honeycomb = this.getItemStack("honeycomb");
            ItemStack grapes = this.getItemStack("grapes");
            ItemStack ironberries = this.getItemStack("ironberries");
            ItemStack olives = this.getItemStack("olives");
            ItemStack tomato = this.getItemStack("tomato");
            ItemStack wildberries = this.getItemStack("wildberries");
            ItemStack seedApple = this.getItemStack("apple_seeds");
            ItemStack seedChiliPepper = this.getItemStack("chili_pepper_seeds");
            ItemStack seedGrape = this.getItemStack("grape_stem");
            ItemStack seedTomato = this.getItemStack("tomato_seeds");
            ItemStack aloeVera = this.getItemStack("aloe_vera");
            ItemStack bloodOrchid = this.getItemStack("blood_orchid");
            ItemStack chamomile = this.getItemStack("chamomile");
            ItemStack cloudsbluff = this.getItemStack("cloudsbluff");
            ItemStack cohosh = this.getItemStack("cohosh");
            ItemStack coreRoot = this.getItemStack("core_root");
            ItemStack deathstalkMushroom = this.getItemStack("deathstalk_mushroom");
            ItemStack ginseng = this.getItemStack("ginseng");
            ItemStack horsetail = this.getItemStack("horsetail");
            ItemStack marshMallow = this.getItemStack("marsh_mallow");
            ItemStack mooncapMushroom = this.getItemStack("mooncap_mushroom");
            ItemStack windThistle = this.getItemStack("wind_thistle");
            ItemStack logOlive = this.getItemStack("log", 1, 0);
            ItemStack logIronwood = this.getItemStack("log", 1, 1);
            ItemStack saplingOlive = this.getItemStack("sapling", 1, 0);
            ItemStack saplingIronwood = this.getItemStack("sapling", 1, 1);
            ItemStack saplingApple = this.getItemStack("sapling_apple", 1, 0);
            Block log = this.getBlock("log");
            Block leaves = this.getBlock("leaves");
            Block leavesApple = this.getBlock("leaves_apple");
            Fluid honey = FluidRegistry.getFluid((String)"honey");
            Fluid juiceGrape = FluidRegistry.getFluid((String)"grapejuice");
            Fluid juiceIronberry = FluidRegistry.getFluid((String)"ironberryjuice");
            Fluid juiceWildberry = FluidRegistry.getFluid((String)"wildberryjuice");
            Fluid oilOlive = FluidRegistry.getFluid((String)"oliveoil");
            Fluid seed_oil = FluidRegistry.getFluid((String)"seed.oil");
            InsolatorManager.addDefaultRecipe(seedChiliPepper, ItemHelper.cloneStack((ItemStack)chiliPepper, (int)2), seedChiliPepper, 100);
            InsolatorManager.addDefaultRecipe(seedGrape, ItemHelper.cloneStack((ItemStack)grapes, (int)2), seedGrape, 100);
            InsolatorManager.addDefaultRecipe(seedTomato, ItemHelper.cloneStack((ItemStack)tomato, (int)2), seedTomato, 100);
            InsolatorManager.addDefaultRecipe(aloeVera, ItemHelper.cloneStack((ItemStack)aloeVera, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(bloodOrchid, ItemHelper.cloneStack((ItemStack)bloodOrchid, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(chamomile, ItemHelper.cloneStack((ItemStack)chamomile, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(cloudsbluff, ItemHelper.cloneStack((ItemStack)cloudsbluff, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(cohosh, ItemHelper.cloneStack((ItemStack)cohosh, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(coreRoot, ItemHelper.cloneStack((ItemStack)coreRoot, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(ginseng, ItemHelper.cloneStack((ItemStack)ginseng, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(horsetail, ItemHelper.cloneStack((ItemStack)horsetail, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(marshMallow, ItemHelper.cloneStack((ItemStack)marshMallow, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(windThistle, ItemHelper.cloneStack((ItemStack)windThistle, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(deathstalkMushroom, ItemHelper.cloneStack((ItemStack)deathstalkMushroom, (int)2), ItemStack.field_190927_a, 0, InsolatorManager.Type.MYCELIUM);
            InsolatorManager.addDefaultRecipe(mooncapMushroom, ItemHelper.cloneStack((ItemStack)mooncapMushroom, (int)2), ItemStack.field_190927_a, 0, InsolatorManager.Type.MYCELIUM);
            InsolatorManager.addDefaultTreeRecipe(saplingOlive, ItemHelper.cloneStack((ItemStack)logOlive, (int)4), saplingOlive, 50, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingIronwood, ItemHelper.cloneStack((ItemStack)logIronwood, (int)4), saplingIronwood, 50, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingApple, new ItemStack(Blocks.field_150364_r, 4, 0), saplingApple, 50, InsolatorManager.Type.TREE);
            int energy = 2400;
            if (seed_oil != null) {
                TransposerManager.addExtractRecipe(energy, seedApple, ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, seedChiliPepper, ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, seedGrape, ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, seedTomato, ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
            }
            energy = 4000;
            if (honey != null) {
                CentrifugeManager.addRecipe(energy, honeycomb, Arrays.asList(beeswax), new FluidStack(honey, 250));
            }
            if (juiceGrape != null) {
                CentrifugeManager.addRecipe(energy, grapes, new ArrayList<ItemStack>(), new FluidStack(juiceGrape, 250));
            }
            if (juiceIronberry != null) {
                CentrifugeManager.addRecipe(energy, ironberries, new ArrayList<ItemStack>(), new FluidStack(juiceIronberry, 250));
            }
            if (juiceWildberry != null) {
                CentrifugeManager.addRecipe(energy, wildberries, new ArrayList<ItemStack>(), new FluidStack(juiceWildberry, 250));
            }
            if (oilOlive != null) {
                CentrifugeManager.addRecipe(energy, olives, new ArrayList<ItemStack>(), new FluidStack(oilOlive, 250));
            }
            TapperManager.addMapping(logOlive, new FluidStack(TFFluids.fluidResin, 50));
            TapperManager.addMapping(logIronwood, new FluidStack(TFFluids.fluidResin, 50));
            this.addLeafMapping(log, leaves, 0);
            this.addLeafMapping(log, leaves, 1);
            this.addLeafMapping(Blocks.field_150364_r, leavesApple, 0);
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: Rustic Plugin encountered an error:", t);
            this.error = true;
        }
        if (!this.error) {
            ThermalExpansion.LOG.info("Thermal Expansion: Rustic Plugin Enabled.");
        }
        return !this.error;
    }

    private void addLeafMapping(Block logBlock, Block leafBlock, int metadata) {
        IBlockState logState = logBlock.func_176203_a(metadata);
        for (Boolean check_decay : BlockLeaves.field_176236_b.func_177700_c()) {
            IBlockState leafState = leafBlock.func_176203_a(metadata).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.TRUE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)check_decay);
            TapperManager.addLeafMappingDirect(logState, leafState);
        }
    }
}

