/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.core.util.ModPlugin;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.TapperManager;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import cofh.thermalexpansion.util.managers.machine.SawmillManager;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;

public class PluginTraverse
extends ModPlugin {
    public static final String MOD_ID = "traverse";
    public static final String MOD_NAME = "Traverse";

    public PluginTraverse() {
        super(MOD_ID, MOD_NAME);
    }

    public boolean initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Traverse is enabled.";
        boolean bl = this.enable = Loader.isModLoaded((String)MOD_ID) && ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!this.enable) {
            return false;
        }
        return !this.error;
    }

    public boolean register() {
        if (!this.enable) {
            return false;
        }
        try {
            ItemStack saplingRed = this.getItemStack("red_autumnal_sapling");
            ItemStack saplingBrown = this.getItemStack("brown_autumnal_sapling");
            ItemStack saplingOrange = this.getItemStack("orange_autumnal_sapling");
            ItemStack saplingYellow = this.getItemStack("yellow_autumnal_sapling");
            ItemStack saplingFir = this.getItemStack("fir_sapling");
            ItemStack logFir = this.getItemStack("fir_log");
            ItemStack planksFir = this.getItemStack("fir_planks");
            Block leavesRed = this.getBlock("red_autumnal_leaves");
            Block leavesBrown = this.getBlock("brown_autumnal_leaves");
            Block leavesOrange = this.getBlock("orange_autumnal_leaves");
            Block leavesYellow = this.getBlock("yellow_autumnal_leaves");
            Block leavesFir = this.getBlock("fir_leaves");
            int energy = 2400;
            SawmillManager.addRecipe(energy, this.getItemStack("fir_door"), planksFir, ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("fir_fence"), planksFir, ItemMaterial.dustWood, 25);
            SawmillManager.addRecipe(energy, this.getItemStack("fir_fence_gate"), planksFir, ItemMaterial.dustWood, 150);
            SawmillManager.addRecipe(energy, this.getItemStack("fir_stairs", 2), planksFir, ItemMaterial.dustWood, 50);
            InsolatorManager.addDefaultTreeRecipe(saplingRed, new ItemStack(Blocks.field_150364_r, 4), saplingRed, 50, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingBrown, new ItemStack(Blocks.field_150364_r, 4), saplingBrown, 50, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingOrange, new ItemStack(Blocks.field_150364_r, 4), saplingOrange, 50, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingYellow, new ItemStack(Blocks.field_150364_r, 4), saplingYellow, 50, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingFir, ItemHelper.cloneStack((ItemStack)logFir, (int)4), saplingFir, 50, InsolatorManager.Type.TREE);
            TapperManager.addMapping(logFir, new FluidStack(TFFluids.fluidResin, 100));
            TapperManager.addMapping(this.getItemStack("fir_log", 1, 1), new FluidStack(TFFluids.fluidResin, 100));
            this.addLeafMapping(Blocks.field_150364_r, leavesRed, 0);
            this.addLeafMapping(Blocks.field_150364_r, leavesBrown, 0);
            this.addLeafMapping(Blocks.field_150364_r, leavesOrange, 0);
            this.addLeafMapping(Blocks.field_150364_r, leavesYellow, 0);
            this.addLeafMapping(this.getBlock("fir_log"), 1, leavesFir, 0);
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: Traverse Plugin encountered an error:", t);
            this.error = true;
        }
        if (!this.error) {
            ThermalExpansion.LOG.info("Thermal Expansion: Traverse Plugin Enabled.");
        }
        return !this.error;
    }

    private void addLeafMapping(Block logBlock, Block leafBlock, int metadata) {
        IBlockState logState = logBlock.func_176203_a(metadata);
        for (Boolean check_decay : BlockLeaves.field_176236_b.func_177700_c()) {
            IBlockState leafState = leafBlock.func_176203_a(metadata).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.TRUE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)check_decay);
            TapperManager.addLeafMappingDirect(logState, leafState);
        }
    }

    private void addLeafMapping(Block logBlock, int logMetadata, Block leafBlock, int leafMetadata) {
        IBlockState logState = logBlock.func_176203_a(logMetadata);
        for (Boolean check_decay : BlockLeaves.field_176236_b.func_177700_c()) {
            IBlockState leafState = leafBlock.func_176203_a(leafMetadata).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.TRUE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)check_decay);
            TapperManager.addLeafMappingDirect(logState, leafState);
        }
    }
}

