/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.compactor;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.gui.client.machine.GuiCompactor;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.crafting.compactor.CompactorRecipeCategoryMint;
import cofh.thermalexpansion.plugins.jei.crafting.compactor.CompactorRecipeCategoryPress;
import cofh.thermalexpansion.plugins.jei.crafting.compactor.CompactorRecipeCategoryStorage;
import cofh.thermalexpansion.plugins.jei.crafting.compactor.CompactorRecipeWrapper;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public abstract class CompactorRecipeCategory
extends BaseRecipeCategory<CompactorRecipeWrapper> {
    public static boolean enable = true;

    public static void register(IRecipeCategoryRegistration registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CompactorRecipeCategoryPress(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CompactorRecipeCategoryStorage(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CompactorRecipeCategoryMint(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        CompactorRecipeCategoryPress.initialize(registry);
        CompactorRecipeCategoryStorage.initialize(registry);
        CompactorRecipeCategoryMint.initialize(registry);
        registry.addRecipeClickArea(GuiCompactor.class, 79, 34, 24, 16, new String[]{"thermalexpansion.compactor_press", "thermalexpansion.compactor_storage", "thermalexpansion.compactor_mint"});
    }

    public CompactorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiCompactor.TEXTURE, 26, 11, 124, 62, 0, 0, 16, 24);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.compactor.name");
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CompactorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 42, 14);
        guiItemStacks.init(1, false, 105, 23);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, (List)outputs.get(0));
    }
}

