/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.proxy;

import cofh.core.render.IModelRegister;
import cofh.thermalexpansion.block.storage.TileCache;
import cofh.thermalexpansion.block.storage.TileStrongbox;
import cofh.thermalexpansion.entity.projectile.EntityFlorb;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.proxy.Proxy;
import cofh.thermalexpansion.render.RenderCache;
import cofh.thermalexpansion.render.RenderStrongbox;
import cofh.thermalexpansion.render.entity.RenderEntityFlorb;
import java.util.ArrayList;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ProxyClient
extends Proxy {
    private static ArrayList<IModelRegister> modelList = new ArrayList();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        for (IModelRegister register : modelList) {
            register.registerModels();
        }
        this.registerRenderInformation();
    }

    @Override
    public void initialize(FMLInitializationEvent event) {
        super.initialize(event);
        RenderCache.initialize();
        RenderStrongbox.initialize();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    public void registerRenderInformation() {
        RenderingRegistry.registerEntityRenderingHandler(EntityFlorb.class, RenderEntityFlorb::new);
        ClientRegistry.bindTileEntitySpecialRenderer(TileCache.class, (TileEntitySpecialRenderer)RenderCache.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileStrongbox.class, (TileEntitySpecialRenderer)RenderStrongbox.INSTANCE);
    }

    @SubscribeEvent
    public void handleTextureStitchEventPre(TextureStitchEvent.Pre event) {
        TETextures.registerTextures(event.getMap());
    }

    @Override
    public boolean addIModelRegister(IModelRegister modelRegister) {
        return modelList.add(modelRegister);
    }
}

