/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers;

import com.google.common.collect.ImmutableSet;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collection;
import java.util.Set;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CoolantManager {
    private static TObjectIntHashMap<String> coolantMap = new TObjectIntHashMap();
    private static TObjectIntHashMap<String> coolantFactorMap = new TObjectIntHashMap();
    public static final int WATER_RF = 250000;
    public static final int WATER_FACTOR = 20;

    public static boolean isValidCoolant(Fluid fluid) {
        return fluid != null && coolantMap.containsKey((Object)fluid.getName());
    }

    public static boolean isValidCoolant(FluidStack stack) {
        return stack != null && coolantMap.containsKey((Object)stack.getFluid().getName());
    }

    public static Set<String> getCoolantFluids() {
        return ImmutableSet.copyOf((Collection)coolantMap.keySet());
    }

    public static int getCoolantRF(Fluid fluid) {
        return coolantMap.get((Object)fluid.getName());
    }

    public static int getCoolantRF(FluidStack stack) {
        return CoolantManager.getCoolantRF(stack.getFluid());
    }

    public static int getCoolantRF100mB(Fluid fluid) {
        return CoolantManager.getCoolantRF(fluid) / 10;
    }

    public static int getCoolantRF100mB(FluidStack stack) {
        return CoolantManager.getCoolantRF100mB(stack.getFluid());
    }

    public static int getCoolantFactor(Fluid fluid) {
        return coolantFactorMap.get((Object)fluid.getName());
    }

    public static int getCoolantFactor(FluidStack stack) {
        return CoolantManager.getCoolantFactor(stack.getFluid());
    }

    public static void initialize() {
        CoolantManager.addCoolant("water", 250000, 20);
        CoolantManager.addCoolant("cryotheum", 3000000, 60);
        CoolantManager.loadMappings();
    }

    public static void loadMappings() {
        CoolantManager.addCoolant("ice", 1500000, 40);
        CoolantManager.addCoolant("ic2distilled_water", 300000, 25);
        CoolantManager.addCoolant("ic2coolant", 2000000, 50);
    }

    public static boolean addCoolant(String fluidName, int coolantRF, int coolantFactor) {
        if (!FluidRegistry.isFluidRegistered((String)fluidName) || coolantRF < 0 || coolantFactor < 1 || coolantFactor > 100) {
            return false;
        }
        coolantMap.put((Object)fluidName, coolantRF);
        coolantFactorMap.put((Object)fluidName, coolantFactor);
        return true;
    }

    public static boolean removeCoolant(String fluidName) {
        if (!FluidRegistry.isFluidRegistered((String)fluidName)) {
            return false;
        }
        coolantMap.remove((Object)fluidName);
        coolantFactorMap.remove((Object)fluidName);
        return true;
    }
}

