/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers;

import cofh.core.inventory.ComparableItemStack;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.thermalfoundation.item.ItemBait;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class FisherManager {
    private static List<ItemStack> fishList = new ArrayList<ItemStack>();
    private static List<Integer> weightList = new ArrayList<Integer>();
    private static int totalWeight;
    private static TObjectIntHashMap<ComparableItemStack> baitMap;

    public static boolean isValidBait(ItemStack stack) {
        return !stack.func_190926_b() && baitMap.contains((Object)new ComparableItemStack(stack));
    }

    public static ItemStack getFish() {
        int roll = MathHelper.RANDOM.nextInt(totalWeight);
        for (int i = 0; i < weightList.size(); ++i) {
            if ((roll -= weightList.get(i).intValue()) >= 0) continue;
            return fishList.get(i);
        }
        return ItemStack.field_190927_a;
    }

    public static int getBaitMultiplier(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return baitMap.get((Object)new ComparableItemStack(stack));
    }

    public static void initialize() {
        FisherManager.addBait(ItemBait.baitBasic, 2);
        FisherManager.addBait(ItemBait.baitRich, 3);
        FisherManager.addBait(ItemBait.baitFlux, 4);
        FisherManager.addFish(new ItemStack(Items.field_151115_aP, 1, 0), 120);
        FisherManager.addFish(new ItemStack(Items.field_151115_aP, 1, 1), 50);
        FisherManager.addFish(new ItemStack(Items.field_151115_aP, 1, 2), 4);
        FisherManager.addFish(new ItemStack(Items.field_151115_aP, 1, 3), 26);
        FisherManager.loadMappings();
    }

    public static void loadMappings() {
    }

    public static boolean addFish(ItemStack fish, int weight) {
        if (fish.func_190926_b() || weight <= 0) {
            return false;
        }
        fishList.add(ItemHelper.cloneStack((ItemStack)fish, (int)1));
        weightList.add(weight);
        totalWeight += weight;
        return true;
    }

    public static void refresh() {
        TObjectIntHashMap tempBaitMap = new TObjectIntHashMap(baitMap.size());
        TObjectIntIterator it = baitMap.iterator();
        while (it.hasNext()) {
            it.advance();
            tempBaitMap.put((Object)new ComparableItemStack(((ComparableItemStack)it.key()).toItemStack()), it.value());
        }
        baitMap.clear();
        baitMap = tempBaitMap;
    }

    private static void addBait(ItemStack bait, int multiplier) {
        baitMap.put((Object)new ComparableItemStack(bait), multiplier);
    }

    static {
        baitMap = new TObjectIntHashMap();
    }
}

