/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers;

import cofh.core.inventory.ComparableItemStack;
import cofh.core.util.BlockWrapper;
import cofh.core.util.ItemWrapper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemFertilizer;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class TapperManager {
    private static Map<BlockWrapper, FluidStack> blockMap = new THashMap();
    private static Map<ItemWrapper, FluidStack> itemMap = new THashMap();
    private static SetMultimap<BlockWrapper, BlockWrapper> leafMap = HashMultimap.create();
    private static TObjectIntHashMap<ComparableItemStack> fertilizerMap = new TObjectIntHashMap();
    public static FluidStack DEFAULT_FLUID = new FluidStack(TFFluids.fluidResin, 0);

    public static FluidStack getFluid(IBlockState state) {
        FluidStack ret = blockMap.get(new BlockWrapper(state.func_177230_c(), state.func_177230_c().func_176201_c(state)));
        return ret != null ? ret : DEFAULT_FLUID;
    }

    public static boolean mappingExists(IBlockState state) {
        return TapperManager.getFluid(state) != DEFAULT_FLUID;
    }

    public static FluidStack getFluid(ItemStack stack) {
        FluidStack ret = itemMap.get(new ItemWrapper(stack.func_77973_b(), ItemHelper.getItemDamage((ItemStack)stack)));
        return ret != null ? ret : DEFAULT_FLUID;
    }

    public static boolean mappingExists(ItemStack stack) {
        return TapperManager.getFluid(stack) != DEFAULT_FLUID;
    }

    public static Set<BlockWrapper> getLeaf(IBlockState state) {
        return leafMap.get((Object)new BlockWrapper(state.func_177230_c(), state.func_177230_c().func_176201_c(state)));
    }

    public static int getFertilizerMultiplier(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return fertilizerMap.get((Object)new ComparableItemStack(stack));
    }

    public static void initialize() {
        FluidStack sap = new FluidStack(TFFluids.fluidSap, 50);
        FluidStack resin = new FluidStack(TFFluids.fluidResin, 50);
        FluidStack mushroom_stew = new FluidStack(TFFluids.fluidMushroomStew, 50);
        TapperManager.addFertilizer(ItemFertilizer.fertilizerBasic, 2);
        TapperManager.addFertilizer(ItemFertilizer.fertilizerRich, 3);
        TapperManager.addFertilizer(ItemFertilizer.fertilizerFlux, 4);
        TapperManager.addMapping(new ItemStack(Blocks.field_150364_r, 1, 0), new FluidStack(sap, 50));
        TapperManager.addMapping(new ItemStack(Blocks.field_150364_r, 1, 1), new FluidStack(resin, 100));
        TapperManager.addMapping(new ItemStack(Blocks.field_150364_r, 1, 2), new FluidStack(resin, 50));
        TapperManager.addMapping(new ItemStack(Blocks.field_150364_r, 1, 3), new FluidStack(resin, 50));
        TapperManager.addMapping(new ItemStack(Blocks.field_150363_s, 1, 0), new FluidStack(resin, 50));
        TapperManager.addMapping(new ItemStack(Blocks.field_150363_s, 1, 1), new FluidStack(sap, 50));
        TapperManager.addMapping(new ItemStack(Blocks.field_150420_aW, 1, 10), new FluidStack(mushroom_stew, 50));
        TapperManager.addMapping(new ItemStack(Blocks.field_150419_aX, 1, 10), new FluidStack(mushroom_stew, 50));
        TapperManager.addVanillaLeafMappings(Blocks.field_150364_r, (PropertyEnum<BlockPlanks.EnumType>)BlockOldLog.field_176301_b, (Block)Blocks.field_150362_t, (PropertyEnum<BlockPlanks.EnumType>)BlockOldLeaf.field_176239_P);
        TapperManager.addVanillaLeafMappings(Blocks.field_150363_s, (PropertyEnum<BlockPlanks.EnumType>)BlockNewLog.field_176300_b, (Block)Blocks.field_150361_u, (PropertyEnum<BlockPlanks.EnumType>)BlockNewLeaf.field_176240_P);
        TapperManager.addLeafMappingDirect(Blocks.field_150420_aW.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM), Blocks.field_150420_aW.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.CENTER));
        TapperManager.addLeafMappingDirect(Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM), Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.NORTH_WEST));
        TapperManager.addLeafMappingDirect(Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM), Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.NORTH));
        TapperManager.addLeafMappingDirect(Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM), Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.NORTH_EAST));
        TapperManager.addLeafMappingDirect(Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM), Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.WEST));
        TapperManager.addLeafMappingDirect(Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM), Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.CENTER));
        TapperManager.addLeafMappingDirect(Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM), Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.EAST));
        TapperManager.addLeafMappingDirect(Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM), Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.SOUTH_WEST));
        TapperManager.addLeafMappingDirect(Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM), Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.SOUTH));
        TapperManager.addLeafMappingDirect(Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM), Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.SOUTH_EAST));
        TapperManager.loadMappings();
    }

    public static void loadMappings() {
    }

    public static boolean addMapping(ItemStack item, FluidStack fluid) {
        if (item.func_190926_b() || fluid == null) {
            return false;
        }
        if (item.func_77973_b() instanceof ItemBlock) {
            blockMap.put(new BlockWrapper(((ItemBlock)item.func_77973_b()).func_179223_d(), ItemHelper.getItemDamage((ItemStack)item)), fluid.copy());
        }
        itemMap.put(new ItemWrapper(item.func_77973_b(), ItemHelper.getItemDamage((ItemStack)item)), fluid.copy());
        return true;
    }

    public static boolean addLeafMapping(ItemStack log, ItemStack leaf) {
        if (log.func_190926_b() || leaf.func_190926_b()) {
            return false;
        }
        leafMap.put((Object)new BlockWrapper(((ItemBlock)log.func_77973_b()).func_179223_d(), ItemHelper.getItemDamage((ItemStack)log)), (Object)new BlockWrapper(((ItemBlock)leaf.func_77973_b()).func_179223_d(), ItemHelper.getItemDamage((ItemStack)leaf)));
        return true;
    }

    public static void refresh() {
        THashMap tempBlockMap = new THashMap(blockMap.size());
        THashMap tempItemMap = new THashMap(itemMap.size());
        HashMultimap tempLeafMap = HashMultimap.create((int)leafMap.keySet().size(), (int)(leafMap.size() / leafMap.keySet().size()));
        TObjectIntHashMap tempFertilizerMap = new TObjectIntHashMap(fertilizerMap.size());
        for (Map.Entry<BlockWrapper, FluidStack> entry : blockMap.entrySet()) {
            BlockWrapper tempBlock = new BlockWrapper(entry.getKey().block, entry.getKey().metadata);
            tempBlockMap.put(tempBlock, entry.getValue());
        }
        for (Map.Entry<BlockWrapper, FluidStack> entry : itemMap.entrySet()) {
            ItemWrapper tempItem = new ItemWrapper(((ItemWrapper)entry.getKey()).item, ((ItemWrapper)entry.getKey()).metadata);
            tempItemMap.put(tempItem, entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : leafMap.entries()) {
            BlockWrapper tempLeaf = new BlockWrapper(((BlockWrapper)entry.getKey()).block, ((BlockWrapper)entry.getKey()).metadata);
            tempLeafMap.put((Object)tempLeaf, entry.getValue());
        }
        TObjectIntIterator it = fertilizerMap.iterator();
        while (it.hasNext()) {
            it.advance();
            tempFertilizerMap.put((Object)new ComparableItemStack(((ComparableItemStack)it.key()).toItemStack()), it.value());
        }
        blockMap.clear();
        itemMap.clear();
        leafMap.clear();
        fertilizerMap.clear();
        blockMap = tempBlockMap;
        itemMap = tempItemMap;
        leafMap = tempLeafMap;
        fertilizerMap = tempFertilizerMap;
    }

    private static void addVanillaLeafMappings(Block logBlock, PropertyEnum<BlockPlanks.EnumType> logVariantProperty, Block leavesBlock, PropertyEnum<BlockPlanks.EnumType> leafVariantProperty) {
        for (BlockPlanks.EnumType variant : logVariantProperty.func_177700_c()) {
            IBlockState logState = logBlock.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a(logVariantProperty, (Comparable)variant);
            for (Boolean check_decay : BlockLeaves.field_176236_b.func_177700_c()) {
                IBlockState leafState = leavesBlock.func_176223_P().func_177226_a(leafVariantProperty, (Comparable)variant).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.TRUE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)check_decay);
                leafMap.put((Object)new BlockWrapper(logState), (Object)new BlockWrapper(leafState));
            }
        }
    }

    private static void addFertilizer(ItemStack fertilizer, int multiplier) {
        fertilizerMap.put((Object)new ComparableItemStack(fertilizer), multiplier);
    }

    public static void addLeafMappingDirect(IBlockState logState, IBlockState leafState) {
        leafMap.put((Object)new BlockWrapper(logState), (Object)new BlockWrapper(leafState));
    }
}

