/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStack;
import cofh.core.util.helpers.ColorHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CentrifugeManager {
    private static Map<ComparableItemStackCentrifuge, CentrifugeRecipe> recipeMap = new THashMap();
    public static final int DEFAULT_ENERGY = 4000;

    public static CentrifugeRecipe getRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackCentrifuge query = new ComparableItemStackCentrifuge(input);
        CentrifugeRecipe recipe = recipeMap.get((Object)query);
        if (recipe == null) {
            query.metadata = Short.MAX_VALUE;
            recipe = recipeMap.get((Object)query);
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input) {
        return CentrifugeManager.getRecipe(input) != null;
    }

    public static CentrifugeRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new CentrifugeRecipe[recipeMap.size()]);
    }

    public static void initialize() {
        int energy = 4000;
        CentrifugeManager.addRecipe(energy, new ItemStack(Items.field_151064_bs), Arrays.asList(new ItemStack(Items.field_151123_aH), new ItemStack(Items.field_151065_br)), null);
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustElectrum, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustGold), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSilver)), null);
        CentrifugeManager.addRecipe(energy * 3, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustInvar, (int)3), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustIron, (int)2), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustNickel)), null);
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBronze, (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCopper, (int)3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustTin)), null);
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustConstantan, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCopper), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustNickel)), null);
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSignalum, (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCopper, (int)3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSilver)), new FluidStack(TFFluids.fluidRedstone, 1000));
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustLumium, (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustTin, (int)3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSilver)), new FluidStack(TFFluids.fluidGlowstone, 1000));
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustEnderium, (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustLead, (int)3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustPlatinum)), new FluidStack(TFFluids.fluidEnder, 1000));
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustPyrotheum, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCoal), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSulfur), new ItemStack(Items.field_151065_br), new ItemStack(Items.field_151137_ax)), null);
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCryotheum, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustNiter), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBlizz), new ItemStack(Items.field_151126_ay), new ItemStack(Items.field_151137_ax)), null);
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustAerotheum, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustNiter), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBlitz), new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Items.field_151137_ax)), null);
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustPetrotheum, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustObsidian), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBasalz), new ItemStack(Items.field_151119_aD), new ItemStack(Items.field_151137_ax)), null);
        int[] dyeChance = new int[ColorHelper.WOOL_COLOR_CONFIG.length];
        for (int i = 0; i < ColorHelper.WOOL_COLOR_CONFIG.length; ++i) {
            dyeChance[i] = 10;
        }
        dyeChance[EnumDyeColor.WHITE.func_176765_a()] = 0;
        dyeChance[EnumDyeColor.BROWN.func_176765_a()] = 0;
        dyeChance[EnumDyeColor.BLUE.func_176765_a()] = 0;
        dyeChance[EnumDyeColor.BLACK.func_176765_a()] = 0;
        ItemStack gravel = new ItemStack(Blocks.field_150351_n);
        ItemStack sand = new ItemStack((Block)Blocks.field_150354_m);
        for (int i = 0; i < ColorHelper.WOOL_COLOR_CONFIG.length; ++i) {
            if (dyeChance[i] > 0) {
                CentrifugeManager.addRecipe(energy, new ItemStack(Blocks.field_192444_dS, 2, i), Arrays.asList(gravel, sand, new ItemStack(Items.field_151100_aR, 1, 15 - i)), Arrays.asList(100, 100, dyeChance[i]), null);
                continue;
            }
            CentrifugeManager.addRecipe(energy, new ItemStack(Blocks.field_192444_dS, 2, i), Arrays.asList(gravel, sand), null);
        }
        CentrifugeManager.loadRecipes();
    }

    public static void loadRecipes() {
    }

    public static CentrifugeRecipe addRecipe(int energy, ItemStack input, List<ItemStack> output, List<Integer> chance, FluidStack fluid) {
        if (input.func_190926_b() || output.isEmpty() && fluid == null || output.size() > 4 || energy <= 0 || CentrifugeManager.recipeExists(input)) {
            return null;
        }
        CentrifugeRecipe recipe = new CentrifugeRecipe(input, output, chance, fluid, energy);
        recipeMap.put(new ComparableItemStackCentrifuge(input), recipe);
        return recipe;
    }

    public static CentrifugeRecipe addRecipe(int energy, ItemStack input, List<ItemStack> output, FluidStack fluid) {
        if (input.func_190926_b() || output.isEmpty() && fluid == null || output.size() > 4 || energy <= 0 || CentrifugeManager.recipeExists(input)) {
            return null;
        }
        CentrifugeRecipe recipe = new CentrifugeRecipe(input, output, null, fluid, energy);
        recipeMap.put(new ComparableItemStackCentrifuge(input), recipe);
        return recipe;
    }

    public static CentrifugeRecipe removeRecipe(ItemStack input) {
        return recipeMap.remove((Object)new ComparableItemStackCentrifuge(input));
    }

    public static void refresh() {
        THashMap tempMap = new THashMap(recipeMap.size());
        for (Map.Entry<ComparableItemStackCentrifuge, CentrifugeRecipe> entry : recipeMap.entrySet()) {
            CentrifugeRecipe tempRecipe = entry.getValue();
            tempMap.put(new ComparableItemStackCentrifuge(tempRecipe.input), tempRecipe);
        }
        recipeMap.clear();
        recipeMap = tempMap;
    }

    public static class ComparableItemStackCentrifuge
    extends ComparableItemStack {
        public static final String DUST = "dust";

        public static boolean safeOreType(String oreName) {
            return oreName.startsWith(DUST);
        }

        public static int getOreID(ItemStack stack) {
            ArrayList ids = OreDictionaryArbiter.getAllOreIDs((ItemStack)stack);
            if (ids != null) {
                for (Integer id : ids) {
                    if (id == -1 || !ComparableItemStackCentrifuge.safeOreType(ItemHelper.oreProxy.getOreName(id.intValue()))) continue;
                    return id;
                }
            }
            return -1;
        }

        ComparableItemStackCentrifuge(ItemStack stack) {
            super(stack);
            this.oreID = ComparableItemStackCentrifuge.getOreID(stack);
        }

        public ComparableItemStackCentrifuge set(ItemStack stack) {
            super.set(stack);
            this.oreID = ComparableItemStackCentrifuge.getOreID(stack);
            return this;
        }
    }

    public static class CentrifugeRecipe {
        final ItemStack input;
        final List<ItemStack> output;
        final List<Integer> chance;
        final FluidStack fluid;
        final int energy;

        CentrifugeRecipe(ItemStack input, @Nullable List<ItemStack> output, @Nullable List<Integer> chance, @Nullable FluidStack fluid, int energy) {
            this.input = input;
            this.output = new ArrayList<ItemStack>();
            if (output != null) {
                this.output.addAll(output);
            }
            this.chance = new ArrayList<Integer>();
            if (chance != null) {
                this.chance.addAll(chance);
            } else {
                for (int i = 0; i < this.output.size(); ++i) {
                    this.chance.add(100);
                }
            }
            this.fluid = fluid;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public List<ItemStack> getOutput() {
            return this.output;
        }

        public List<Integer> getChance() {
            return this.chance;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

