/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStack;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.thermalfoundation.item.ItemFertilizer;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class InsolatorManager {
    private static Map<List<ComparableItemStackInsolator>, InsolatorRecipe> recipeMap = new THashMap();
    private static Set<ComparableItemStackInsolator> validationSet = new THashSet();
    private static Set<ComparableItemStackInsolator> lockSet = new THashSet();
    static final int CROP_MULTIPLIER_RICH = 3;
    static final int CROP_MULTIPLIER_FLUX = 4;
    public static final int DEFAULT_ENERGY = 5000;
    public static final int DEFAULT_ENERGY_RICH = 7500;
    public static final int DEFAULT_ENERGY_FLUX = 10000;

    public static boolean isRecipeReversed(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b()) {
            return false;
        }
        ComparableItemStackInsolator query = new ComparableItemStackInsolator(primaryInput);
        ComparableItemStackInsolator querySecondary = new ComparableItemStackInsolator(secondaryInput);
        InsolatorRecipe recipe = recipeMap.get(Arrays.asList(query, querySecondary));
        return recipe == null && recipeMap.get(Arrays.asList(querySecondary, query)) != null;
    }

    public static InsolatorRecipe getRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b()) {
            return null;
        }
        ComparableItemStackInsolator query = new ComparableItemStackInsolator(primaryInput);
        ComparableItemStackInsolator querySecondary = new ComparableItemStackInsolator(secondaryInput);
        InsolatorRecipe recipe = recipeMap.get(Arrays.asList(query, querySecondary));
        if (recipe == null) {
            recipe = recipeMap.get(Arrays.asList(querySecondary, query));
        }
        if (recipe == null) {
            return null;
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack primaryInput, ItemStack secondaryInput) {
        return InsolatorManager.getRecipe(primaryInput, secondaryInput) != null;
    }

    public static InsolatorRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new InsolatorRecipe[recipeMap.size()]);
    }

    public static boolean isItemValid(ItemStack input) {
        return !input.func_190926_b() && validationSet.contains((Object)new ComparableItemStackInsolator(input));
    }

    public static boolean isItemFertilizer(ItemStack input) {
        return !input.func_190926_b() && lockSet.contains((Object)new ComparableItemStackInsolator(input));
    }

    public static void initialize() {
        InsolatorManager.addFertilizer(ItemFertilizer.fertilizerBasic);
        InsolatorManager.addFertilizer(ItemFertilizer.fertilizerRich);
        InsolatorManager.addFertilizer(ItemFertilizer.fertilizerFlux);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151015_O), new ItemStack(Items.field_151014_N), 110);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_185163_cU), new ItemStack(Items.field_185164_cV), new ItemStack(Items.field_185163_cU), 110);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151174_bG, 3), new ItemStack(Items.field_151170_bI), 5);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151172_bF), new ItemStack(Items.field_151172_bF, 3), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151100_aR, 1, 3), new ItemStack(Items.field_151100_aR, 3, 3), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151120_aE), new ItemStack(Items.field_151120_aE, 2), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150434_aF), new ItemStack((Block)Blocks.field_150434_aF, 2), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack(Blocks.field_150395_bd), new ItemStack(Blocks.field_150395_bd, 2), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack(Blocks.field_150392_bi), new ItemStack(Blocks.field_150392_bi, 2), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151080_bb), new ItemStack(Blocks.field_150423_aK), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151081_bc), new ItemStack(Blocks.field_150440_ba), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150327_N, 1, 0), new ItemStack((Block)Blocks.field_150327_N, 3, 0), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 0), new ItemStack((Block)Blocks.field_150328_O, 3, 0), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 1), new ItemStack((Block)Blocks.field_150328_O, 3, 1), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 2), new ItemStack((Block)Blocks.field_150328_O, 3, 2), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 3), new ItemStack((Block)Blocks.field_150328_O, 3, 3), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 4), new ItemStack((Block)Blocks.field_150328_O, 3, 4), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 5), new ItemStack((Block)Blocks.field_150328_O, 3, 5), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 6), new ItemStack((Block)Blocks.field_150328_O, 3, 6), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 7), new ItemStack((Block)Blocks.field_150328_O, 3, 7), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 8), new ItemStack((Block)Blocks.field_150328_O, 3, 8), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, 0), new ItemStack((Block)Blocks.field_150398_cm, 3, 0), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, 1), new ItemStack((Block)Blocks.field_150398_cm, 3, 1), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, 4), new ItemStack((Block)Blocks.field_150398_cm, 3, 4), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, 5), new ItemStack((Block)Blocks.field_150398_cm, 3, 5), ItemStack.field_190927_a, 0);
        ArrayList<ItemStack> crops = new ArrayList<ItemStack>();
        crops.add(new ItemStack((Block)Blocks.field_150338_P));
        crops.add(new ItemStack((Block)Blocks.field_150337_Q));
        for (ItemStack input : crops) {
            InsolatorManager.addDefaultRecipe(input, ItemHelper.cloneStack((ItemStack)input, (int)2), ItemStack.field_190927_a, 0, Type.MYCELIUM);
        }
        crops = new ArrayList();
        crops.add(new ItemStack(Items.field_151075_bm));
        for (ItemStack input : crops) {
            InsolatorManager.addDefaultRecipe(input, ItemHelper.cloneStack((ItemStack)input, (int)2), ItemStack.field_190927_a, 0, Type.NETHER);
        }
        ItemStack input = new ItemStack(Blocks.field_185766_cS);
        ItemStack output = new ItemStack(Blocks.field_185765_cR);
        InsolatorManager.addDefaultRecipe(input, ItemHelper.cloneStack((ItemStack)output, (int)2), input, 100, Type.END);
        InsolatorManager.addDefaultTreeRecipe(new ItemStack(Blocks.field_150345_g, 1, 0), new ItemStack(Blocks.field_150364_r, 4, 0), new ItemStack(Blocks.field_150345_g, 1, 0), 50, Type.TREE);
        InsolatorManager.addDefaultTreeRecipe(new ItemStack(Blocks.field_150345_g, 1, 1), new ItemStack(Blocks.field_150364_r, 4, 1), new ItemStack(Blocks.field_150345_g, 1, 1), 50, Type.TREE);
        InsolatorManager.addDefaultTreeRecipe(new ItemStack(Blocks.field_150345_g, 1, 2), new ItemStack(Blocks.field_150364_r, 4, 2), new ItemStack(Blocks.field_150345_g, 1, 2), 50, Type.TREE);
        InsolatorManager.addDefaultTreeRecipe(new ItemStack(Blocks.field_150345_g, 1, 3), new ItemStack(Blocks.field_150364_r, 4, 3), new ItemStack(Blocks.field_150345_g, 1, 3), 50, Type.TREE);
        InsolatorManager.addDefaultTreeRecipe(new ItemStack(Blocks.field_150345_g, 1, 4), new ItemStack(Blocks.field_150363_s, 4, 0), new ItemStack(Blocks.field_150345_g, 1, 4), 50, Type.TREE);
        InsolatorManager.addDefaultTreeRecipe(new ItemStack(Blocks.field_150345_g, 1, 5), new ItemStack(Blocks.field_150363_s, 4, 1), new ItemStack(Blocks.field_150345_g, 1, 5), 50, Type.TREE);
        InsolatorManager.loadRecipes();
    }

    public static void loadRecipes() {
        String[] oreNameList;
        for (String name : oreNameList = OreDictionary.getOreNames()) {
            if (!name.startsWith("seed")) continue;
            String oreName = name.substring(4, name.length());
            InsolatorManager.addDefaultOreDictionaryRecipe(oreName);
        }
    }

    public static void refresh() {
        THashMap tempMap = new THashMap(recipeMap.size());
        THashSet tempSet = new THashSet();
        for (Map.Entry<List<ComparableItemStackInsolator>, InsolatorRecipe> entry : recipeMap.entrySet()) {
            InsolatorRecipe tempRecipe = entry.getValue();
            ComparableItemStackInsolator primary = new ComparableItemStackInsolator(tempRecipe.primaryInput);
            ComparableItemStackInsolator secondary = new ComparableItemStackInsolator(tempRecipe.secondaryInput);
            tempMap.put(Arrays.asList(primary, secondary), tempRecipe);
            tempSet.add(primary);
            tempSet.add(secondary);
        }
        recipeMap.clear();
        recipeMap = tempMap;
        validationSet.clear();
        validationSet = tempSet;
        THashSet tempSet2 = new THashSet();
        for (ComparableItemStackInsolator entry : lockSet) {
            ComparableItemStackInsolator lock = new ComparableItemStackInsolator(new ItemStack(entry.item, entry.stackSize, entry.metadata));
            tempSet2.add(lock);
        }
        lockSet.clear();
        lockSet = tempSet2;
    }

    public static InsolatorRecipe addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, boolean copyNBT, Type type) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b() || energy <= 0 || InsolatorManager.recipeExists(primaryInput, secondaryInput)) {
            return null;
        }
        InsolatorRecipe recipe = new InsolatorRecipe(primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryOutput.func_190926_b() ? 0 : secondaryChance, energy, copyNBT, type);
        recipeMap.put(Arrays.asList(new ComparableItemStackInsolator(primaryInput), new ComparableItemStackInsolator(secondaryInput)), recipe);
        validationSet.add(new ComparableItemStackInsolator(primaryInput));
        validationSet.add(new ComparableItemStackInsolator(secondaryInput));
        return recipe;
    }

    public static InsolatorRecipe addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        return InsolatorManager.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryChance, false, Type.STANDARD);
    }

    public static InsolatorRecipe addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return InsolatorManager.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100);
    }

    public static InsolatorRecipe addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        return InsolatorManager.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, ItemStack.field_190927_a, 0);
    }

    public static InsolatorRecipe removeRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        return recipeMap.remove(Arrays.asList(new ComparableItemStackInsolator(primaryInput), new ComparableItemStackInsolator(secondaryInput)));
    }

    private static void addFertilizer(ItemStack fertilizer) {
        lockSet.add(new ComparableItemStackInsolator(fertilizer));
    }

    public static void addDefaultOreDictionaryRecipe(String oreType) {
        if (oreType.length() <= 0) {
            return;
        }
        String seedName = "seed" + StringHelper.titleCase((String)oreType);
        String cropName = "crop" + StringHelper.titleCase((String)oreType);
        NonNullList registeredSeeds = OreDictionary.getOres((String)seedName, (boolean)false);
        NonNullList registeredCrops = OreDictionary.getOres((String)cropName, (boolean)false);
        if (registeredSeeds.isEmpty() || registeredCrops.isEmpty()) {
            return;
        }
        boolean isTuber = false;
        boolean isBlock = false;
        for (ItemStack seed : registeredSeeds) {
            for (ItemStack crop : registeredCrops) {
                if (!ItemHelper.itemsEqualWithMetadata((ItemStack)seed, (ItemStack)crop)) continue;
                isTuber = true;
            }
        }
        if (ItemHelper.isBlock((ItemStack)((ItemStack)registeredCrops.get(0)))) {
            isBlock = true;
        }
        ItemStack seed = ItemHelper.cloneStack((ItemStack)((ItemStack)registeredSeeds.get(0)), (int)1);
        ItemStack crop = ItemHelper.cloneStack((ItemStack)((ItemStack)registeredCrops.get(0)), (int)(isTuber ? 3 : 1));
        if (isBlock || isTuber) {
            InsolatorManager.addDefaultRecipe(seed, crop, ItemStack.field_190927_a, 0);
        } else {
            InsolatorManager.addDefaultRecipe(seed, crop, seed, 110);
        }
    }

    public static void addDefaultRecipe(ItemStack primaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        InsolatorManager.addDefaultRecipe(primaryInput, primaryOutput, secondaryOutput, secondaryChance, false, Type.STANDARD);
    }

    public static void addDefaultRecipe(ItemStack primaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, Type type) {
        InsolatorManager.addDefaultRecipe(primaryInput, primaryOutput, secondaryOutput, secondaryChance, false, type);
    }

    public static void addDefaultRecipe(ItemStack primaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, boolean copyNBT, Type type) {
        if (!secondaryOutput.func_190926_b()) {
            InsolatorManager.addRecipe(5000, primaryInput, ItemFertilizer.fertilizerBasic, primaryOutput, secondaryOutput, secondaryChance, copyNBT, type);
            InsolatorManager.addRecipe(7500, primaryInput, ItemFertilizer.fertilizerRich, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 3)), secondaryOutput, secondaryChance < 100 ? 100 : (secondaryChance < 125 ? 125 : secondaryChance), copyNBT, type);
            InsolatorManager.addRecipe(10000, primaryInput, ItemFertilizer.fertilizerFlux, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 4)), secondaryOutput, secondaryChance < 150 ? 150 : secondaryChance, copyNBT, type);
        } else {
            InsolatorManager.addRecipe(5000, primaryInput, ItemFertilizer.fertilizerBasic, primaryOutput, ItemStack.field_190927_a, 0, copyNBT, type);
            InsolatorManager.addRecipe(7500, primaryInput, ItemFertilizer.fertilizerRich, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 3)), ItemStack.field_190927_a, 0, copyNBT, type);
            InsolatorManager.addRecipe(10000, primaryInput, ItemFertilizer.fertilizerFlux, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 4)), ItemStack.field_190927_a, 0, copyNBT, type);
        }
    }

    public static void addDefaultTreeRecipe(ItemStack primaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, Type type) {
        InsolatorManager.addDefaultTreeRecipe(primaryInput, primaryOutput, secondaryOutput, secondaryChance, false, type);
    }

    public static void addDefaultTreeRecipe(ItemStack primaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, boolean copyNBT, Type type) {
        if (!secondaryOutput.func_190926_b()) {
            InsolatorManager.addRecipe(10000, primaryInput, ItemFertilizer.fertilizerBasic, primaryOutput, secondaryOutput, secondaryChance, copyNBT, type);
            InsolatorManager.addRecipe(15000, primaryInput, ItemFertilizer.fertilizerRich, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 3)), secondaryOutput, secondaryChance < 100 ? 100 : (secondaryChance < 125 ? 125 : secondaryChance), copyNBT, type);
            InsolatorManager.addRecipe(20000, primaryInput, ItemFertilizer.fertilizerFlux, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 4)), secondaryOutput, secondaryChance < 150 ? 150 : secondaryChance, copyNBT, type);
        } else {
            InsolatorManager.addRecipe(10000, primaryInput, ItemFertilizer.fertilizerBasic, primaryOutput, ItemStack.field_190927_a, 0, copyNBT, type);
            InsolatorManager.addRecipe(15000, primaryInput, ItemFertilizer.fertilizerRich, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 3)), ItemStack.field_190927_a, 0, copyNBT, type);
            InsolatorManager.addRecipe(20000, primaryInput, ItemFertilizer.fertilizerFlux, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 4)), ItemStack.field_190927_a, 0, copyNBT, type);
        }
    }

    public static class ComparableItemStackInsolator
    extends ComparableItemStack {
        public static final String SEED = "seed";
        public static final String CROP = "crop";

        public static boolean safeOreType(String oreName) {
            return oreName.startsWith(SEED) || oreName.startsWith(CROP);
        }

        public static int getOreID(ItemStack stack) {
            ArrayList ids = OreDictionaryArbiter.getAllOreIDs((ItemStack)stack);
            if (ids != null) {
                for (Integer id : ids) {
                    if (id == -1 || !ComparableItemStackInsolator.safeOreType(ItemHelper.oreProxy.getOreName(id.intValue()))) continue;
                    return id;
                }
            }
            return -1;
        }

        public ComparableItemStackInsolator(ItemStack stack) {
            super(stack);
            this.oreID = ComparableItemStackInsolator.getOreID(stack);
        }

        public ComparableItemStackInsolator set(ItemStack stack) {
            super.set(stack);
            this.oreID = ComparableItemStackInsolator.getOreID(stack);
            return this;
        }
    }

    public static enum Type {
        STANDARD,
        MYCELIUM,
        NETHER,
        END,
        TREE,
        MYCELIUM_TREE,
        NETHER_TREE,
        END_TREE;

    }

    public static class InsolatorRecipe {
        final ItemStack primaryInput;
        final ItemStack secondaryInput;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;
        final boolean copyNBT;
        final Type type;

        InsolatorRecipe(ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, int energy, boolean copyNBT, Type type) {
            this.primaryInput = primaryInput;
            this.secondaryInput = secondaryInput;
            this.primaryOutput = primaryOutput;
            this.secondaryOutput = secondaryOutput;
            this.secondaryChance = secondaryChance;
            this.energy = energy;
            this.copyNBT = copyNBT;
            this.type = type;
        }

        public ItemStack getPrimaryInput() {
            return this.primaryInput;
        }

        public ItemStack getSecondaryInput() {
            return this.secondaryInput;
        }

        public ItemStack getPrimaryOutput() {
            return this.primaryOutput;
        }

        public ItemStack getSecondaryOutput() {
            return this.secondaryOutput;
        }

        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        public int getEnergy() {
            return this.energy;
        }

        public Type getType() {
            return this.type;
        }
    }
}

