/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStack;
import cofh.core.util.helpers.ColorHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.thermalfoundation.block.BlockOreFluid;
import cofh.thermalfoundation.init.TFEquipment;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class PulverizerManager {
    private static Map<ComparableItemStackPulverizer, PulverizerRecipe> recipeMap = new THashMap();
    static final int ORE_MULTIPLIER = 2;
    public static final int DEFAULT_ENERGY = 4000;

    public static PulverizerRecipe getRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackPulverizer query = new ComparableItemStackPulverizer(input);
        PulverizerRecipe recipe = recipeMap.get((Object)query);
        if (recipe == null) {
            query.metadata = Short.MAX_VALUE;
            recipe = recipeMap.get((Object)query);
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input) {
        return PulverizerManager.getRecipe(input) != null;
    }

    public static PulverizerRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new PulverizerRecipe[recipeMap.size()]);
    }

    public static void initialize() {
        int i;
        int energy = 4000;
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150348_b), new ItemStack(Blocks.field_150351_n), new ItemStack((Block)Blocks.field_150354_m), 15);
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150347_e), new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150351_n), 15);
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150351_n), new ItemStack(Items.field_151145_ak), new ItemStack((Block)Blocks.field_150354_m), 15);
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150424_aL), new ItemStack(Blocks.field_150351_n), ItemMaterial.dustSulfur, 15);
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150426_aN), new ItemStack(Items.field_151114_aO, 4));
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_189877_df), new ItemStack(Items.field_151064_bs, 4));
        PulverizerManager.addRecipe(energy / 4, new ItemStack(Blocks.field_150417_aV), new ItemStack(Blocks.field_150417_aV, 1, 2));
        PulverizerManager.addRecipe(energy * 3 / 2, new ItemStack(Blocks.field_150343_Z), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustObsidian, (int)4));
        for (int i2 = 0; i2 < ColorHelper.WOOL_COLOR_CONFIG.length; ++i2) {
            PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_192443_dR, 1, i2), new ItemStack(Blocks.field_192444_dS, 1, i2));
        }
        energy = 2000;
        PulverizerManager.addRecipe(energy, new ItemStack(Items.field_151044_h, 1, 0), ItemMaterial.dustCoal, ItemMaterial.dustSulfur, 15);
        PulverizerManager.addRecipe(energy, new ItemStack(Items.field_151044_h, 1, 1), ItemMaterial.dustCharcoal);
        PulverizerManager.addRecipe(energy, new ItemStack(Items.field_151072_bj), new ItemStack(Items.field_151065_br, 4), ItemMaterial.dustSulfur, 50);
        PulverizerManager.addRecipe(energy, ItemMaterial.rodBlizz, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBlizz, (int)4), new ItemStack(Items.field_151126_ay), 50);
        PulverizerManager.addRecipe(energy, ItemMaterial.rodBlitz, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBlitz, (int)4), ItemMaterial.dustNiter, 50);
        PulverizerManager.addRecipe(energy, ItemMaterial.rodBasalz, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBasalz, (int)4), ItemMaterial.dustObsidian, 50);
        energy = 2000;
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150364_r), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)8));
        PulverizerManager.addRecipe(energy / 4, new ItemStack(Blocks.field_150344_f), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
        PulverizerManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150327_N), new ItemStack(Items.field_151100_aR, 4, 11));
        PulverizerManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150328_O, 1, 0), new ItemStack(Items.field_151100_aR, 4, 1));
        PulverizerManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150328_O, 1, 1), new ItemStack(Items.field_151100_aR, 4, 12));
        PulverizerManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150328_O, 1, 2), new ItemStack(Items.field_151100_aR, 4, 13));
        PulverizerManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150328_O, 1, 3), new ItemStack(Items.field_151100_aR, 4, 7));
        PulverizerManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150328_O, 1, 4), new ItemStack(Items.field_151100_aR, 4, 1));
        PulverizerManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150328_O, 1, 5), new ItemStack(Items.field_151100_aR, 4, 14));
        PulverizerManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150328_O, 1, 6), new ItemStack(Items.field_151100_aR, 4, 7));
        PulverizerManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150328_O, 1, 7), new ItemStack(Items.field_151100_aR, 4, 9));
        PulverizerManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150328_O, 1, 8), new ItemStack(Items.field_151100_aR, 4, 7));
        PulverizerManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150398_cm, 1, 0), new ItemStack(Items.field_151100_aR, 8, 11));
        PulverizerManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150398_cm, 1, 1), new ItemStack(Items.field_151100_aR, 8, 13));
        PulverizerManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150398_cm, 1, 4), new ItemStack(Items.field_151100_aR, 8, 1));
        PulverizerManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150398_cm, 1, 5), new ItemStack(Items.field_151100_aR, 8, 9));
        PulverizerManager.addRecipe(energy, new ItemStack(Items.field_151120_aE), new ItemStack(Items.field_151102_aT, 2));
        energy = 3000;
        int[] dyeChance = new int[ColorHelper.WOOL_COLOR_CONFIG.length];
        for (int i3 = 0; i3 < ColorHelper.WOOL_COLOR_CONFIG.length; ++i3) {
            dyeChance[i3] = 15;
        }
        dyeChance[EnumDyeColor.WHITE.func_176765_a()] = 0;
        dyeChance[EnumDyeColor.BROWN.func_176765_a()] = 0;
        dyeChance[EnumDyeColor.BLUE.func_176765_a()] = 0;
        dyeChance[EnumDyeColor.BLACK.func_176765_a()] = 0;
        ItemStack stringStack = ItemHelper.cloneStack((Item)Items.field_151007_F, (int)4);
        for (int i4 = 0; i4 < ColorHelper.WOOL_COLOR_CONFIG.length; ++i4) {
            if (dyeChance[i4] > 0) {
                PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150325_L, 1, i4), stringStack, new ItemStack(Items.field_151100_aR, 1, 15 - i4), dyeChance[i4]);
                continue;
            }
            PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150325_L, 1, i4), stringStack);
        }
        PulverizerManager.addRecipe(energy, new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151100_aR, 6, 15));
        energy = 4000;
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150365_q), new ItemStack(Items.field_151044_h, 3, 0), ItemMaterial.dustCoal, 25);
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150482_ag), new ItemStack(Items.field_151045_i, 2, 0));
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150412_bA), new ItemStack(Items.field_151166_bC, 2, 0));
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150369_x), new ItemStack(Items.field_151100_aR, 12, 4), ItemMaterial.dustSulfur, 20);
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150450_ax), new ItemStack(Items.field_151137_ax, 6), ItemMaterial.crystalCinnabar, 25);
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150449_bY), new ItemStack(Items.field_151128_bU, 3), ItemMaterial.dustSulfur, 15);
        PulverizerManager.addOreToDustRecipe(energy, "oreIron", ItemMaterial.dustIron, ItemMaterial.dustNickel, 10);
        PulverizerManager.addOreToDustRecipe(energy, "oreGold", ItemMaterial.dustGold, ItemMaterial.crystalCinnabar, 5);
        PulverizerManager.addOreToDustRecipe(energy, "oreCopper", ItemMaterial.dustCopper, ItemMaterial.dustGold, 10);
        PulverizerManager.addOreToDustRecipe(energy, "oreTin", ItemMaterial.dustTin, ItemMaterial.dustIron, 10);
        PulverizerManager.addOreToDustRecipe(energy, "oreSilver", ItemMaterial.dustSilver, ItemMaterial.dustLead, 10);
        PulverizerManager.addOreToDustRecipe(energy, "oreAluminum", ItemMaterial.dustAluminum, ItemMaterial.dustIron, 10);
        PulverizerManager.addOreToDustRecipe(energy, "oreLead", ItemMaterial.dustLead, ItemMaterial.dustSilver, 10);
        PulverizerManager.addOreToDustRecipe(energy, "oreNickel", ItemMaterial.dustNickel, ItemMaterial.dustPlatinum, 10);
        PulverizerManager.addOreToDustRecipe(energy, "orePlatinum", ItemMaterial.dustPlatinum, ItemMaterial.dustIridium, 5);
        PulverizerManager.addOreToDustRecipe(energy, "oreIridium", ItemMaterial.dustIridium, ItemMaterial.dustPlatinum, 10);
        PulverizerManager.addOreToDustRecipe(energy, "oreMithril", ItemMaterial.dustMithril, ItemMaterial.dustGold, 10);
        PulverizerManager.addRecipe(energy, BlockOreFluid.oreFluidCrudeOilSand, ItemHelper.cloneStack((ItemStack)ItemMaterial.crystalCrudeOil, (int)3), ItemMaterial.globTar, 50);
        PulverizerManager.addRecipe(energy, BlockOreFluid.oreFluidCrudeOilGravel, ItemHelper.cloneStack((ItemStack)ItemMaterial.crystalCrudeOil, (int)3), new ItemStack(Items.field_151145_ak), 50);
        PulverizerManager.addRecipe(energy, BlockOreFluid.oreFluidRedstone, ItemHelper.cloneStack((ItemStack)ItemMaterial.crystalRedstone, (int)3), ItemMaterial.crystalCinnabar, 50);
        PulverizerManager.addRecipe(energy, BlockOreFluid.oreFluidGlowstone, ItemHelper.cloneStack((ItemStack)ItemMaterial.crystalGlowstone, (int)3), ItemMaterial.dustSulfur, 30);
        PulverizerManager.addRecipe(energy, BlockOreFluid.oreFluidEnder, ItemHelper.cloneStack((ItemStack)ItemMaterial.crystalEnder, (int)3));
        energy = 2000;
        PulverizerManager.addIngotToDustRecipe(energy, "ingotIron", ItemMaterial.dustIron);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotGold", ItemMaterial.dustGold);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotCopper", ItemMaterial.dustCopper);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotTin", ItemMaterial.dustTin);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotSilver", ItemMaterial.dustSilver);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotLead", ItemMaterial.dustLead);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotAluminum", ItemMaterial.dustAluminum);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotNickel", ItemMaterial.dustNickel);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotPlatinum", ItemMaterial.dustPlatinum);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotIridium", ItemMaterial.dustIridium);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotMithril", ItemMaterial.dustMithril);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotSteel", ItemMaterial.dustSteel);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotElectrum", ItemMaterial.dustElectrum);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotInvar", ItemMaterial.dustInvar);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotBronze", ItemMaterial.dustBronze);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotSignalum", ItemMaterial.dustSignalum);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotLumium", ItemMaterial.dustLumium);
        PulverizerManager.addIngotToDustRecipe(energy, "ingotEnderium", ItemMaterial.dustEnderium);
        energy = 3000;
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150359_w), new ItemStack((Block)Blocks.field_150354_m));
        for (i = 0; i < 15; ++i) {
            PulverizerManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150399_cn, 1, i), new ItemStack((Block)Blocks.field_150354_m));
        }
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150379_bu), new ItemStack(Items.field_151137_ax, 4), new ItemStack(Items.field_151114_aO, 2));
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150336_V), new ItemStack(Items.field_151118_aC, 4));
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150385_bj), new ItemStack(Items.field_151130_bT, 4));
        for (i = 0; i < 3; ++i) {
            PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150371_ca, 1, i), new ItemStack(Items.field_151128_bU, 4));
            PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150322_A, 1, i), new ItemStack((Block)Blocks.field_150354_m, 2), ItemMaterial.dustNiter, 40);
            PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_180395_cM, 1, i), new ItemStack((Block)Blocks.field_150354_m, 2, 1), ItemMaterial.dustNiter, 40);
        }
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150389_bf), new ItemStack(Items.field_151118_aC, 3));
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150387_bl), new ItemStack(Items.field_151130_bT, 3));
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150370_cb), new ItemStack(Items.field_151128_bU, 3));
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_150372_bz), new ItemStack((Block)Blocks.field_150354_m, 2), ItemMaterial.dustNiter, 20);
        PulverizerManager.addRecipe(energy, new ItemStack(Blocks.field_180396_cN), new ItemStack((Block)Blocks.field_150354_m, 2, 1), ItemMaterial.dustNiter, 20);
        PulverizerManager.addRecipe(energy / 2, new ItemStack((Block)Blocks.field_150333_U, 1, 4), new ItemStack(Items.field_151118_aC, 2));
        PulverizerManager.addRecipe(energy / 2, new ItemStack((Block)Blocks.field_150333_U, 1, 6), new ItemStack(Items.field_151130_bT, 2));
        PulverizerManager.addRecipe(energy / 2, new ItemStack((Block)Blocks.field_150333_U, 1, 7), new ItemStack(Items.field_151128_bU, 2));
        PulverizerManager.addRecipe(energy / 2, new ItemStack((Block)Blocks.field_150333_U, 1, 1), new ItemStack((Block)Blocks.field_150354_m, 1), ItemMaterial.dustNiter, 20);
        PulverizerManager.addRecipe(energy / 2, new ItemStack((Block)Blocks.field_180389_cP, 1, 0), new ItemStack((Block)Blocks.field_150354_m, 1, 1), ItemMaterial.dustNiter, 20);
        PulverizerManager.addRecipe(energy / 2, new ItemStack(Items.field_151162_bE), new ItemStack(Items.field_151118_aC, 3));
        PulverizerManager.addRecipe(energy / 2, new ItemStack(Items.field_151069_bo), new ItemStack((Block)Blocks.field_150354_m, 1));
        energy = 6000;
        PulverizerManager.addRecipe(energy, new ItemStack(Items.field_151048_u), new ItemStack(Items.field_151045_i, 2));
        PulverizerManager.addRecipe(energy, new ItemStack(Items.field_151046_w), new ItemStack(Items.field_151045_i, 3));
        PulverizerManager.addRecipe(energy, new ItemStack(Items.field_151056_x), new ItemStack(Items.field_151045_i, 3));
        PulverizerManager.addRecipe(energy, new ItemStack(Items.field_151047_v), new ItemStack(Items.field_151045_i, 1));
        PulverizerManager.addRecipe(energy, new ItemStack(Items.field_151012_L), new ItemStack(Items.field_151045_i, 2));
        PulverizerManager.addRecipe(energy, new ItemStack((Item)Items.field_151161_ac), new ItemStack(Items.field_151045_i, 5));
        PulverizerManager.addRecipe(energy, new ItemStack((Item)Items.field_151163_ad), new ItemStack(Items.field_151045_i, 8));
        PulverizerManager.addRecipe(energy, new ItemStack((Item)Items.field_151173_ae), new ItemStack(Items.field_151045_i, 7));
        PulverizerManager.addRecipe(energy, new ItemStack((Item)Items.field_151175_af), new ItemStack(Items.field_151045_i, 4));
        PulverizerManager.addRecipe(energy, new ItemStack(Items.field_151125_bZ), new ItemStack(Items.field_151045_i, 8));
        PulverizerManager.addRecipe(energy, TFEquipment.ToolSetVanilla.DIAMOND.toolBow, new ItemStack(Items.field_151045_i, 2));
        PulverizerManager.addRecipe(energy, TFEquipment.ToolSetVanilla.DIAMOND.toolFishingRod, new ItemStack(Items.field_151045_i, 2));
        PulverizerManager.addRecipe(energy, TFEquipment.ToolSetVanilla.DIAMOND.toolShears, new ItemStack(Items.field_151045_i, 2));
        PulverizerManager.addRecipe(energy, TFEquipment.ToolSetVanilla.DIAMOND.toolSickle, new ItemStack(Items.field_151045_i, 3));
        PulverizerManager.addRecipe(energy, TFEquipment.ToolSetVanilla.DIAMOND.toolHammer, new ItemStack(Items.field_151045_i, 5));
        PulverizerManager.addRecipe(energy, TFEquipment.ToolSetVanilla.DIAMOND.toolShield, new ItemStack(Items.field_151045_i, 6));
        PulverizerManager.loadRecipes();
    }

    public static void loadRecipes() {
        String[] oreNames;
        if (ItemHelper.oreNameExists((String)"oreCertusQuartz") && ItemHelper.oreNameExists((String)"dustCertusQuartz") && ItemHelper.oreNameExists((String)"crystalCertusQuartz")) {
            PulverizerManager.addRecipe(4000, (ItemStack)OreDictionary.getOres((String)"oreCertusQuartz", (boolean)false).get(0), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"crystalCertusQuartz", (boolean)false).get(0)), (int)2), (ItemStack)OreDictionary.getOres((String)"dustCertusQuartz", (boolean)false).get(0), 10);
            PulverizerManager.addRecipe(4000, (ItemStack)OreDictionary.getOres((String)"crystalCertusQuartz", (boolean)false).get(0), (ItemStack)OreDictionary.getOres((String)"dustCertusQuartz", (boolean)false).get(0));
        }
        if (ItemHelper.oreNameExists((String)"dustFluix") && ItemHelper.oreNameExists((String)"crystalFluix")) {
            PulverizerManager.addRecipe(4000, (ItemStack)OreDictionary.getOres((String)"crystalFluix", (boolean)false).get(0), (ItemStack)OreDictionary.getOres((String)"dustFluix", (boolean)false).get(0));
        }
        if (ItemHelper.oreNameExists((String)"dustNetherQuartz")) {
            PulverizerManager.addRecipe(4000, new ItemStack(Items.field_151128_bU, 1), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"dustNetherQuartz", (boolean)false).get(0)), (int)1));
        }
        if (ItemHelper.oreNameExists((String)"oreApatite") && ItemHelper.oreNameExists((String)"gemApatite")) {
            PulverizerManager.addRecipe(4000, (ItemStack)OreDictionary.getOres((String)"oreApatite", (boolean)false).get(0), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"gemApatite", (boolean)false).get(0)), (int)12), ItemMaterial.dustSulfur, 10);
        }
        if (ItemHelper.oreNameExists((String)"oreNiter")) {
            PulverizerManager.addRecipe(4000, (ItemStack)OreDictionary.getOres((String)"oreNiter", (boolean)false).get(0), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustNiter, (int)4));
        }
        if (ItemHelper.oreNameExists((String)"oreSaltpeter")) {
            PulverizerManager.addRecipe(4000, (ItemStack)OreDictionary.getOres((String)"oreSaltpeter", (boolean)false).get(0), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustNiter, (int)4));
        }
        if (ItemHelper.oreNameExists((String)"oreSulfur")) {
            PulverizerManager.addRecipe(4000, (ItemStack)OreDictionary.getOres((String)"oreSulfur", (boolean)false).get(0), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSulfur, (int)6));
        }
        for (String oreName : oreNames = OreDictionary.getOreNames()) {
            String oreType;
            if (oreName.startsWith("ore")) {
                oreType = oreName.substring(3, oreName.length());
                PulverizerManager.addDefaultOreDictionaryRecipe(oreType);
                continue;
            }
            if (oreName.startsWith("dust")) {
                oreType = oreName.substring(4, oreName.length());
                PulverizerManager.addDefaultOreDictionaryRecipe(oreType);
                continue;
            }
            if (!oreName.startsWith("gem")) continue;
            oreType = oreName.substring(3, oreName.length());
            PulverizerManager.addDefaultOreDictionaryRecipeGem(oreType);
        }
    }

    public static void refresh() {
        THashMap tempMap = new THashMap(recipeMap.size());
        for (Map.Entry<ComparableItemStackPulverizer, PulverizerRecipe> entry : recipeMap.entrySet()) {
            PulverizerRecipe tempRecipe = entry.getValue();
            tempMap.put(new ComparableItemStackPulverizer(tempRecipe.input), tempRecipe);
        }
        recipeMap.clear();
        recipeMap = tempMap;
    }

    public static PulverizerRecipe addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input.func_190926_b() || primaryOutput.func_190926_b() || energy <= 0 || PulverizerManager.recipeExists(input)) {
            return null;
        }
        PulverizerRecipe recipe = new PulverizerRecipe(input, primaryOutput, secondaryOutput, secondaryOutput.func_190926_b() ? 0 : secondaryChance, energy);
        recipeMap.put(new ComparableItemStackPulverizer(input), recipe);
        return recipe;
    }

    public static PulverizerRecipe addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return PulverizerManager.addRecipe(energy, input, primaryOutput, secondaryOutput, 100);
    }

    public static PulverizerRecipe addRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        return PulverizerManager.addRecipe(energy, input, primaryOutput, ItemStack.field_190927_a, 0);
    }

    public static PulverizerRecipe removeRecipe(ItemStack input) {
        return recipeMap.remove((Object)new ComparableItemStackPulverizer(input));
    }

    private static void addDefaultOreDictionaryRecipe(String oreType) {
        PulverizerManager.addDefaultOreDictionaryRecipe(oreType, "");
    }

    private static void addDefaultOreDictionaryRecipe(String oreType, String relatedType) {
        ItemStack related;
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String oreName = "ore" + StringHelper.titleCase((String)oreType);
        String dustName = "dust" + StringHelper.titleCase((String)oreType);
        String ingotName = "ingot" + StringHelper.titleCase((String)oreType);
        String clusterName = "cluster" + StringHelper.titleCase((String)oreType);
        String relatedName = null;
        NonNullList registeredOre = OreDictionary.getOres((String)oreName, (boolean)false);
        NonNullList registeredDust = OreDictionary.getOres((String)dustName, (boolean)false);
        NonNullList registeredIngot = OreDictionary.getOres((String)ingotName, (boolean)false);
        NonNullList registeredCluster = OreDictionary.getOres((String)clusterName, (boolean)false);
        NonNullList registeredRelated = new ArrayList();
        if (!relatedType.isEmpty()) {
            relatedName = "dust" + StringHelper.titleCase((String)relatedType);
            registeredRelated = OreDictionary.getOres((String)relatedName, (boolean)false);
        }
        if (registeredDust.isEmpty()) {
            return;
        }
        ItemStack dust = (ItemStack)registeredDust.get(0);
        if (registeredIngot.isEmpty()) {
            ingotName = null;
        }
        if (registeredOre.isEmpty()) {
            oreName = null;
        }
        if (registeredCluster.isEmpty()) {
            clusterName = null;
        }
        if ((related = ItemStack.field_190927_a).func_190926_b() && !registeredRelated.isEmpty()) {
            related = (ItemStack)registeredRelated.get(0);
        }
        PulverizerManager.addOreToDustRecipe(4000, oreName, ItemHelper.cloneStack((ItemStack)dust, (int)2), related, related.func_190926_b() ? 0 : 5);
        PulverizerManager.addOreToDustRecipe(4800, clusterName, ItemHelper.cloneStack((ItemStack)dust, (int)2), related, related.func_190926_b() ? 0 : 5);
        PulverizerManager.addIngotToDustRecipe(2400, ingotName, ItemHelper.cloneStack((ItemStack)dust, (int)1));
    }

    private static void addDefaultOreDictionaryRecipeGem(String oreType) {
        PulverizerManager.addDefaultOreDictionaryRecipeGem(oreType, "");
    }

    private static void addDefaultOreDictionaryRecipeGem(String oreType, String relatedType) {
        ItemStack related;
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String oreName = "ore" + StringHelper.titleCase((String)oreType);
        String dustName = "dust" + StringHelper.titleCase((String)oreType);
        String gemName = "gem" + StringHelper.titleCase((String)oreType);
        String relatedName = null;
        NonNullList registeredOre = OreDictionary.getOres((String)oreName, (boolean)false);
        NonNullList registeredDust = OreDictionary.getOres((String)dustName, (boolean)false);
        NonNullList registeredGem = OreDictionary.getOres((String)gemName, (boolean)false);
        NonNullList registeredRelated = new ArrayList();
        String clusterName = "cluster" + StringHelper.titleCase((String)oreType);
        NonNullList registeredCluster = OreDictionary.getOres((String)clusterName, (boolean)false);
        if (!relatedType.isEmpty()) {
            relatedName = "dust" + StringHelper.titleCase((String)relatedType);
            registeredRelated = OreDictionary.getOres((String)relatedName, (boolean)false);
        }
        if (registeredGem.isEmpty()) {
            return;
        }
        ItemStack gem = (ItemStack)registeredGem.get(0);
        ItemStack dust = ItemStack.field_190927_a;
        if (!registeredDust.isEmpty()) {
            dust = (ItemStack)registeredDust.get(0);
        }
        if (registeredOre.isEmpty()) {
            oreName = null;
        }
        if (registeredCluster.isEmpty()) {
            clusterName = null;
        }
        if ((related = ItemStack.field_190927_a).func_190926_b() && !registeredRelated.isEmpty()) {
            related = (ItemStack)registeredRelated.get(0);
        }
        PulverizerManager.addOreToDustRecipe(4000, oreName, ItemHelper.cloneStack((ItemStack)gem, (int)2), related, related.func_190926_b() ? 0 : 5);
        PulverizerManager.addOreToDustRecipe(5000, clusterName, ItemHelper.cloneStack((ItemStack)gem, (int)2), related, related.func_190926_b() ? 0 : 5);
        PulverizerManager.addIngotToDustRecipe(3000, gemName, ItemHelper.cloneStack((ItemStack)dust, (int)1));
    }

    private static void addOreToDustRecipe(int energy, String oreName, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryOutput.func_190926_b() || oreName == null) {
            return;
        }
        NonNullList registeredOres = OreDictionary.getOres((String)oreName, (boolean)false);
        if (!registeredOres.isEmpty() && !PulverizerManager.recipeExists((ItemStack)OreDictionary.getOres((String)oreName, (boolean)false).get(0))) {
            PulverizerManager.addRecipe(energy, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredOres.get(0)), (int)1), ItemHelper.cloneStack((ItemStack)primaryOutput, (int)2), secondaryOutput, secondaryChance);
        }
    }

    private static void addIngotToDustRecipe(int energy, String ingotName, ItemStack dust) {
        if (dust.func_190926_b() || ingotName == null) {
            return;
        }
        NonNullList registeredOres = OreDictionary.getOres((String)ingotName, (boolean)false);
        if (!registeredOres.isEmpty() && !PulverizerManager.recipeExists((ItemStack)OreDictionary.getOres((String)ingotName, (boolean)false).get(0))) {
            PulverizerManager.addRecipe(energy, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredOres.get(0)), (int)1), dust, ItemStack.field_190927_a, 0);
        }
    }

    public static class ComparableItemStackPulverizer
    extends ComparableItemStack {
        public static final String ORE = "ore";
        public static final String INGOT = "ingot";
        public static final String NUGGET = "nugget";
        public static final String PLANK = "plank";
        public static final String LOG = "log";
        public static final String SAND = "sand";

        public static boolean safeOreType(String oreName) {
            return oreName.startsWith(ORE) || oreName.startsWith(INGOT) || oreName.startsWith(NUGGET) || oreName.startsWith(PLANK) || oreName.startsWith(LOG) || oreName.equals(SAND);
        }

        public static int getOreID(ItemStack stack) {
            ArrayList ids = OreDictionaryArbiter.getAllOreIDs((ItemStack)stack);
            if (ids != null) {
                for (Integer id : ids) {
                    if (id == -1 || !ComparableItemStackPulverizer.safeOreType(ItemHelper.oreProxy.getOreName(id.intValue()))) continue;
                    return id;
                }
            }
            return -1;
        }

        public ComparableItemStackPulverizer(ItemStack stack) {
            super(stack);
            this.oreID = ComparableItemStackPulverizer.getOreID(stack);
        }

        public ComparableItemStackPulverizer set(ItemStack stack) {
            super.set(stack);
            this.oreID = ComparableItemStackPulverizer.getOreID(stack);
            return this;
        }
    }

    public static class PulverizerRecipe {
        final ItemStack input;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        PulverizerRecipe(ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, int energy) {
            this.input = input;
            this.primaryOutput = primaryOutput;
            this.secondaryOutput = secondaryOutput;
            this.secondaryChance = secondaryChance;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getPrimaryOutput() {
            return this.primaryOutput;
        }

        public ItemStack getSecondaryOutput() {
            return this.secondaryOutput;
        }

        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

