/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.TIntObjectHashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class RefineryManager {
    private static TIntObjectHashMap<RefineryRecipe> recipeMap = new TIntObjectHashMap();
    public static final int DEFAULT_ENERGY = 5000;

    public static RefineryRecipe getRecipe(FluidStack input) {
        return input == null ? null : (RefineryRecipe)recipeMap.get(input.getFluid().getName().hashCode());
    }

    public static boolean recipeExists(FluidStack input) {
        return RefineryManager.getRecipe(input) != null;
    }

    public static RefineryRecipe[] getRecipeList() {
        return (RefineryRecipe[])recipeMap.values((Object[])new RefineryRecipe[recipeMap.size()]);
    }

    public static void initialize() {
        int energy = 5000;
        RefineryManager.addRecipe(energy, new FluidStack(TFFluids.fluidCoal, 100), new FluidStack(TFFluids.fluidRefinedOil, 50), ItemMaterial.globTar, 75);
        RefineryManager.addRecipe(energy, new FluidStack(TFFluids.fluidCrudeOil, 100), new FluidStack(TFFluids.fluidRefinedOil, 100), ItemMaterial.globTar, 50);
        RefineryManager.addRecipe(energy, new FluidStack(TFFluids.fluidRefinedOil, 100), new FluidStack(TFFluids.fluidFuel, 100), ItemMaterial.dustSulfur, 50);
        energy = 2500;
        RefineryManager.addRecipe(energy, new FluidStack(TFFluids.fluidResin, 100), new FluidStack(TFFluids.fluidTreeOil, 50), ItemMaterial.globRosin, 75);
        RefineryManager.loadRecipes();
    }

    public static void loadRecipes() {
        Fluid oil = FluidRegistry.getFluid((String)"oil");
        if (oil != null) {
            RefineryManager.addRecipe(5000, new FluidStack(oil, 100), new FluidStack(TFFluids.fluidRefinedOil, 100), ItemMaterial.globTar, 50);
        }
    }

    public static void refresh() {
    }

    public static RefineryRecipe addRecipe(int energy, FluidStack input, FluidStack outputFluid, ItemStack outputItem, int chance) {
        if (input == null || outputFluid == null || energy <= 0 || RefineryManager.recipeExists(input)) {
            return null;
        }
        RefineryRecipe recipe = new RefineryRecipe(input, outputFluid, outputItem, energy, chance);
        recipeMap.put(input.getFluid().getName().hashCode(), (Object)recipe);
        return recipe;
    }

    public static RefineryRecipe addRecipe(int energy, FluidStack input, FluidStack outputFluid, ItemStack outputItem) {
        return RefineryManager.addRecipe(energy, input, outputFluid, outputItem, 100);
    }

    public static RefineryRecipe addRecipe(int energy, FluidStack input, FluidStack outputFluid) {
        return RefineryManager.addRecipe(energy, input, outputFluid, ItemStack.field_190927_a, 0);
    }

    public static RefineryRecipe removeRecipe(FluidStack input) {
        if (input == null) {
            return null;
        }
        return (RefineryRecipe)recipeMap.remove(input.getFluid().getName().hashCode());
    }

    public static class RefineryRecipe {
        final FluidStack input;
        final FluidStack outputFluid;
        final ItemStack outputItem;
        final int energy;
        final int chance;

        RefineryRecipe(FluidStack input, FluidStack outputFluid, ItemStack outputItem, int energy, int chance) {
            this.input = input;
            this.outputFluid = outputFluid;
            this.outputItem = outputItem;
            this.energy = energy;
            this.chance = chance;
        }

        public FluidStack getInput() {
            return this.input;
        }

        public FluidStack getOutputFluid() {
            return this.outputFluid;
        }

        public ItemStack getOutputItem() {
            return this.outputItem;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getChance() {
            return this.chance;
        }
    }
}

