/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler;

import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.network.NetworkHandler;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.exosuit.IPsiEventArmor;
import vazkii.psi.api.exosuit.PsiArmorEvent;
import vazkii.psi.api.internal.IPlayerData;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.ISpellContainer;
import vazkii.psi.api.spell.PieceGroup;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.core.handler.ClientTickHandler;
import vazkii.psi.client.render.entity.RenderSpellCircle;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.network.message.MessageDataSync;
import vazkii.psi.common.network.message.MessageDeductPsi;
import vazkii.psi.common.network.message.MessageLevelUp;

public class PlayerDataHandler {
    private static HashMap<Integer, PlayerData> playerData = new HashMap();
    public static Set<SpellContext> delayedContexts = new HashSet<SpellContext>();
    private static final String DATA_TAG = "PsiData";
    public static final DamageSource damageSourceOverload = new DamageSource("psi-overload").func_76348_h().func_82726_p();

    public static PlayerData get(EntityPlayer player) {
        int key = PlayerDataHandler.getKey(player);
        if (!playerData.containsKey(key)) {
            playerData.put(key, new PlayerData(player));
        }
        PlayerData data = playerData.get(key);
        if (data.playerWR.get() != player) {
            NBTTagCompound cmp = new NBTTagCompound();
            data.writeToNBT(cmp);
            playerData.remove(key);
            data = PlayerDataHandler.get(player);
            data.readFromNBT(cmp);
        }
        return data;
    }

    public static void cleanup() {
        ArrayList<Integer> removals = new ArrayList<Integer>();
        for (Map.Entry<Integer, PlayerData> item : playerData.entrySet()) {
            PlayerData d = item.getValue();
            if (d == null || d.playerWR.get() != null) continue;
            removals.add(item.getKey());
        }
        Iterator iterator = removals.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            playerData.remove(i);
        }
    }

    private static int getKey(EntityPlayer player) {
        return player.hashCode() << 1 + (player.func_130014_f_().field_72995_K ? 1 : 0);
    }

    public static NBTTagCompound getDataCompoundForPlayer(EntityPlayer player) {
        NBTTagCompound persistentData;
        NBTTagCompound forgeData = player.getEntityData();
        if (!forgeData.func_74764_b("PlayerPersisted")) {
            forgeData.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        if (!(persistentData = forgeData.func_74775_l("PlayerPersisted")).func_74764_b(DATA_TAG)) {
            persistentData.func_74782_a(DATA_TAG, (NBTBase)new NBTTagCompound());
        }
        return persistentData.func_74775_l(DATA_TAG);
    }

    public static class PlayerData
    implements IPlayerData {
        private static final String TAG_LEVEL = "level";
        private static final String TAG_AVAILABLE_PSI = "availablePsi";
        private static final String TAG_REGEN_CD = "regenCd";
        private static final String TAG_SPELL_GROUPS_UNLOCKED = "spellGroupsUnlocked";
        private static final String TAG_LAST_SPELL_GROUP = "lastSpellPoint";
        private static final String TAG_LEVEL_POINTS = "levelPoints";
        private static final String TAG_EIDOS_ANCHOR_X = "eidosAnchorX";
        private static final String TAG_EIDOS_ANCHOR_Y = "eidosAnchorY";
        private static final String TAG_EIDOS_ANCHOR_Z = "eidosAnchorZ";
        private static final String TAG_EIDOS_ANCHOR_PITCH = "eidosAnchorPitch";
        private static final String TAG_EIDOS_ANCHOR_YAW = "eidosAnchorYaw";
        private static final String TAG_EIDOS_ANCHOR_TIME = "eidosAnchorTime";
        public int level;
        public int availablePsi;
        public int lastAvailablePsi;
        public int regenCooldown;
        public String lastSpellGroup;
        public int levelPoints;
        public boolean loopcasting = false;
        public int loopcastTime = 0;
        public int loopcastAmount = 0;
        public int loopcastFadeTime = 0;
        public Stack<Vector3> eidosChangelog = new Stack();
        public Vector3 eidosAnchor = new Vector3(0.0, 0.0, 0.0);
        public double eidosAnchorPitch;
        public double eidosAnchorYaw;
        public boolean isAnchored;
        public boolean isReverting;
        public int eidosAnchorTime;
        public int postAnchorRecallTime;
        public int eidosReversionTime;
        public int lastDimension;
        boolean lowLight;
        boolean underwater;
        boolean lowHp;
        public boolean deductTick;
        public final List<String> spellGroupsUnlocked = new ArrayList<String>();
        public final List<Deduction> deductions = new ArrayList<Deduction>();
        public WeakReference<EntityPlayer> playerWR;
        private final boolean client;

        public PlayerData(EntityPlayer player) {
            this.playerWR = new WeakReference<EntityPlayer>(player);
            this.client = player.func_130014_f_().field_72995_K;
            this.load();
        }

        /*
         * Unable to fully structure code
         */
        public void tick() {
            block45: {
                block43: {
                    block44: {
                        dimension = ((EntityPlayer)this.playerWR.get()).func_130014_f_().field_73011_w.getDimension();
                        if (this.deductTick) {
                            this.deductTick = false;
                        } else {
                            this.lastAvailablePsi = this.availablePsi;
                        }
                        max = this.getTotalPsi();
                        if (this.availablePsi > max) {
                            this.availablePsi = max;
                        }
                        player = (EntityPlayer)this.playerWR.get();
                        cadStack = this.getCAD();
                        if (this.regenCooldown == 0) {
                            doRegen = true;
                            if (!cadStack.func_190926_b()) {
                                cad = (ICAD)cadStack.func_77973_b();
                                maxPsi = cad.getStatValue(cadStack, EnumCADStat.OVERFLOW);
                                currPsi = cad.getStoredPsi(cadStack);
                                if (currPsi < maxPsi) {
                                    cad.regenPsi(cadStack, Math.max(1, this.getRegenPerTick() / 2));
                                    doRegen = false;
                                }
                            }
                            if (doRegen && this.availablePsi < max && this.regenCooldown == 0) {
                                this.availablePsi = Math.min(max, this.availablePsi + this.getRegenPerTick());
                                this.save();
                            }
                        } else {
                            --this.regenCooldown;
                            this.save();
                        }
                        cadStack = this.getCAD();
                        icad = null;
                        color = new Color(1295871);
                        if (!cadStack.func_190926_b()) {
                            icad = (ICAD)cadStack.func_77973_b();
                            color = Psi.proxy.getCADColor(cadStack);
                        }
                        r = (float)color.getRed() / 255.0f;
                        g = (float)color.getGreen() / 255.0f;
                        b = (float)color.getBlue() / 255.0f;
                        if (!this.loopcasting) break block43;
                        if (player != null && !cadStack.func_190926_b() && (player.func_184614_ca() == cadStack || player.func_184592_cb() == cadStack)) break block44;
                        this.stopLoopcast();
                        break block45;
                    }
                    for (i = 0; i < 5; ++i) {
                        x = player.field_70165_t + (Math.random() - 0.5) * 2.1 * (double)player.field_70130_N;
                        y = player.field_70163_u - player.func_70033_W();
                        z = player.field_70161_v + (Math.random() - 0.5) * 2.1 * (double)player.field_70130_N;
                        grav = -0.15f - (float)Math.random() * 0.03f;
                        Psi.proxy.sparkleFX(player.func_130014_f_(), x, y, z, r, g, b, grav, 0.25f, 15);
                    }
                    if (this.loopcastTime <= 0 || this.loopcastTime % 5 != 0) ** GOTO lbl65
                    bullet = icad.getBulletInSocket(cadStack, icad.getSelectedSlot(cadStack));
                    if (bullet.func_190926_b()) {
                        this.stopLoopcast();
                    } else {
                        spellContainer = (ISpellContainer)bullet.func_77973_b();
                        if (spellContainer.containsSpell(bullet)) {
                            spell = spellContainer.getSpell(bullet);
                            context = new SpellContext().setPlayer(player).setSpell(spell).setLoopcastIndex(this.loopcastAmount + 1);
                            if (context.isValid() && context.cspell.metadata.evaluateAgainst(cadStack)) {
                                cost = ItemCAD.getRealCost(cadStack, bullet, context.cspell.metadata.stats.get((Object)EnumSpellStat.COST));
                                if (cost > 0 || cost == -1) {
                                    if (cost != -1) {
                                        this.deductPsi(cost, 3, true);
                                    }
                                    if (!player.func_130014_f_().field_72995_K && this.loopcastTime % 10 == 0) {
                                        player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70165_t, player.field_70161_v, PsiSoundHandler.loopcast, SoundCategory.PLAYERS, 0.5f, (float)(0.35 + Math.random() * 0.85));
                                    }
                                }
                                context.cspell.safeExecute(context);
                                ++this.loopcastAmount;
                            }
                        }
lbl65:
                        // 6 sources

                        ++this.loopcastTime;
                    }
                    break block45;
                }
                if (this.loopcastFadeTime > 0) {
                    --this.loopcastFadeTime;
                }
            }
            if (player.field_70128_L || dimension != this.lastDimension) {
                this.eidosAnchorTime = 0;
                this.eidosReversionTime = 0;
                this.eidosChangelog.clear();
                this.isAnchored = false;
                this.isReverting = false;
            }
            if (this.eidosAnchorTime > 0) {
                if (this.eidosAnchorTime == 1) {
                    if (player != null && player instanceof EntityPlayerMP) {
                        pmp = (EntityPlayerMP)player;
                        pmp.field_71135_a.func_147364_a(this.eidosAnchor.x, this.eidosAnchor.y, this.eidosAnchor.z, (float)this.eidosAnchorYaw, (float)this.eidosAnchorPitch);
                        for (riding = player.func_184187_bx(); riding != null; riding = riding.func_184187_bx()) {
                            riding.func_70107_b(this.eidosAnchor.x, this.eidosAnchor.y, this.eidosAnchor.z);
                        }
                    }
                    this.postAnchorRecallTime = 0;
                }
                --this.eidosAnchorTime;
            } else if (this.postAnchorRecallTime < 5) {
                --this.postAnchorRecallTime;
                this.isAnchored = false;
            }
            if (this.eidosReversionTime > 0) {
                if (this.eidosChangelog.isEmpty()) {
                    this.eidosReversionTime = 0;
                    this.isReverting = false;
                } else {
                    this.eidosChangelog.pop();
                    if (this.eidosChangelog.isEmpty()) {
                        this.eidosReversionTime = 0;
                        this.isReverting = false;
                    } else {
                        vec = this.eidosChangelog.pop();
                        if (player != null) {
                            if (player instanceof EntityPlayerMP) {
                                pmp = (EntityPlayerMP)player;
                                pmp.field_71135_a.func_175089_a(vec.x, vec.y, vec.z, 0.0f, 0.0f, (Set)ImmutableSet.of((Object)SPacketPlayerPosLook.EnumFlags.X_ROT, (Object)SPacketPlayerPosLook.EnumFlags.Y_ROT));
                            } else {
                                player.field_70165_t = vec.x;
                                player.field_70163_u = vec.y;
                                player.field_70161_v = vec.z;
                            }
                            for (riding = player.func_184187_bx(); riding != null; riding = riding.func_184187_bx()) {
                                riding.func_70107_b(vec.x, vec.y, vec.z);
                            }
                            for (i = 0; i < 5; ++i) {
                                spread = 0.6;
                                x = player.field_70165_t + (Math.random() - 0.5) * spread;
                                y = player.field_70163_u + (Math.random() - 0.5) * spread;
                                z = player.field_70161_v + (Math.random() - 0.5) * spread;
                                Psi.proxy.sparkleFX(player.func_130014_f_(), x, y, z, r, g, b, (float)x, (float)y, (float)z, 1.2f, 12);
                            }
                            player.field_70159_w = 0.0;
                            player.field_70181_x = 0.0;
                            player.field_70179_y = 0.0;
                            player.field_70143_R = 0.0f;
                        }
                    }
                }
                --this.eidosReversionTime;
                if (this.eidosReversionTime == 0 || player.func_70093_af()) {
                    this.eidosChangelog.clear();
                    this.isReverting = false;
                }
            } else {
                if (this.eidosChangelog.size() >= 600) {
                    this.eidosChangelog.remove(0);
                }
                this.eidosChangelog.push(Vector3.fromEntity((Entity)player));
            }
            pos = player.func_180425_c();
            skylight = (int)((float)player.func_130014_f_().func_175642_b(EnumSkyBlock.SKY, pos) * player.func_130014_f_().field_73011_w.getSunBrightnessFactor(1.0f));
            light = Math.max(skylight, blocklight = player.func_130014_f_().func_175642_b(EnumSkyBlock.BLOCK, pos));
            v0 = lowLight = light < 7;
            if (!this.lowLight && lowLight) {
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.lowLight"));
            }
            this.lowLight = lowLight;
            underwater = player.func_70055_a(Material.field_151586_h);
            if (!this.underwater && underwater) {
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.underwater"));
            }
            this.underwater = underwater;
            v1 = lowHp = player.func_110143_aJ() <= 6.0f;
            if (!this.lowHp && lowHp) {
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.lowHp"));
            }
            this.lowHp = lowHp;
            remove = new ArrayList<Deduction>();
            for (Deduction d : this.deductions) {
                if (d.invalid) {
                    remove.add(d);
                    continue;
                }
                d.tick();
            }
            this.deductions.removeAll(remove);
            this.lastDimension = dimension;
        }

        public void stopLoopcast() {
            if (this.loopcasting) {
                this.loopcastFadeTime = 5;
            }
            this.loopcasting = false;
            this.loopcastTime = 0;
            this.loopcastAmount = 0;
        }

        public void damage(float amount) {
            int psi = (int)((double)this.getTotalPsi() * 0.02 * (double)amount);
            if (psi > 0 && this.availablePsi > 0) {
                psi = Math.min(psi, this.availablePsi);
                this.deductPsi(psi, 20, true, true);
            }
        }

        public void skipToLevel(int level) {
            int currLevel = this.level;
            int points = level - currLevel;
            this.level = Math.max(currLevel, Math.min(PsiAPI.levelCap, level));
            this.levelPoints = Math.max(0, Math.max(points, this.levelPoints));
            this.save();
        }

        public void levelUp() {
            EntityPlayer player = (EntityPlayer)this.playerWR.get();
            if (player != null) {
                ++this.level;
                ++this.levelPoints;
                this.lastSpellGroup = "";
                if (player instanceof EntityPlayerMP) {
                    MessageLevelUp message = new MessageLevelUp(this.level);
                    MessageDataSync message2 = new MessageDataSync(this);
                    NetworkHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)player);
                    NetworkHandler.INSTANCE.sendTo((IMessage)message2, (EntityPlayerMP)player);
                    if (this.level == 25) {
                        player.func_145747_a(new TextComponentTranslation("psimisc.softcapIndicator", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
                    }
                }
            }
        }

        public ItemStack getCAD() {
            return PsiAPI.getPlayerCAD((EntityPlayer)this.playerWR.get());
        }

        public void deductPsi(int psi, int cd, boolean sync) {
            this.deductPsi(psi, cd, sync, false);
        }

        @Override
        public void deductPsi(int psi, int cd, boolean sync, boolean shatter) {
            int currentPsi = this.availablePsi;
            this.availablePsi -= psi;
            if (this.regenCooldown < cd) {
                this.regenCooldown = cd;
            }
            if (this.availablePsi < 0) {
                int overflow = -this.availablePsi;
                this.availablePsi = 0;
                ItemStack cadStack = this.getCAD();
                if (!cadStack.func_190926_b()) {
                    ICAD cad = (ICAD)cadStack.func_77973_b();
                    overflow = cad.consumePsi(cadStack, overflow);
                }
                if (!shatter && overflow > 0) {
                    EntityPlayer player;
                    float dmg = (float)overflow / (float)(this.loopcasting ? 50 : 125);
                    if (!this.client && (player = (EntityPlayer)this.playerWR.get()) != null) {
                        player.func_70097_a(damageSourceOverload, dmg);
                    }
                }
            }
            if (sync && this.playerWR.get() instanceof EntityPlayerMP) {
                MessageDeductPsi message = new MessageDeductPsi(currentPsi, this.availablePsi, this.regenCooldown, shatter);
                NetworkHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)this.playerWR.get());
            }
            this.save();
        }

        public void addDeduction(int current, int deduct, boolean shatter) {
            if (deduct > current) {
                deduct = current;
            }
            if (deduct < 0) {
                deduct = 0;
            }
            if (deduct == 0) {
                return;
            }
            this.deductions.add(new Deduction(current, deduct, 20, shatter));
        }

        @Override
        public int getLevel() {
            EntityPlayer player = (EntityPlayer)this.playerWR.get();
            if (player != null && player.field_71075_bZ.field_75098_d) {
                return PsiAPI.levelCap;
            }
            return this.level;
        }

        public int getLevelPoints() {
            return this.levelPoints;
        }

        @Override
        public int getAvailablePsi() {
            return this.availablePsi;
        }

        @Override
        public int getLastAvailablePsi() {
            return this.lastAvailablePsi;
        }

        @Override
        public int getTotalPsi() {
            return Math.min(5000, this.getLevel() * 200);
        }

        @Override
        public int getRegenPerTick() {
            return Math.min(25, this.getLevel());
        }

        @Override
        public int getRegenCooldown() {
            return this.regenCooldown;
        }

        @Override
        public boolean isPieceGroupUnlocked(String group) {
            EntityPlayer player = (EntityPlayer)this.playerWR.get();
            if (player != null && player.field_71075_bZ.field_75098_d) {
                return true;
            }
            return this.spellGroupsUnlocked.contains(group);
        }

        @Override
        public void unlockPieceGroup(String group) {
            if (!this.isPieceGroupUnlocked(group)) {
                this.spellGroupsUnlocked.add(group);
                this.lastSpellGroup = group;
                --this.levelPoints;
                this.save();
            }
        }

        @Override
        public void markPieceExecuted(SpellPiece piece) {
            if (this.lastSpellGroup == null || this.lastSpellGroup.isEmpty() || this.levelPoints != 0) {
                return;
            }
            PieceGroup group = PsiAPI.groupsForName.get(this.lastSpellGroup);
            if (group != null && group.mainPiece == piece.getClass()) {
                this.levelUp();
            }
        }

        public void save() {
            EntityPlayer player;
            if (!this.client && (player = (EntityPlayer)this.playerWR.get()) != null) {
                NBTTagCompound cmp = PlayerDataHandler.getDataCompoundForPlayer(player);
                this.writeToNBT(cmp);
            }
        }

        public void writeToNBT(NBTTagCompound cmp) {
            cmp.func_74768_a(TAG_LEVEL, this.level);
            cmp.func_74768_a(TAG_AVAILABLE_PSI, this.availablePsi);
            cmp.func_74768_a(TAG_REGEN_CD, this.regenCooldown);
            cmp.func_74768_a(TAG_LEVEL_POINTS, this.levelPoints);
            if (this.lastSpellGroup != null && !this.lastSpellGroup.isEmpty()) {
                cmp.func_74778_a(TAG_LAST_SPELL_GROUP, this.lastSpellGroup);
            }
            NBTTagList list = new NBTTagList();
            for (String s : this.spellGroupsUnlocked) {
                if (s == null || s.isEmpty()) continue;
                list.func_74742_a((NBTBase)new NBTTagString(s));
            }
            cmp.func_74782_a(TAG_SPELL_GROUPS_UNLOCKED, (NBTBase)list);
            cmp.func_74780_a(TAG_EIDOS_ANCHOR_X, this.eidosAnchor.x);
            cmp.func_74780_a(TAG_EIDOS_ANCHOR_Y, this.eidosAnchor.y);
            cmp.func_74780_a(TAG_EIDOS_ANCHOR_Z, this.eidosAnchor.z);
            cmp.func_74780_a(TAG_EIDOS_ANCHOR_PITCH, this.eidosAnchorPitch);
            cmp.func_74780_a(TAG_EIDOS_ANCHOR_YAW, this.eidosAnchorYaw);
            cmp.func_74768_a(TAG_EIDOS_ANCHOR_TIME, this.eidosAnchorTime);
        }

        public void load() {
            EntityPlayer player;
            if (!this.client && (player = (EntityPlayer)this.playerWR.get()) != null) {
                NBTTagCompound cmp = PlayerDataHandler.getDataCompoundForPlayer(player);
                this.readFromNBT(cmp);
            }
        }

        public void readFromNBT(NBTTagCompound cmp) {
            this.level = cmp.func_74762_e(TAG_LEVEL);
            this.availablePsi = cmp.func_74762_e(TAG_AVAILABLE_PSI);
            this.regenCooldown = cmp.func_74762_e(TAG_REGEN_CD);
            this.levelPoints = cmp.func_74762_e(TAG_LEVEL_POINTS);
            this.lastSpellGroup = cmp.func_74779_i(TAG_LAST_SPELL_GROUP);
            if (cmp.func_74764_b(TAG_SPELL_GROUPS_UNLOCKED)) {
                this.spellGroupsUnlocked.clear();
                NBTTagList list = cmp.func_150295_c(TAG_SPELL_GROUPS_UNLOCKED, 8);
                int count = list.func_74745_c();
                for (int i = 0; i < count; ++i) {
                    this.spellGroupsUnlocked.add(list.func_150307_f(i));
                }
            }
            double x = cmp.func_74769_h(TAG_EIDOS_ANCHOR_X);
            double y = cmp.func_74769_h(TAG_EIDOS_ANCHOR_X);
            double z = cmp.func_74769_h(TAG_EIDOS_ANCHOR_X);
            this.eidosAnchor.set(x, y, z);
            this.eidosAnchorPitch = cmp.func_74769_h(TAG_EIDOS_ANCHOR_PITCH);
            this.eidosAnchorYaw = cmp.func_74769_h(TAG_EIDOS_ANCHOR_YAW);
            this.eidosAnchorTime = cmp.func_74762_e(TAG_EIDOS_ANCHOR_TIME);
        }

        @SideOnly(value=Side.CLIENT)
        public void render(EntityPlayer player, float partTicks) {
            float mul;
            RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partTicks - renderManager.field_78730_l;
            double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partTicks - renderManager.field_78731_m;
            double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partTicks - renderManager.field_78728_n;
            float scale = 0.75f;
            if (this.loopcasting) {
                mul = Math.min(5.0f, (float)this.loopcastTime + partTicks) / 5.0f;
                scale *= mul;
            } else if (this.loopcastFadeTime > 0) {
                mul = Math.min(5.0f, (float)this.loopcastFadeTime - partTicks) / 5.0f;
                scale *= mul;
            } else {
                return;
            }
            int color = 1295871;
            ItemStack cad = PsiAPI.getPlayerCAD((EntityPlayer)this.playerWR.get());
            if (!cad.func_190926_b() && cad.func_77973_b() instanceof ICAD) {
                ICAD icad = (ICAD)cad.func_77973_b();
                color = icad.getSpellColor(cad);
            }
            RenderSpellCircle.renderSpellCircle((float)ClientTickHandler.ticksInGame + partTicks, scale, x, y, z, color);
        }

        public static class Deduction {
            public final int current;
            public final int deduct;
            public final int cd;
            public final boolean shatter;
            public int elapsed;
            public boolean invalid;

            public Deduction(int current, int deduct, int cd, boolean shatter) {
                this.current = current;
                this.deduct = deduct;
                this.cd = cd;
                this.shatter = shatter;
            }

            public void tick() {
                ++this.elapsed;
                if (this.elapsed >= this.cd) {
                    this.invalid = true;
                }
            }

            public float getPercentile(float partTicks) {
                return 1.0f - Math.min(1.0f, ((float)this.elapsed + partTicks) / (float)this.cd);
            }
        }
    }

    public static class EventHandler {
        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                PlayerDataHandler.cleanup();
                ArrayList<SpellContext> remove = new ArrayList<SpellContext>();
                for (SpellContext context : delayedContexts) {
                    --context.delay;
                    if (context.delay > 0) continue;
                    context.delay = 0;
                    context.cspell.safeExecute(context);
                    if (context.delay != 0) continue;
                    remove.add(context);
                }
                if (!remove.isEmpty()) {
                    delayedContexts.removeAll(remove);
                }
            }
        }

        @SubscribeEvent
        public void onPlayerTick(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                ItemStack cadStack = PsiAPI.getPlayerCAD(player);
                if (!cadStack.func_190926_b() && cadStack.func_77973_b() instanceof ICAD) {
                    ((ICAD)cadStack.func_77973_b()).incrementTime(cadStack);
                }
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.tick"));
                PlayerDataHandler.get(player).tick();
            }
        }

        @SubscribeEvent
        public void onEntityDamage(LivingHurtEvent event) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                PlayerDataHandler.get(player).damage(event.getAmount());
                EntityLivingBase attacker = null;
                if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase) {
                    attacker = (EntityLivingBase)event.getSource().func_76346_g();
                }
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.damage", event.getAmount(), attacker));
                if (event.getSource().func_76347_k()) {
                    PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.onFire"));
                }
            }
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.player instanceof EntityPlayerMP) {
                MessageDataSync message = new MessageDataSync(PlayerDataHandler.get(event.player));
                NetworkHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)event.player);
            }
        }

        @SubscribeEvent
        public void onEntityJump(LivingEvent.LivingJumpEvent event) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.jump"));
            }
        }

        @SubscribeEvent
        public void onPsiArmorEvent(PsiArmorEvent event) {
            for (int i = 0; i < 4; ++i) {
                ItemStack armor = (ItemStack)event.getEntityPlayer().field_71071_by.field_70460_b.get(i);
                if (armor.func_190926_b() || !(armor.func_77973_b() instanceof IPsiEventArmor)) continue;
                IPsiEventArmor handler = (IPsiEventArmor)armor.func_77973_b();
                handler.onEvent(armor, event);
            }
        }

        @SubscribeEvent
        public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            PlayerDataHandler.get((EntityPlayer)event.player).eidosChangelog.clear();
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void onRenderWorldLast(RenderWorldLastEvent event) {
            Minecraft mc = Minecraft.func_71410_x();
            Entity cameraEntity = mc.func_175606_aa();
            cameraEntity.func_180425_c();
            Frustum frustum = new Frustum();
            float partialTicks = event.getPartialTicks();
            double viewX = cameraEntity.field_70142_S + (cameraEntity.field_70165_t - cameraEntity.field_70142_S) * (double)partialTicks;
            double viewY = cameraEntity.field_70137_T + (cameraEntity.field_70163_u - cameraEntity.field_70137_T) * (double)partialTicks;
            double viewZ = cameraEntity.field_70136_U + (cameraEntity.field_70161_v - cameraEntity.field_70136_U) * (double)partialTicks;
            frustum.func_78547_a(viewX, viewY, viewZ);
            for (EntityPlayer player : mc.field_71441_e.field_73010_i) {
                PlayerDataHandler.get(player).render(player, partialTicks);
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void onFOVUpdate(FOVUpdateEvent event) {
            PlayerData data = PlayerDataHandler.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            if (data.isAnchored) {
                float fov = event.getNewfov();
                fov = data.eidosAnchorTime > 0 ? (fov *= Math.min(5.0f, (float)data.eidosAnchorTime - ClientTickHandler.partialTicks) / 5.0f) : (fov *= (10.0f - Math.min(10.0f, (float)data.postAnchorRecallTime + ClientTickHandler.partialTicks)) / 10.0f);
                event.setNewfov(fov);
            }
        }
    }
}

