/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.collect.ObjectArrays;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.api.util.RenderContextList;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.util.BakedQuadRetextured;

@ParametersAreNonnullByDefault
public class ModelBakedCTM
extends AbstractCTMBakedModel {
    private static final EnumFacing[] FACINGS = (EnumFacing[])ObjectArrays.concat((Object[])EnumFacing.field_82609_l, (Object)null);

    public ModelBakedCTM(IModelCTM model, IBakedModel parent) {
        super(model, parent);
    }

    @Override
    protected AbstractCTMBakedModel createModel(@Nullable IBlockState state, IModelCTM model, @Nullable RenderContextList ctx, long rand) {
        IBakedModel parent = this.getParent(rand);
        ModelBakedCTM ret = new ModelBakedCTM(model, parent);
        for (BlockRenderLayer layer : LAYERS) {
            for (EnumFacing facing : FACINGS) {
                ArrayList<BakedQuad> quads;
                List parentQuads = parent.func_188616_a(state, facing, rand);
                if (facing != null) {
                    quads = new ArrayList<BakedQuad>();
                    ret.faceQuads.put((Object)layer, (Object)facing, quads);
                } else {
                    quads = ret.genQuads.get((Object)layer);
                }
                LinkedHashMap texturemap = new LinkedHashMap();
                for (Object q : parentQuads) {
                    ICTMTexture<?> tex2 = this.getModel().getOverrideTexture(q.func_178211_c(), q.func_187508_a().func_94215_i());
                    if (tex2 == null) {
                        tex2 = this.getModel().getTexture(q.func_187508_a().func_94215_i());
                    }
                    if (tex2 == null) continue;
                    TextureAtlasSprite spriteReplacement = this.getModel().getOverrideSprite(q.func_178211_c());
                    if (spriteReplacement != null) {
                        q = new BakedQuadRetextured((BakedQuad)q, spriteReplacement);
                    }
                    texturemap.put((BakedQuad)q, tex2);
                }
                int quadGoal = ctx == null ? 1 : texturemap.values().stream().mapToInt(tex -> tex.getType().getQuadsPerSide()).max().orElse(1);
                for (Map.Entry e : texturemap.entrySet()) {
                    if (((ICTMTexture)e.getValue()).getLayer() != layer && (((ICTMTexture)e.getValue()).getLayer() != null || state != null && !state.func_177230_c().canRenderInLayer(state, layer))) continue;
                    ITextureContext tcx = ctx == null ? null : ctx.getRenderContext((ICTMTexture)e.getValue());
                    quads.addAll(((ICTMTexture)e.getValue()).transformQuad((BakedQuad)e.getKey(), tcx, quadGoal));
                }
            }
        }
        return ret;
    }

    @Override
    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.getParent().func_177554_e();
    }

    @Override
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)this.getParent().handlePerspective(cameraTransformType).getRight());
    }
}

