/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.IChiselFace;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.model.ModelBakedCTM;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;
import team.chisel.ctm.client.texture.render.TextureNormal;
import team.chisel.ctm.client.texture.type.TextureTypeNormal;
import team.chisel.ctm.client.util.ResourceUtil;

public class ModelCTM
implements IModelCTM {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(IMetadataSectionCTM.class, (Object)new IMetadataSectionCTM.Serializer()).create();
    private final ModelBlock modelinfo;
    private final IModel parentmodel;
    private final Int2ObjectMap<JsonElement> overrides;
    protected final Int2ObjectMap<IMetadataSectionCTM> metaOverrides = new Int2ObjectArrayMap();
    protected Int2ObjectMap<TextureAtlasSprite> spriteOverrides;
    protected Map<Pair<Integer, String>, ICTMTexture<?>> textureOverrides;
    private final Collection<ResourceLocation> textureDependencies;
    private transient byte layers;
    private Map<String, ICTMTexture<?>> textures = new HashMap();

    public ModelCTM(ModelBlock modelinfo, IModel parent, Int2ObjectMap<JsonElement> overrides) throws IOException {
        IMetadataSectionCTM meta;
        this.modelinfo = modelinfo;
        this.parentmodel = parent;
        this.overrides = overrides;
        this.textureDependencies = new HashSet<ResourceLocation>();
        this.textureDependencies.addAll(this.parentmodel.getTextures());
        for (Map.Entry e : this.overrides.entrySet()) {
            meta = null;
            if (((JsonElement)e.getValue()).isJsonPrimitive() && ((JsonElement)e.getValue()).getAsJsonPrimitive().isString()) {
                ResourceLocation rl = new ResourceLocation(((JsonElement)e.getValue()).getAsString());
                meta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(rl));
                this.textureDependencies.add(rl);
            } else if (((JsonElement)e.getValue()).isJsonObject()) {
                JsonObject obj = ((JsonElement)e.getValue()).getAsJsonObject();
                if (!obj.has("ctm_version")) {
                    obj.add("ctm_version", (JsonElement)new JsonPrimitive((Number)1));
                }
                meta = (IMetadataSectionCTM)GSON.fromJson((JsonElement)obj, IMetadataSectionCTM.class);
            }
            if (meta == null) continue;
            this.metaOverrides.put(e.getKey(), (Object)meta);
            this.textureDependencies.addAll(Arrays.asList(meta.getAdditionalTextures()));
        }
        for (ResourceLocation res : this.getTextures()) {
            meta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(res));
            if (meta == null || meta.getType().requiredTextures() == meta.getAdditionalTextures().length + 1) continue;
            throw new IOException(String.format("Texture type %s requires exactly %d textures. %d were provided.", meta.getType(), meta.getType().requiredTextures(), meta.getAdditionalTextures().length + 1));
        }
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptySet();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.textureDependencies;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel parent = this.parentmodel.bake(state, format, rl -> {
            TextureAtlasSprite sprite = (TextureAtlasSprite)bakedTextureGetter.apply((ResourceLocation)rl);
            IMetadataSectionCTM chiselmeta = null;
            try {
                chiselmeta = ResourceUtil.getMetadata(sprite);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IMetadataSectionCTM meta = chiselmeta;
            this.textures.computeIfAbsent(sprite.func_94215_i(), s -> {
                TextureNormal tex = meta == null ? new TextureNormal(TextureTypeNormal.INSTANCE, new TextureInfo(new TextureAtlasSprite[]{sprite}, Optional.empty(), null)) : meta.makeTexture(sprite, bakedTextureGetter);
                this.layers = (byte)(this.layers | 1 << (tex.getLayer() == null ? 7 : tex.getLayer().ordinal()));
                return tex;
            });
            return sprite;
        });
        if (this.spriteOverrides == null) {
            this.spriteOverrides = new Int2ObjectArrayMap();
            for (Map.Entry e : this.overrides.entrySet()) {
                if (!((JsonElement)e.getValue()).isJsonPrimitive() || !((JsonElement)e.getValue()).getAsJsonPrimitive().isString()) continue;
                TextureAtlasSprite sprite = bakedTextureGetter.apply(new ResourceLocation(((JsonElement)e.getValue()).getAsString()));
                this.spriteOverrides.put(e.getKey(), (Object)sprite);
            }
        }
        if (this.textureOverrides == null) {
            this.textureOverrides = new HashMap();
            for (Map.Entry e : this.metaOverrides.entrySet()) {
                List<BlockPartFace> matches = this.modelinfo.func_178298_a().stream().flatMap(b -> b.field_178240_c.values().stream()).filter(b -> b.field_178245_c == (Integer)e.getKey()).collect(Collectors.toList());
                HashMultimap bySprite = HashMultimap.create();
                matches.forEach(arg_0 -> this.lambda$bake$4((Multimap)bySprite, arg_0));
                for (Map.Entry e2 : bySprite.asMap().entrySet()) {
                    ResourceLocation texLoc = new ResourceLocation((String)e2.getKey());
                    TextureAtlasSprite sprite = this.getOverrideSprite((Integer)e.getKey());
                    if (sprite == null) {
                        sprite = bakedTextureGetter.apply(texLoc);
                    }
                    ICTMTexture<?> tex = ((IMetadataSectionCTM)e.getValue()).makeTexture(sprite, bakedTextureGetter);
                    this.textureOverrides.put((Pair<Integer, String>)Pair.of(e.getKey(), (Object)texLoc.toString()), tex);
                }
            }
        }
        return new ModelBakedCTM(this, parent);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public void load() {
    }

    @Override
    public Collection<ICTMTexture<?>> getChiselTextures() {
        return ImmutableList.builder().addAll(this.textures.values()).addAll(this.textureOverrides.values()).build();
    }

    @Override
    public ICTMTexture<?> getTexture(String iconName) {
        return this.textures.get(iconName);
    }

    @Override
    @Deprecated
    public IChiselFace getFace(EnumFacing facing) {
        return null;
    }

    @Override
    @Deprecated
    public IChiselFace getDefaultFace() {
        return null;
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return this.layers < 0 && state.func_177230_c().func_180664_k() == layer || (this.layers >> layer.ordinal() & 1) == 1;
    }

    @Override
    public boolean ignoreStates() {
        return false;
    }

    @Override
    @Nullable
    public TextureAtlasSprite getOverrideSprite(int tintIndex) {
        return (TextureAtlasSprite)this.spriteOverrides.get(tintIndex);
    }

    @Override
    @Nullable
    public ICTMTexture<?> getOverrideTexture(int tintIndex, String sprite) {
        return this.textureOverrides.get(Pair.of((Object)tintIndex, (Object)sprite));
    }

    private /* synthetic */ void lambda$bake$4(Multimap bySprite, BlockPartFace part) {
        bySprite.put((Object)this.modelinfo.field_178318_c.getOrDefault(part.field_178242_d.substring(1), part.field_178242_d), (Object)part);
    }
}

